/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor14;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.TypeKindVisitor8;
import javax.lang.model.util.Types;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.util.AssertionUtil;

public class MoreTypes
implements Types {
    private final Context ctx;
    private final Types typeUtils;

    public MoreTypes(Context ctx, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)env);
        this.ctx = ctx;
        this.typeUtils = env.getTypeUtils();
    }

    @Override
    public Element asElement(TypeMirror t) {
        return this.typeUtils.asElement(t);
    }

    @Override
    public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        return this.typeUtils.isSubtype(t1, t2);
    }

    @Override
    public boolean contains(TypeMirror t1, TypeMirror t2) {
        return this.typeUtils.contains(t1, t2);
    }

    @Override
    public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
        return this.typeUtils.isSubsignature(m1, m2);
    }

    @Override
    public List<? extends TypeMirror> directSupertypes(TypeMirror t) {
        return this.typeUtils.directSupertypes(t);
    }

    @Override
    public TypeMirror erasure(TypeMirror t) {
        return this.typeUtils.erasure(t);
    }

    @Override
    public TypeElement boxedClass(PrimitiveType p) {
        return this.typeUtils.boxedClass(p);
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror t) {
        return this.typeUtils.unboxedType(t);
    }

    @Override
    public TypeMirror capture(TypeMirror t) {
        return this.typeUtils.capture(t);
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind kind) {
        return this.typeUtils.getPrimitiveType(kind);
    }

    @Override
    public NullType getNullType() {
        return this.typeUtils.getNullType();
    }

    @Override
    public NoType getNoType(TypeKind kind) {
        return this.typeUtils.getNoType(kind);
    }

    @Override
    public ArrayType getArrayType(TypeMirror componentType) {
        return this.typeUtils.getArrayType(componentType);
    }

    @Override
    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        return this.typeUtils.getWildcardType(extendsBound, superBound);
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.typeUtils.getDeclaredType(typeElem, typeArgs);
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.typeUtils.getDeclaredType(containing, typeElem, typeArgs);
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        return this.typeUtils.asMemberOf(containing, element);
    }

    @Override
    public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
        return this.typeUtils.isAssignable(t1, t2);
    }

    @Override
    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        return this.typeUtils.isSameType(t1, t2);
    }

    public TypeElement toTypeElement(TypeMirror typeMirror) {
        AssertionUtil.assertNotNull((Object)typeMirror);
        Element element = this.typeUtils.asElement(typeMirror);
        if (element == null) {
            return null;
        }
        return this.ctx.getMoreElements().toTypeElement(element);
    }

    public DeclaredType toDeclaredType(TypeMirror typeMirror) {
        AssertionUtil.assertNotNull((Object)typeMirror);
        return typeMirror.accept(new SimpleTypeVisitor8<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
    }

    public TypeVariable toTypeVariable(TypeMirror typeMirror) {
        AssertionUtil.assertNotNull((Object)typeMirror);
        return typeMirror.accept(new SimpleTypeVisitor8<TypeVariable, Void>(){

            @Override
            public TypeVariable visitTypeVariable(TypeVariable t, Void p) {
                return t;
            }
        }, null);
    }

    public ArrayType toArrayType(TypeMirror typeMirror) {
        AssertionUtil.assertNotNull((Object)typeMirror);
        return typeMirror.accept(new SimpleTypeVisitor14<ArrayType, Void>(){

            @Override
            public ArrayType visitArray(ArrayType t, Void p) {
                return t;
            }
        }, null);
    }

    public boolean isAssignableWithErasure(TypeMirror lhs, Class<?> rhs) {
        AssertionUtil.assertNotNull((Object)lhs, rhs);
        TypeElement typeElement = this.ctx.getMoreElements().getTypeElement(rhs);
        if (typeElement == null) {
            return false;
        }
        return this.isAssignableWithErasure(lhs, typeElement.asType());
    }

    public boolean isAssignableWithErasure(TypeMirror lhs, TypeMirror rhs) {
        TypeMirror t2;
        AssertionUtil.assertNotNull((Object)lhs, (Object)rhs);
        if (lhs.getKind() == TypeKind.NONE || rhs.getKind() == TypeKind.NONE) {
            return false;
        }
        if (lhs.getKind() == TypeKind.NULL) {
            return rhs.getKind() == TypeKind.NULL;
        }
        if (rhs.getKind() == TypeKind.NULL) {
            return lhs.getKind() == TypeKind.NULL;
        }
        if (lhs.getKind() == TypeKind.VOID) {
            return rhs.getKind() == TypeKind.VOID;
        }
        if (rhs.getKind() == TypeKind.VOID) {
            return lhs.getKind() == TypeKind.VOID;
        }
        TypeMirror t1 = this.typeUtils.erasure(lhs);
        if (this.typeUtils.isSameType(t1, t2 = this.typeUtils.erasure(rhs)) || t1.equals(t2)) {
            return true;
        }
        for (TypeMirror typeMirror : this.typeUtils.directSupertypes(t1)) {
            if (!this.isAssignableWithErasure(typeMirror, t2)) continue;
            return true;
        }
        return false;
    }

    public boolean isSameTypeWithErasure(TypeMirror typeMirror, Class<?> clazz) {
        AssertionUtil.assertNotNull((Object)typeMirror, clazz);
        if (clazz.isPrimitive() || clazz.isArray()) {
            return this.typeUtils.isSameType(typeMirror, this.getTypeMirror(clazz));
        }
        TypeElement typeElement = this.ctx.getMoreElements().getTypeElement(clazz);
        if (typeElement == null) {
            return false;
        }
        return this.isSameTypeWithErasure(typeMirror, typeElement.asType());
    }

    public boolean isSameTypeWithErasure(TypeMirror t1, TypeMirror t2) {
        TypeMirror erasureType2;
        AssertionUtil.assertNotNull((Object)t1, (Object)t2);
        if (t1.getKind() == TypeKind.NONE || t2.getKind() == TypeKind.NONE) {
            return false;
        }
        if (t1.getKind() == TypeKind.NULL) {
            return t2.getKind() == TypeKind.NULL;
        }
        if (t2.getKind() == TypeKind.NULL) {
            return t1.getKind() == TypeKind.NULL;
        }
        if (t1.getKind() == TypeKind.VOID) {
            return t2.getKind() == TypeKind.VOID;
        }
        if (t2.getKind() == TypeKind.VOID) {
            return t1.getKind() == TypeKind.VOID;
        }
        TypeMirror erasureType1 = this.typeUtils.erasure(t1);
        return this.typeUtils.isSameType(erasureType1, erasureType2 = this.typeUtils.erasure(t2)) || erasureType1.equals(erasureType2);
    }

    public boolean isArray(TypeMirror typeMirror) {
        AssertionUtil.assertNotNull((Object)typeMirror);
        return typeMirror.getKind() == TypeKind.ARRAY;
    }

    public String getTypeName(TypeMirror typeMirror) {
        AssertionUtil.assertNotNull((Object)typeMirror);
        StringBuilder p = new StringBuilder();
        typeMirror.accept(new TypeNameBuilder(), p);
        return p.toString();
    }

    List<String> getTypeParameterNames(List<TypeMirror> typeMirrors) {
        AssertionUtil.assertNotNull(typeMirrors);
        TypeParameterNameBuilder builder = new TypeParameterNameBuilder();
        ArrayList<String> names = new ArrayList<String>();
        for (TypeMirror t : typeMirrors) {
            StringBuilder p = new StringBuilder();
            t.accept(builder, p);
            names.add(p.toString());
        }
        return names;
    }

    public TypeMirror boxIfPrimitive(TypeMirror typeMirror) {
        AssertionUtil.assertNotNull((Object)typeMirror);
        return typeMirror.accept(new TypeKindVisitor8<TypeMirror, Void>(){

            @Override
            public TypeMirror visitPrimitive(PrimitiveType t, Void p) {
                return MoreTypes.this.typeUtils.boxedClass(t).asType();
            }

            @Override
            protected TypeMirror defaultAction(TypeMirror e, Void p) {
                return e;
            }
        }, null);
    }

    public TypeMirror getTypeMirror(Class<?> clazz) {
        AssertionUtil.assertNotNull(clazz);
        if (clazz == Void.TYPE) {
            return this.typeUtils.getNoType(TypeKind.VOID);
        }
        if (clazz == Boolean.TYPE) {
            return this.typeUtils.getPrimitiveType(TypeKind.BOOLEAN);
        }
        if (clazz == Character.TYPE) {
            return this.typeUtils.getPrimitiveType(TypeKind.CHAR);
        }
        if (clazz == Byte.TYPE) {
            return this.typeUtils.getPrimitiveType(TypeKind.BYTE);
        }
        if (clazz == Short.TYPE) {
            return this.typeUtils.getPrimitiveType(TypeKind.SHORT);
        }
        if (clazz == Integer.TYPE) {
            return this.typeUtils.getPrimitiveType(TypeKind.INT);
        }
        if (clazz == Long.TYPE) {
            return this.typeUtils.getPrimitiveType(TypeKind.LONG);
        }
        if (clazz == Float.TYPE) {
            return this.typeUtils.getPrimitiveType(TypeKind.FLOAT);
        }
        if (clazz == Double.TYPE) {
            return this.typeUtils.getPrimitiveType(TypeKind.DOUBLE);
        }
        if (clazz.isArray()) {
            TypeMirror componentType = this.getTypeMirror(clazz.getComponentType());
            return this.typeUtils.getArrayType(componentType);
        }
        TypeElement typeElement = this.ctx.getMoreElements().getTypeElement(clazz);
        if (typeElement == null) {
            throw new AptIllegalStateException(clazz.getName());
        }
        return typeElement.asType();
    }

    private class TypeNameBuilder
    extends TypeKindVisitor8<Void, StringBuilder> {
        private TypeNameBuilder() {
        }

        @Override
        public Void visitNoTypeAsVoid(NoType t, StringBuilder p) {
            p.append("void");
            return null;
        }

        @Override
        public Void visitNoTypeAsNone(NoType t, StringBuilder stringBuilder) {
            return null;
        }

        @Override
        public Void visitPrimitive(PrimitiveType t, StringBuilder p) {
            p.append(t.getKind().name().toLowerCase());
            return null;
        }

        @Override
        public Void visitArray(ArrayType t, StringBuilder p) {
            t.getComponentType().accept(this, p);
            p.append("[]");
            return null;
        }

        @Override
        public Void visitDeclared(DeclaredType t, StringBuilder p) {
            TypeElement e = MoreTypes.this.toTypeElement(t);
            if (e != null) {
                p.append(e.getQualifiedName());
            }
            if (!t.getTypeArguments().isEmpty()) {
                p.append("<");
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    typeMirror.accept(this, p);
                    p.append(", ");
                }
                p.setLength(p.length() - 2);
                p.append(">");
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, StringBuilder p) {
            p.append(t);
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t, StringBuilder p) {
            TypeMirror superBound;
            p.append("?");
            TypeMirror extendsBound = t.getExtendsBound();
            if (extendsBound != null) {
                p.append(" extends ");
                extendsBound.accept(this, p);
            }
            if ((superBound = t.getSuperBound()) != null) {
                p.append(" super ");
                superBound.accept(this, p);
            }
            return null;
        }

        @Override
        protected Void defaultAction(TypeMirror e, StringBuilder p) {
            p.append(e);
            return null;
        }
    }

    private class TypeParameterNameBuilder
    extends TypeNameBuilder {
        private final Set<TypeVariable> processedVariables = new HashSet<TypeVariable>();

        private TypeParameterNameBuilder() {
        }

        @Override
        public Void visitPrimitive(PrimitiveType t, StringBuilder p) {
            if (p.length() == 0) {
                p.append(t);
            } else {
                TypeElement e = MoreTypes.this.typeUtils.boxedClass(t);
                p.append(e.getSimpleName());
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, StringBuilder p) {
            p.append(t);
            if (this.processedVariables.contains(t)) {
                return null;
            }
            this.processedVariables.add(t);
            TypeParameterElement typeParameterElement = MoreTypes.this.ctx.getMoreElements().toTypeParameterElement(t.asElement());
            if (typeParameterElement == null) {
                return null;
            }
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            if (bounds.isEmpty()) {
                return null;
            }
            Iterator<? extends TypeMirror> it = bounds.iterator();
            TypeMirror first = it.next();
            if (bounds.size() == 1 && MoreTypes.this.ctx.getMoreTypes().isSameTypeWithErasure(first, Object.class)) {
                return null;
            }
            p.append(" extends ");
            first.accept(this, p);
            while (it.hasNext()) {
                p.append("&");
                TypeMirror bound = it.next();
                bound.accept(this, p);
            }
            return null;
        }

        @Override
        public Void visitIntersection(IntersectionType t, StringBuilder p) {
            Iterator<? extends TypeMirror> it = t.getBounds().iterator();
            while (it.hasNext()) {
                TypeMirror bound = it.next();
                bound.accept(this, p);
                if (!it.hasNext()) continue;
                p.append("&");
            }
            return null;
        }
    }
}

