/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.decl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.MoreTypes;
import org.seasar.doma.internal.apt.cttype.ArrayCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.decl.ConstructorDeclaration;
import org.seasar.doma.internal.apt.decl.FieldDeclaration;
import org.seasar.doma.internal.apt.decl.MethodDeclaration;
import org.seasar.doma.internal.apt.decl.TypeParameterDeclaration;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.internal.util.Zip;

public class TypeDeclaration {
    private static final Map<String, Integer> NUMBER_PRIORITY_MAP = new HashMap<String, Integer>();
    private final Context ctx;
    private final TypeMirror type;
    private final CtType ctType;
    private final TypeElement typeElement;
    private final Map<Name, List<TypeParameterDeclaration>> typeParameterDeclarationsMap;
    private final int numberPriority;

    protected TypeDeclaration(Context ctx, TypeMirror type, CtType ctType, TypeElement typeElement, Map<Name, List<TypeParameterDeclaration>> typeParameterDeclarationsMap) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)type, (Object)ctType, typeParameterDeclarationsMap);
        this.ctx = ctx;
        this.type = type;
        this.ctType = ctType;
        this.typeElement = typeElement;
        this.typeParameterDeclarationsMap = typeParameterDeclarationsMap;
        this.numberPriority = TypeDeclaration.determineNumberPriority(typeElement, type);
    }

    public TypeMirror getType() {
        return this.type;
    }

    public String getBinaryName() {
        if (this.typeElement == null) {
            return this.type.toString();
        }
        return this.ctx.getMoreElements().getBinaryName(this.typeElement).toString();
    }

    public boolean isUnknownType() {
        return this.type.getKind() == TypeKind.NONE;
    }

    public boolean isNullType() {
        return this.type.getKind() == TypeKind.NULL;
    }

    public boolean isBooleanType() {
        return this.type.getKind() == TypeKind.BOOLEAN || this.ctx.getMoreTypes().isSameTypeWithErasure(this.type, Boolean.class);
    }

    public boolean isTextType() {
        return this.type.getKind() == TypeKind.CHAR || this.ctx.getMoreTypes().isSameTypeWithErasure(this.type, String.class) || this.ctx.getMoreTypes().isSameTypeWithErasure(this.type, Character.class);
    }

    public boolean isNumberType() {
        switch (this.type.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        if (this.typeElement == null) {
            return false;
        }
        String canonicalName = this.typeElement.getQualifiedName().toString();
        return NUMBER_PRIORITY_MAP.containsKey(canonicalName);
    }

    public boolean is(Class<?> clazz) {
        return this.ctx.getMoreTypes().isSameTypeWithErasure(this.type, clazz);
    }

    public boolean isScalarType() {
        return this.ctType.accept(new ScalarDetector(), null);
    }

    public boolean isScalarIterableType() {
        return this.ctType.accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(){

            @Override
            protected Boolean defaultAction(CtType ctType, Void aVoid) {
                return false;
            }

            @Override
            public Boolean visitIterableCtType(IterableCtType ctType, Void aVoid) {
                return ctType.getElementCtType().accept(new ScalarDetector(), aVoid);
            }
        }, null);
    }

    public boolean isScalarArrayType() {
        return this.ctType.accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(){

            @Override
            protected Boolean defaultAction(CtType ctType, Void aVoid) {
                return false;
            }

            @Override
            public Boolean visitArrayCtType(ArrayCtType ctType, Void aVoid) {
                return ctType.getElementCtType().accept(new ScalarDetector(), aVoid);
            }
        }, null);
    }

    public List<TypeParameterDeclaration> getTypeParameterDeclarations() {
        Optional<List<TypeParameterDeclaration>> typeParameterDeclarations = this.typeParameterDeclarationsMap.values().stream().findFirst();
        return typeParameterDeclarations.orElse(Collections.emptyList());
    }

    public List<TypeParameterDeclaration> getAllTypeParameterDeclarations() {
        return this.typeParameterDeclarationsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Optional<ConstructorDeclaration> getConstructorDeclaration(List<TypeDeclaration> parameterTypeDeclarations) {
        if (this.typeElement == null) {
            return Optional.empty();
        }
        return ElementFilter.constructorsIn(this.typeElement.getEnclosedElements()).stream().filter(c -> c.getModifiers().contains((Object)Modifier.PUBLIC)).filter(c -> c.getParameters().size() == parameterTypeDeclarations.size()).filter(c -> this.isAssignable(parameterTypeDeclarations, c.getParameters())).map(c -> this.ctx.getDeclarations().newConstructorDeclaration((ExecutableElement)c)).findAny();
    }

    public Optional<FieldDeclaration> getFieldDeclaration(String name) {
        return this.getFieldDeclarationInternal(name, false);
    }

    public Optional<FieldDeclaration> getStaticFieldDeclaration(String name) {
        return this.getFieldDeclarationInternal(name, true);
    }

    private Optional<FieldDeclaration> getFieldDeclarationInternal(String name, boolean statik) {
        List<FieldDeclaration> candidates = this.getCandidateFieldDeclarations(name, statik);
        this.removeHiddenFieldDeclarations(candidates);
        return candidates.stream().findFirst();
    }

    private List<FieldDeclaration> getCandidateFieldDeclarations(String name, boolean statik) {
        return this.typeParameterDeclarationsMap.entrySet().stream().map(e -> new Pair((Object)((Name)e.getKey()), (Object)((List)e.getValue()))).map(p -> new Pair((Object)this.ctx.getMoreElements().getTypeElement((CharSequence)p.fst), (Object)((List)p.snd))).filter(p -> Objects.nonNull(p.fst)).flatMap(p -> ElementFilter.fieldsIn(((TypeElement)p.fst).getEnclosedElements()).stream().filter(f -> !statik || f.getModifiers().contains((Object)Modifier.STATIC)).filter(f -> f.getSimpleName().contentEquals(name)).map(f -> this.ctx.getDeclarations().newFieldDeclaration((VariableElement)f, (List)p.snd))).collect(Collectors.toList());
    }

    private void removeHiddenFieldDeclarations(List<FieldDeclaration> candidates) {
        LinkedList<FieldDeclaration> hiders = new LinkedList<FieldDeclaration>(candidates);
        Iterator<FieldDeclaration> it = candidates.iterator();
        block0: while (it.hasNext()) {
            FieldDeclaration hidden = it.next();
            for (FieldDeclaration hider : hiders) {
                if (!this.ctx.getMoreElements().hides(hider.getElement(), hidden.getElement())) continue;
                it.remove();
                continue block0;
            }
        }
    }

    public Optional<MethodDeclaration> getMethodDeclaration(String name, List<TypeDeclaration> parameterTypeDeclarations) {
        return this.getMethodDeclarationInternal(name, parameterTypeDeclarations, false);
    }

    public Optional<MethodDeclaration> getStaticMethodDeclaration(String name, List<TypeDeclaration> parameterTypeDeclarations) {
        return this.getMethodDeclarationInternal(name, parameterTypeDeclarations, true);
    }

    private Optional<MethodDeclaration> getMethodDeclarationInternal(String name, List<TypeDeclaration> parameterTypeDeclarations, boolean statik) {
        List<MethodDeclaration> candidates = this.getCandidateMethodDeclarations(name, parameterTypeDeclarations, statik);
        this.removeOverriddenMethodDeclarations(candidates);
        this.removeHiddenMethodDeclarations(candidates);
        return candidates.stream().findFirst();
    }

    private List<MethodDeclaration> getCandidateMethodDeclarations(String name, List<TypeDeclaration> parameterTypeDeclarations, boolean statik) {
        return this.typeParameterDeclarationsMap.entrySet().stream().map(e -> new Pair((Object)((Name)e.getKey()), (Object)((List)e.getValue()))).map(p -> new Pair((Object)this.ctx.getMoreElements().getTypeElement((CharSequence)p.fst), (Object)((List)p.snd))).filter(p -> Objects.nonNull(p.fst)).flatMap(p -> ElementFilter.methodsIn(((TypeElement)p.fst).getEnclosedElements()).stream().filter(m -> !statik || m.getModifiers().contains((Object)Modifier.STATIC)).filter(m -> m.getModifiers().contains((Object)Modifier.PUBLIC)).filter(m -> m.getSimpleName().contentEquals(name)).filter(m -> m.getReturnType().getKind() != TypeKind.VOID).filter(m -> m.getParameters().size() == parameterTypeDeclarations.size()).filter(m -> this.isAssignable(parameterTypeDeclarations, m.getParameters())).map(m -> this.ctx.getDeclarations().newMethodDeclaration((ExecutableElement)m, (List)p.snd))).collect(Collectors.toList());
    }

    private void removeOverriddenMethodDeclarations(List<MethodDeclaration> candidates) {
        LinkedList<MethodDeclaration> overriders = new LinkedList<MethodDeclaration>(candidates);
        Iterator<MethodDeclaration> it = candidates.iterator();
        block0: while (it.hasNext()) {
            MethodDeclaration overridden = it.next();
            for (MethodDeclaration overrider : overriders) {
                TypeElement overriderTypeElement = this.ctx.getMoreElements().toTypeElement(overrider.getElement().getEnclosingElement());
                if (overriderTypeElement == null || !this.ctx.getMoreElements().overrides(overrider.getElement(), overridden.getElement(), overriderTypeElement)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    private void removeHiddenMethodDeclarations(List<MethodDeclaration> candidates) {
        LinkedList<MethodDeclaration> hiders = new LinkedList<MethodDeclaration>(candidates);
        Iterator<MethodDeclaration> it = candidates.iterator();
        block0: while (it.hasNext()) {
            MethodDeclaration hidden = it.next();
            for (MethodDeclaration hider : hiders) {
                TypeMirror subtype = hider.getElement().getEnclosingElement().asType();
                TypeMirror supertype = hidden.getElement().getEnclosingElement().asType();
                if (!this.ctx.getMoreTypes().isAssignableWithErasure(subtype, supertype) || !this.ctx.getMoreElements().hides(hider.getElement(), hidden.getElement())) continue;
                it.remove();
                continue block0;
            }
        }
    }

    public TypeDeclaration emulateConcatOperation(TypeDeclaration other) {
        AssertionUtil.assertNotNull((Object)other);
        AssertionUtil.assertTrue((boolean)this.isTextType(), (Object[])new Object[0]);
        AssertionUtil.assertTrue((boolean)other.isTextType(), (Object[])new Object[0]);
        TypeMirror type = this.ctx.getMoreTypes().getTypeMirror(String.class);
        return this.ctx.getDeclarations().newTypeDeclaration(type);
    }

    public TypeDeclaration emulateArithmeticOperation(TypeDeclaration other) {
        AssertionUtil.assertNotNull((Object)other);
        AssertionUtil.assertTrue((boolean)this.isNumberType(), (Object[])new Object[0]);
        AssertionUtil.assertTrue((boolean)other.isNumberType(), (Object[])new Object[0]);
        TypeMirror type = this.numberPriority >= other.numberPriority ? this.type : other.type;
        return this.ctx.getDeclarations().newTypeDeclaration(type);
    }

    public boolean isSameType(TypeDeclaration other) {
        if (this.ctx.getMoreTypes().isSameTypeWithErasure(this.type, other.type)) {
            return true;
        }
        if (this.isNumberType() && other.isNumberType()) {
            return this.numberPriority == other.numberPriority;
        }
        return false;
    }

    public String toString() {
        return this.type.toString();
    }

    private static int determineNumberPriority(TypeElement typeElement, TypeMirror type) {
        String canonicalName;
        Integer result;
        if (typeElement != null && (result = NUMBER_PRIORITY_MAP.get(canonicalName = typeElement.getQualifiedName().toString())) != null) {
            return result;
        }
        Integer result2 = NUMBER_PRIORITY_MAP.get(type.getKind().name().toLowerCase());
        if (result2 != null) {
            return result2;
        }
        return 0;
    }

    private boolean isAssignable(List<TypeDeclaration> parameterTypeDeclarations, List<? extends VariableElement> parameters) {
        MoreTypes types = this.ctx.getMoreTypes();
        return Zip.stream(parameterTypeDeclarations, parameters).map(p -> p.map(TypeDeclaration::getType, Element::asType)).map(p -> p.map(types::boxIfPrimitive, types::boxIfPrimitive)).allMatch(p -> types.isAssignableWithErasure((TypeMirror)p.fst, (TypeMirror)p.snd));
    }

    static {
        NUMBER_PRIORITY_MAP.put(BigDecimal.class.getName(), 80);
        NUMBER_PRIORITY_MAP.put(BigInteger.class.getName(), 70);
        NUMBER_PRIORITY_MAP.put(Double.TYPE.getName(), 60);
        NUMBER_PRIORITY_MAP.put(Double.class.getName(), 60);
        NUMBER_PRIORITY_MAP.put(Float.TYPE.getName(), 50);
        NUMBER_PRIORITY_MAP.put(Float.class.getName(), 50);
        NUMBER_PRIORITY_MAP.put(Long.TYPE.getName(), 40);
        NUMBER_PRIORITY_MAP.put(Long.class.getName(), 40);
        NUMBER_PRIORITY_MAP.put(Integer.TYPE.getName(), 30);
        NUMBER_PRIORITY_MAP.put(Integer.class.getName(), 30);
        NUMBER_PRIORITY_MAP.put(Short.TYPE.getName(), 20);
        NUMBER_PRIORITY_MAP.put(Short.class.getName(), 20);
        NUMBER_PRIORITY_MAP.put(Byte.TYPE.getName(), 10);
        NUMBER_PRIORITY_MAP.put(Byte.class.getName(), 10);
    }

    private static class ScalarDetector
    extends SimpleCtTypeVisitor<Boolean, Void, RuntimeException> {
        private ScalarDetector() {
            super(false);
        }

        @Override
        public Boolean visitBasicCtType(BasicCtType ctType, Void p) {
            return true;
        }

        @Override
        public Boolean visitDomainCtType(DomainCtType ctType, Void p) {
            return true;
        }
    }
}

