/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.Artifact;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.util.AssertionUtil;

public abstract class AbstractGenerator
implements Generator {
    protected final Context ctx;
    protected final ClassName className;
    protected final String packageName;
    protected final String simpleName;
    protected final Printer printer;

    protected AbstractGenerator(Context ctx, ClassName className, Printer printer) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)className, (Object)printer);
        this.ctx = ctx;
        this.className = className;
        this.packageName = className.getPackageName();
        this.simpleName = className.getSimpleName();
        this.printer = printer;
    }

    protected void printGenerated() {
        String annotationElements = String.format("value = { \"%s\", \"%s\" }, date = \"%tFT%<tT.%<tL%<tz\"", Artifact.getName(), this.ctx.getOptions().getVersion(), this.ctx.getOptions().getDate());
        TypeMirror generatedTypeMirror = this.getGeneratedTypeMirror();
        if (generatedTypeMirror == null) {
            this.iprint("// %s%n", annotationElements);
        }
        this.iprint("@%s(%s)%n", generatedTypeMirror, annotationElements);
    }

    protected void printValidateVersionStaticInitializer() {
        if (this.ctx.getOptions().getVersionValidation()) {
            this.iprint("static {%n", new Object[0]);
            this.iprint("    %1$s.validateVersion(\"%2$s\");%n", Artifact.class, this.ctx.getOptions().getVersion());
            this.iprint("}%n", new Object[0]);
            this.print("%n", new Object[0]);
        }
    }

    protected void iprint(String format, Object ... args) {
        this.printer.iprint(format, args);
    }

    protected void print(String format, Object ... args) {
        this.printer.print(format, args);
    }

    protected void indent() {
        this.printer.indent();
    }

    protected void unindent() {
        this.printer.unindent();
    }

    private TypeMirror getGeneratedTypeMirror() {
        TypeElement generatedElement = this.ctx.getMoreElements().getTypeElement("javax.annotation.processing.Generated");
        if (generatedElement != null) {
            return generatedElement.asType();
        }
        return null;
    }
}

