/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.seasar.doma.AnnotationTarget;
import org.seasar.doma.DaoImplementation;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.AnnotationAnnot;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.DaoImplQueryMethodGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.dao.DaoMeta;
import org.seasar.doma.internal.apt.meta.dao.ParentDaoMeta;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.jdbc.dao.DaoImplSupport;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.ConfigProvider;

public class DaoImplGenerator
extends AbstractGenerator {
    private final DaoMeta daoMeta;
    private final ParentDaoMeta parentDaoMeta;
    private final CharSequence parentDaoClassName;

    public DaoImplGenerator(Context ctx, ClassName className, Printer printer, DaoMeta daoMeta, Function<TypeElement, ClassName> classNameProvider) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)daoMeta, classNameProvider);
        this.daoMeta = daoMeta;
        this.parentDaoMeta = daoMeta.getParentDaoMeta();
        this.parentDaoClassName = this.parentDaoMeta == null ? null : (CharSequence)classNameProvider.apply(this.parentDaoMeta.getTypeElement());
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    private void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    private void printClass() {
        this.iprint("/** */%n", new Object[0]);
        for (AnnotationAnnot annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CLASS)) {
            this.iprint("@%1$s(%2$s)%n", annotation.getTypeValue(), annotation.getElementsValue());
        }
        this.printGenerated();
        this.printDaoImplementation();
        this.iprint("%4$s class %1$s implements %2$s, %3$s {%n", this.simpleName, this.daoMeta.getType(), ConfigProvider.class, this.daoMeta.getAccessLevel().getModifier());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printStaticFields();
        this.printFields();
        this.printConstructors();
        this.printMethods();
        this.unindent();
        this.print("}%n", new Object[0]);
    }

    private void printDaoImplementation() {
        this.iprint("@%1$s%n", DaoImplementation.class);
    }

    private void printStaticFields() {
        int index = 0;
        for (QueryMeta queryMeta : this.daoMeta.getQueryMetas()) {
            QueryKind kind = queryMeta.getQueryKind();
            if (kind != QueryKind.DEFAULT) {
                this.iprint("private static final %1$s __method%2$s = %3$s.getDeclaredMethod(%4$s.class, \"%5$s\"", Method.class, index, DaoImplSupport.class, this.daoMeta.getTypeElement(), queryMeta.getName());
                for (QueryParameterMeta parameterMeta : queryMeta.getParameterMetas()) {
                    this.print(", %1$s.class", parameterMeta.getQualifiedName());
                }
                this.print(");%n", new Object[0]);
                this.print("%n", new Object[0]);
            }
            ++index;
        }
    }

    private void printFields() {
        this.printSupportField();
        this.printParentField();
    }

    private void printSupportField() {
        this.iprint("private final %1$s __support;%n%n", DaoImplSupport.class);
    }

    private void printParentField() {
        if (this.hasParentDao()) {
            this.iprint("private final %1$s __parent;%n%n", this.parentDaoClassName);
        }
    }

    private void printConstructors() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @param config the config%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        for (AnnotationAnnot annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CONSTRUCTOR)) {
            this.iprint("@%1$s(%2$s)%n", annotation.getTypeValue(), annotation.getElementsValue());
        }
        this.iprint("public %1$s(", this.simpleName);
        for (AnnotationAnnot annotation : this.daoMeta.getAnnotationMirrors(AnnotationTarget.CONSTRUCTOR_PARAMETER)) {
            this.print("@%1$s(%2$s) ", annotation.getTypeValue(), annotation.getElementsValue());
        }
        this.print("%1$s config) {%n", Config.class);
        this.indent();
        this.iprint("__support = new %1$s(config);%n", DaoImplSupport.class);
        if (this.hasParentDao()) {
            this.iprint("__parent = new %1$s(config);%n", this.parentDaoClassName);
        }
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printMethods() {
        this.printGetConfigMethod();
        this.printDelegateMethods();
        this.printQueryMethods();
    }

    private void printGetConfigMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s getConfig() {%n", Config.class);
        this.indent();
        this.iprint("return __support.getConfig();%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printDelegateMethods() {
        if (this.hasParentDao()) {
            for (ExecutableElement method : this.parentDaoMeta.getMethods()) {
                this.printDelegateMethod(method);
            }
        }
    }

    private void printDelegateMethod(ExecutableElement method) {
        this.iprint("/** */%n", new Object[0]);
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public ", new Object[0]);
        if (!method.getTypeParameters().isEmpty()) {
            this.print("<%1$s> ", method.getTypeParameters());
        }
        this.print("%1$s ", method.getReturnType());
        this.print("%1$s(%2$s) ", method.getSimpleName(), method.getParameters().stream().map(it -> it.asType() + " " + it.getSimpleName()).collect(Collectors.toList()));
        if (!method.getThrownTypes().isEmpty()) {
            this.print("throws %1$s", method.getThrownTypes());
        }
        this.print("{%n", new Object[0]);
        this.indent();
        if (method.getReturnType().getKind() == TypeKind.VOID) {
            this.iprint("", new Object[0]);
        } else {
            this.iprint("return ", new Object[0]);
        }
        this.print("__parent.%1$s(%2$s);%n", method.getSimpleName(), method.getParameters().stream().map(VariableElement::getSimpleName).collect(Collectors.toList()));
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printQueryMethods() {
        int index = 0;
        for (QueryMeta queryMeta : this.daoMeta.getQueryMetas()) {
            DaoImplQueryMethodGenerator generator = new DaoImplQueryMethodGenerator(this.ctx, this.className, this.printer, this.daoMeta, queryMeta, index);
            generator.generate();
            ++index;
        }
    }

    private boolean hasParentDao() {
        return this.parentDaoMeta != null;
    }
}

