/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.dao;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import org.seasar.doma.DaoMethod;
import org.seasar.doma.Suppress;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.Annot;
import org.seasar.doma.internal.apt.annot.AnnotateWithAnnot;
import org.seasar.doma.internal.apt.annot.BatchModifyAnnot;
import org.seasar.doma.internal.apt.annot.DaoAnnot;
import org.seasar.doma.internal.apt.annot.ModifyAnnot;
import org.seasar.doma.internal.apt.annot.SqlAnnot;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.dao.DaoMeta;
import org.seasar.doma.internal.apt.meta.dao.ParentDaoMeta;
import org.seasar.doma.internal.apt.meta.query.ArrayCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.ArrayCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AutoBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoBatchModifyQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AutoFunctionQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoFunctionQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AutoModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoModifyQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AutoMultiInsertQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoMultiInsertQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AutoProcedureQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AutoProcedureQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.BlobCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.BlobCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.ClobCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.ClobCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.DefaultQueryMeta;
import org.seasar.doma.internal.apt.meta.query.DefaultQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.NClobCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.NClobCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryMetaVisitor;
import org.seasar.doma.internal.apt.meta.query.SQLXMLCreateQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SQLXMLCreateQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.SqlFileBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileBatchModifyQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.SqlFileModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileModifyQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.SqlFileScriptQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileScriptQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.SqlFileSelectQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileSelectQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.SqlProcessorQueryMeta;
import org.seasar.doma.internal.apt.meta.query.SqlProcessorQueryMetaFactory;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class DaoMetaFactory
implements TypeElementMetaFactory<DaoMeta> {
    private final Context ctx;
    private final List<BiFunction<TypeElement, ExecutableElement, QueryMetaFactory>> providers = new ArrayList<BiFunction<TypeElement, ExecutableElement, QueryMetaFactory>>(15);

    public DaoMetaFactory(Context ctx) {
        AssertionUtil.assertNotNull((Object)ctx);
        this.ctx = ctx;
        this.providers.add((dao, method) -> new SqlFileSelectQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new AutoModifyQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new AutoMultiInsertQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new AutoBatchModifyQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new AutoFunctionQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new AutoProcedureQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new SqlFileModifyQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new SqlFileBatchModifyQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new SqlFileScriptQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new DefaultQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new ArrayCreateQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new BlobCreateQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new ClobCreateQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new NClobCreateQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new SQLXMLCreateQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
        this.providers.add((dao, method) -> new SqlProcessorQueryMetaFactory(ctx, (TypeElement)dao, (ExecutableElement)method));
    }

    @Override
    public DaoMeta createTypeElementMeta(TypeElement interfaceElement) {
        AssertionUtil.assertNotNull((Object)interfaceElement);
        DaoAnnot daoAnnot = this.ctx.getAnnotations().newDaoAnnot(interfaceElement);
        if (daoAnnot == null) {
            throw new AptIllegalStateException("daoAnnot");
        }
        DaoMeta daoMeta = new DaoMeta(daoAnnot);
        this.doDaoElement(interfaceElement, daoMeta);
        this.doMethodElements(interfaceElement, daoMeta);
        this.validateFiles(interfaceElement, daoMeta);
        return daoMeta;
    }

    private void doDaoElement(TypeElement interfaceElement, DaoMeta daoMeta) {
        this.validateInterface(interfaceElement, daoMeta);
        String name = interfaceElement.getSimpleName().toString();
        String suffix = this.ctx.getOptions().getDaoSuffix();
        if (name.endsWith(suffix)) {
            this.ctx.getReporter().report(Diagnostic.Kind.WARNING, (MessageResource)Message.DOMA4026, interfaceElement, new Object[]{suffix});
        }
        daoMeta.setName(name);
        daoMeta.setTypeElement(interfaceElement);
        daoMeta.setType(interfaceElement.asType());
        this.doAnnotateWith(daoMeta);
        this.doParentDao(daoMeta);
    }

    private void validateInterface(TypeElement interfaceElement, DaoMeta daoMeta) {
        if (!interfaceElement.getKind().isInterface()) {
            DaoAnnot daoAnnot = daoMeta.getDaoAnnot();
            throw new AptException((MessageResource)Message.DOMA4014, (Element)interfaceElement, daoAnnot.getAnnotationMirror(), new Object[0]);
        }
        if (interfaceElement.getNestingKind().isNested()) {
            throw new AptException((MessageResource)Message.DOMA4017, interfaceElement, new Object[0]);
        }
        if (!interfaceElement.getTypeParameters().isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4059, interfaceElement, new Object[0]);
        }
    }

    private void doAnnotateWith(DaoMeta daoMeta) {
        List<AnnotateWithAnnot> annotateWithAnnots = this.ctx.getAnnotations().newAnnotateWithAnnots(daoMeta.getTypeElement());
        daoMeta.setAnnotateWithAnnots(annotateWithAnnots);
    }

    private void doParentDao(DaoMeta daoMeta) {
        List interfaces = daoMeta.getTypeElement().getInterfaces().stream().map(type -> this.ctx.getMoreTypes().toTypeElement((TypeMirror)type)).peek(element -> {
            if (element == null) {
                throw new AptIllegalStateException("failed to convert to TypeElement.");
            }
        }).collect(Collectors.toList());
        for (TypeElement typeElement : interfaces) {
            DaoAnnot daoAnnot = this.ctx.getAnnotations().newDaoAnnot(typeElement);
            if (daoAnnot == null) {
                ExecutableElement nonDefaultMethod = this.findNonDefaultMethod(typeElement);
                if (nonDefaultMethod == null) continue;
                throw new AptException((MessageResource)Message.DOMA4440, daoMeta.getTypeElement(), new Object[]{nonDefaultMethod.getSimpleName()});
            }
            if (daoMeta.getParentDaoMeta() != null) {
                throw new AptException((MessageResource)Message.DOMA4188, daoMeta.getTypeElement(), new Object[0]);
            }
            List<ExecutableElement> methods = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(it -> it.getModifiers().contains((Object)Modifier.PUBLIC)).filter(it -> !it.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
            ParentDaoMeta parentDaoMeta = new ParentDaoMeta(daoAnnot, typeElement, methods);
            daoMeta.setParentDaoMeta(parentDaoMeta);
        }
    }

    private ExecutableElement findNonDefaultMethod(TypeElement interfaceElement) {
        Optional<ExecutableElement> method = ElementFilter.methodsIn(interfaceElement.getEnclosedElements()).stream().filter(m -> !m.isDefault()).filter(m -> !this.ctx.getMoreElements().isVirtualDefaultMethod(interfaceElement, (ExecutableElement)m)).findAny();
        if (method.isPresent()) {
            return method.get();
        }
        for (TypeMirror typeMirror : interfaceElement.getInterfaces()) {
            TypeElement i = this.ctx.getMoreTypes().toTypeElement(typeMirror);
            if (i == null) {
                throw new AptIllegalStateException("failed to convert to TypeElement.");
            }
            ExecutableElement m2 = this.findNonDefaultMethod(i);
            if (m2 == null) continue;
            return m2;
        }
        return null;
    }

    private void doMethodElements(TypeElement interfaceElement, DaoMeta daoMeta) {
        for (ExecutableElement methodElement : ElementFilter.methodsIn(interfaceElement.getEnclosedElements())) {
            try {
                this.doMethodElement(interfaceElement, daoMeta, methodElement);
            }
            catch (AptException e) {
                this.ctx.getReporter().report(e);
                daoMeta.setError(true);
            }
        }
    }

    private void doMethodElement(TypeElement interfaceElement, DaoMeta daoMeta, ExecutableElement methodElement) {
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE)) {
            return;
        }
        this.validateMethod(interfaceElement, methodElement);
        QueryMeta queryMeta = this.createQueryMeta(daoMeta, methodElement);
        this.validateQueryMeta(queryMeta, methodElement);
        daoMeta.addQueryMeta(queryMeta);
        ParentDaoMeta parentDaoMeta = daoMeta.getParentDaoMeta();
        if (parentDaoMeta != null) {
            parentDaoMeta.getMethods().removeIf(it -> this.ctx.getMoreElements().overrides(methodElement, (ExecutableElement)it, interfaceElement));
        }
    }

    private void validateMethod(TypeElement interfaceElement, ExecutableElement methodElement) {
        TypeElement foundAnnotationTypeElement = null;
        for (AnnotationMirror annotationMirror : methodElement.getAnnotationMirrors()) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(declaredType);
            if (typeElement.getAnnotation(DaoMethod.class) == null) continue;
            if (foundAnnotationTypeElement != null) {
                throw new AptException((MessageResource)Message.DOMA4087, methodElement, new Object[]{foundAnnotationTypeElement.getQualifiedName(), typeElement.getQualifiedName()});
            }
            if (methodElement.isDefault() || this.ctx.getMoreElements().isVirtualDefaultMethod(interfaceElement, methodElement)) {
                throw new AptException((MessageResource)Message.DOMA4252, methodElement, new Object[]{typeElement.getQualifiedName()});
            }
            foundAnnotationTypeElement = typeElement;
        }
    }

    private QueryMeta createQueryMeta(DaoMeta daoMeta, ExecutableElement methodElement) {
        for (BiFunction<TypeElement, ExecutableElement, QueryMetaFactory> provider : this.providers) {
            QueryMetaFactory factory = provider.apply(daoMeta.getTypeElement(), methodElement);
            QueryMeta queryMeta = factory.createQueryMeta();
            if (queryMeta == null) continue;
            return queryMeta;
        }
        throw new AptException((MessageResource)Message.DOMA4005, methodElement, new Object[0]);
    }

    private void validateQueryMeta(QueryMeta queryMeta, ExecutableElement methodElement) {
        SqlAnnot sqlAnnot = this.ctx.getAnnotations().newSqlAnnot(methodElement);
        if (sqlAnnot != null) {
            queryMeta.accept(new SqlAnnotationCombinationValidator(methodElement, sqlAnnot));
        }
    }

    private void validateFiles(TypeElement interfaceElement, DaoMeta daoMeta) {
        Message message;
        if (daoMeta.isError()) {
            return;
        }
        if (!this.ctx.getOptions().getSqlValidation()) {
            return;
        }
        String dirPath = SqlFileUtil.buildPath((String)interfaceElement.getQualifiedName().toString());
        Set<String> fileNames = this.getFileNames(dirPath);
        for (QueryMeta queryMeta : daoMeta.getQueryMetas()) {
            for (String fileName : queryMeta.getFileNames()) {
                fileNames.remove(fileName);
            }
        }
        Suppress suppress = interfaceElement.getAnnotation(Suppress.class);
        if (!this.isSuppressed(suppress, message = Message.DOMA4220)) {
            for (String fileName : fileNames) {
                this.ctx.getReporter().report(Diagnostic.Kind.WARNING, (MessageResource)message, interfaceElement, new Object[]{dirPath + "/" + fileName});
            }
        }
    }

    private Set<String> getFileNames(String dirPath) {
        File dir = this.getDir(dirPath);
        if (dir == null) {
            return Collections.emptySet();
        }
        String[] fileNames = dir.list((dir1, name) -> name.endsWith(".sql") || name.endsWith(".script"));
        if (fileNames == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(fileNames));
    }

    private File getDir(String dirPath) {
        File dir;
        FileObject fileObject = this.getFileObject(dirPath);
        if (fileObject == null) {
            return null;
        }
        URI uri = fileObject.toUri();
        if (!uri.isAbsolute()) {
            uri = new File(".").toURI().resolve(uri);
        }
        if ((dir = new File(uri)).exists() && dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    private FileObject getFileObject(String path) {
        try {
            return this.ctx.getResources().getResource(path);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private boolean isSuppressed(Suppress suppress, Message message) {
        if (suppress != null) {
            for (Message suppressMessage : suppress.messages()) {
                if (suppressMessage != message) continue;
                return true;
            }
        }
        return false;
    }

    private static class SqlAnnotationCombinationValidator
    implements QueryMetaVisitor<Void> {
        private final ExecutableElement methodElement;
        private final SqlAnnot sqlAnnot;

        private SqlAnnotationCombinationValidator(ExecutableElement methodElement, SqlAnnot sqlAnnot) {
            AssertionUtil.assertNotNull((Object)methodElement, (Object)sqlAnnot);
            this.methodElement = methodElement;
            this.sqlAnnot = sqlAnnot;
        }

        @Override
        public Void visitSqlFileSelectQueryMeta(SqlFileSelectQueryMeta m) {
            return null;
        }

        @Override
        public Void visitSqlProcessorQueryMeta(SqlProcessorQueryMeta m) {
            return null;
        }

        @Override
        public Void visitSqlFileScriptQueryMeta(SqlFileScriptQueryMeta m) {
            return null;
        }

        @Override
        public Void visitAutoMultiInsertQueryMeta(AutoMultiInsertQueryMeta m) {
            return this.handleConflict(m.getMultiInsertAnnot());
        }

        @Override
        public Void visitAutoFunctionQueryMeta(AutoFunctionQueryMeta m) {
            return this.handleConflict(m.getFunctionAnnot());
        }

        @Override
        public Void visitAutoProcedureQueryMeta(AutoProcedureQueryMeta m) {
            return this.handleConflict(m.getProcedureAnnot());
        }

        @Override
        public Void visitArrayCreateQueryMeta(ArrayCreateQueryMeta m) {
            return this.handleConflict(m.getArrayFactoryAnnot());
        }

        @Override
        public Void visitBlobCreateQueryMeta(BlobCreateQueryMeta m) {
            return this.handleConflict(m.getBlobFactoryAnnot());
        }

        @Override
        public Void visitClobCreateQueryMeta(ClobCreateQueryMeta m) {
            return this.handleConflict(m.getClobFactoryAnnot());
        }

        @Override
        public Void visitNClobCreateQueryMeta(NClobCreateQueryMeta m) {
            return this.handleConflict(m.getNClobFactoryAnnot());
        }

        @Override
        public Void visitSQLXMLCreateQueryMeta(SQLXMLCreateQueryMeta m) {
            return this.handleConflict(m.getSqlxmlFactoryAnnot());
        }

        private Void handleConflict(Annot annot) {
            AssertionUtil.assertNotNull((Object)annot);
            throw new AptException((MessageResource)Message.DOMA4444, (Element)this.methodElement, this.sqlAnnot.getAnnotationMirror(), new Object[]{annot.getAnnotationMirror()});
        }

        @Override
        public Void visitSqlFileModifyQueryMeta(SqlFileModifyQueryMeta m) {
            ModifyAnnot annot = m.getModifyAnnot();
            if (annot.getSqlFileValue()) {
                this.handleConflictWithSqlFileElement(annot.getAnnotationMirror(), annot.getSqlFile());
            }
            return null;
        }

        @Override
        public Void visitSqlFileBatchModifyQueryMeta(SqlFileBatchModifyQueryMeta m) {
            BatchModifyAnnot annot = m.getBatchModifyAnnot();
            if (annot.getSqlFileValue()) {
                this.handleConflictWithSqlFileElement(annot.getAnnotationMirror(), annot.getSqlFile());
            }
            return null;
        }

        private Void handleConflictWithSqlFileElement(AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
            AssertionUtil.assertNotNull((Object)annotationMirror, (Object)annotationValue);
            throw new AptException((MessageResource)Message.DOMA4445, this.methodElement, annotationMirror, annotationValue, new Object[0]);
        }

        @Override
        public Void visitDefaultQueryMeta(DefaultQueryMeta m) {
            throw new AptException((MessageResource)Message.DOMA4446, (Element)this.methodElement, this.sqlAnnot.getAnnotationMirror(), new Object[0]);
        }

        @Override
        public Void visitAutoModifyQueryMeta(AutoModifyQueryMeta m) {
            AssertionUtil.assertUnreachable((String)"visitAutoModifyQueryMeta");
            return null;
        }

        @Override
        public Void visitAutoBatchModifyQueryMeta(AutoBatchModifyQueryMeta m) {
            AssertionUtil.assertUnreachable((String)"visitAutoBatchModifyQueryMeta");
            return null;
        }
    }
}

