/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import java.util.Objects;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;

public class ScopeParameterMeta
implements CharSequence {
    private final VariableElement parameter;
    private final TypeMirror type;
    private final String typeAndName;

    public ScopeParameterMeta(VariableElement parameter, TypeMirror type, boolean isVarArgs) {
        this.parameter = Objects.requireNonNull(parameter);
        this.type = Objects.requireNonNull(type);
        TypeMirror componentType = isVarArgs ? this.getComponentType(type) : null;
        this.typeAndName = componentType == null ? type + " " + parameter.getSimpleName() : componentType + "... " + parameter.getSimpleName();
    }

    private TypeMirror getComponentType(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<TypeMirror, Void>(){

            @Override
            public TypeMirror visitArray(ArrayType t, Void unused) {
                return t.getComponentType();
            }
        }, null);
    }

    public Name getName() {
        return this.parameter.getSimpleName();
    }

    public TypeMirror getType() {
        return this.type;
    }

    @Override
    public int length() {
        return this.typeAndName.length();
    }

    @Override
    public char charAt(int index) {
        return this.typeAndName.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.typeAndName.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.typeAndName;
    }
}

