/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.In;
import org.seasar.doma.InOut;
import org.seasar.doma.Out;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.ResultSetAnnot;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.ReferenceCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.parameter.BasicInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.BasicInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.BasicListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.BasicOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.CallableSqlParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.DomainOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.EntityListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.MapListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalBasicOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDomainOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalDoubleOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalIntOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongInOutParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongInParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongListParameterMeta;
import org.seasar.doma.internal.apt.meta.parameter.OptionalLongOutParameterMeta;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMeta;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AutoModuleQueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AutoModuleQueryMetaFactory<M extends AutoModuleQueryMeta>
extends AbstractQueryMetaFactory<M> {
    AutoModuleQueryMetaFactory(Context ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    @Override
    protected void doParameters(M queryMeta) {
        for (VariableElement variableElement : this.methodElement.getParameters()) {
            QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement);
            ((AbstractQueryMeta)queryMeta).addParameterMeta(parameterMeta);
            CallableSqlParameterMeta callableSqlParameterMeta = this.createParameterMeta(parameterMeta);
            ((AutoModuleQueryMeta)queryMeta).addCallableSqlParameterMeta(callableSqlParameterMeta);
            if (!parameterMeta.isBindable()) continue;
            ((AbstractQueryMeta)queryMeta).addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
    }

    private CallableSqlParameterMeta createParameterMeta(QueryParameterMeta parameterMeta) {
        ResultSetAnnot resultSetAnnot = this.ctx.getAnnotations().newResultSetAnnot(parameterMeta.getElement());
        if (resultSetAnnot != null) {
            return this.createResultSetParameterMeta(parameterMeta, resultSetAnnot);
        }
        if (parameterMeta.isAnnotated(In.class)) {
            return this.createInParameterMeta(parameterMeta);
        }
        if (parameterMeta.isAnnotated(Out.class)) {
            return this.createOutParameterMeta(parameterMeta);
        }
        if (parameterMeta.isAnnotated(InOut.class)) {
            return this.createInOutParameterMeta(parameterMeta);
        }
        throw new AptException((MessageResource)Message.DOMA4066, parameterMeta.getElement(), new Object[0]);
    }

    private CallableSqlParameterMeta createResultSetParameterMeta(QueryParameterMeta parameterMeta, ResultSetAnnot resultSetAnnot) {
        IterableCtType iterableCtType = parameterMeta.getCtType().accept(new ResultSetCtTypeVisitor(parameterMeta), null);
        return iterableCtType.getElementCtType().accept(new ResultSetElementCtTypeVisitor(parameterMeta, resultSetAnnot), false);
    }

    private CallableSqlParameterMeta createInParameterMeta(QueryParameterMeta parameterMeta) {
        return parameterMeta.getCtType().accept(new InCtTypeVisitor(parameterMeta), false);
    }

    private CallableSqlParameterMeta createOutParameterMeta(QueryParameterMeta parameterMeta) {
        ReferenceCtType referenceCtType = parameterMeta.getCtType().accept(new OutCtTypeVisitor(parameterMeta), null);
        return referenceCtType.getReferentCtType().accept(new OutReferentCtTypeVisitor(parameterMeta, referenceCtType), false);
    }

    private CallableSqlParameterMeta createInOutParameterMeta(QueryParameterMeta parameterMeta) {
        ReferenceCtType referenceCtType = parameterMeta.getCtType().accept(new InOutCtTypeVisitor(parameterMeta), null);
        return referenceCtType.getReferentCtType().accept(new InOutReferentCtTypeVisitor(parameterMeta, referenceCtType), false);
    }

    static class ResultSetCtTypeVisitor
    extends SimpleCtTypeVisitor<IterableCtType, Void, RuntimeException> {
        final QueryParameterMeta parameterMeta;

        ResultSetCtTypeVisitor(QueryParameterMeta parameterMeta) {
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected IterableCtType defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4062, this.parameterMeta.getElement(), new Object[0]);
        }

        @Override
        public IterableCtType visitIterableCtType(IterableCtType ctType, Void p) throws RuntimeException {
            if (!ctType.isList()) {
                this.defaultAction((CtType)ctType, p);
            }
            return ctType;
        }
    }

    static class ResultSetElementCtTypeVisitor
    extends SimpleCtTypeVisitor<CallableSqlParameterMeta, Boolean, RuntimeException> {
        final QueryParameterMeta parameterMeta;
        final ResultSetAnnot resultSetAnnot;

        ResultSetElementCtTypeVisitor(QueryParameterMeta parameterMeta, ResultSetAnnot resultSetAnnot) {
            this.parameterMeta = parameterMeta;
            this.resultSetAnnot = resultSetAnnot;
        }

        @Override
        protected CallableSqlParameterMeta defaultAction(CtType type, Boolean p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4186, this.parameterMeta.getElement(), new Object[]{type.getType()});
        }

        @Override
        public CallableSqlParameterMeta visitEntityCtType(EntityCtType ctType, Boolean p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4157, this.parameterMeta.getElement(), new Object[]{ctType.getType()});
            }
            return new EntityListParameterMeta(this.parameterMeta.getName(), ctType, this.resultSetAnnot.getEnsureResultMappingValue());
        }

        @Override
        public CallableSqlParameterMeta visitMapCtType(MapCtType ctType, Boolean p) throws RuntimeException {
            return new MapListParameterMeta(this.parameterMeta.getName(), ctType);
        }

        @Override
        public CallableSqlParameterMeta visitBasicCtType(BasicCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalBasicListParameterMeta(this.parameterMeta.getName(), ctType);
            }
            return new BasicListParameterMeta(this.parameterMeta.getName(), ctType);
        }

        @Override
        public CallableSqlParameterMeta visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalDomainListParameterMeta(this.parameterMeta.getName(), ctType);
            }
            return new DomainListParameterMeta(this.parameterMeta.getName(), ctType);
        }

        @Override
        public CallableSqlParameterMeta visitOptionalCtType(OptionalCtType ctType, Boolean p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public CallableSqlParameterMeta visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalIntListParameterMeta(this.parameterMeta.getName());
        }

        @Override
        public CallableSqlParameterMeta visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalLongListParameterMeta(this.parameterMeta.getName());
        }

        @Override
        public CallableSqlParameterMeta visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalDoubleListParameterMeta(this.parameterMeta.getName());
        }
    }

    static class InCtTypeVisitor
    extends SimpleCtTypeVisitor<CallableSqlParameterMeta, Boolean, RuntimeException> {
        final QueryParameterMeta parameterMeta;

        InCtTypeVisitor(QueryParameterMeta parameterMeta) {
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected CallableSqlParameterMeta defaultAction(CtType type, Boolean p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4101, this.parameterMeta.getElement(), new Object[]{this.parameterMeta.getType()});
        }

        @Override
        public CallableSqlParameterMeta visitBasicCtType(BasicCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalBasicInParameterMeta(this.parameterMeta.getName(), ctType);
            }
            return new BasicInParameterMeta(this.parameterMeta.getName(), ctType);
        }

        @Override
        public CallableSqlParameterMeta visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalDomainInParameterMeta(this.parameterMeta.getName(), ctType);
            }
            return new DomainInParameterMeta(this.parameterMeta.getName(), ctType);
        }

        @Override
        public CallableSqlParameterMeta visitOptionalCtType(OptionalCtType ctType, Boolean p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public CallableSqlParameterMeta visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalIntInParameterMeta(this.parameterMeta.getName());
        }

        @Override
        public CallableSqlParameterMeta visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalLongInParameterMeta(this.parameterMeta.getName());
        }

        @Override
        public CallableSqlParameterMeta visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalDoubleInParameterMeta(this.parameterMeta.getName());
        }
    }

    static class OutCtTypeVisitor
    extends SimpleCtTypeVisitor<ReferenceCtType, Void, RuntimeException> {
        final QueryParameterMeta parameterMeta;

        OutCtTypeVisitor(QueryParameterMeta parameterMeta) {
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected ReferenceCtType defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4098, this.parameterMeta.getElement(), new Object[0]);
        }

        @Override
        public ReferenceCtType visitReferenceCtType(ReferenceCtType ctType, Void p) throws RuntimeException {
            return ctType;
        }
    }

    static class OutReferentCtTypeVisitor
    extends SimpleCtTypeVisitor<CallableSqlParameterMeta, Boolean, RuntimeException> {
        final QueryParameterMeta parameterMeta;
        final ReferenceCtType referenceCtType;

        OutReferentCtTypeVisitor(QueryParameterMeta parameterMeta, ReferenceCtType referenceCtType) {
            this.parameterMeta = parameterMeta;
            this.referenceCtType = referenceCtType;
        }

        @Override
        protected CallableSqlParameterMeta defaultAction(CtType type, Boolean p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4100, this.parameterMeta.getElement(), new Object[]{this.referenceCtType.getReferentTypeMirror()});
        }

        @Override
        public CallableSqlParameterMeta visitBasicCtType(BasicCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalBasicOutParameterMeta(this.parameterMeta.getName(), ctType);
            }
            return new BasicOutParameterMeta(this.parameterMeta.getName(), ctType);
        }

        @Override
        public CallableSqlParameterMeta visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalDomainOutParameterMeta(this.parameterMeta.getName(), ctType);
            }
            return new DomainOutParameterMeta(this.parameterMeta.getName(), ctType);
        }

        @Override
        public CallableSqlParameterMeta visitOptionalCtType(OptionalCtType ctType, Boolean p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public CallableSqlParameterMeta visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalIntOutParameterMeta(this.parameterMeta.getName());
        }

        @Override
        public CallableSqlParameterMeta visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalLongOutParameterMeta(this.parameterMeta.getName());
        }

        @Override
        public CallableSqlParameterMeta visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalDoubleOutParameterMeta(this.parameterMeta.getName());
        }
    }

    static class InOutCtTypeVisitor
    extends SimpleCtTypeVisitor<ReferenceCtType, Void, RuntimeException> {
        final QueryParameterMeta parameterMeta;

        InOutCtTypeVisitor(QueryParameterMeta parameterMeta) {
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected ReferenceCtType defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4111, this.parameterMeta.getElement(), new Object[0]);
        }

        @Override
        public ReferenceCtType visitReferenceCtType(ReferenceCtType ctType, Void p) throws RuntimeException {
            return ctType;
        }
    }

    static class InOutReferentCtTypeVisitor
    extends SimpleCtTypeVisitor<CallableSqlParameterMeta, Boolean, RuntimeException> {
        final QueryParameterMeta parameterMeta;
        final ReferenceCtType referenceCtType;

        InOutReferentCtTypeVisitor(QueryParameterMeta parameterMeta, ReferenceCtType referenceCtType) {
            this.parameterMeta = parameterMeta;
            this.referenceCtType = referenceCtType;
        }

        @Override
        protected CallableSqlParameterMeta defaultAction(CtType type, Boolean p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4100, this.parameterMeta.getElement(), new Object[]{this.referenceCtType.getReferentTypeMirror()});
        }

        @Override
        public CallableSqlParameterMeta visitBasicCtType(BasicCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalBasicInOutParameterMeta(this.parameterMeta.getName(), ctType);
            }
            return new BasicInOutParameterMeta(this.parameterMeta.getName(), ctType);
        }

        @Override
        public CallableSqlParameterMeta visitDomainCtType(DomainCtType ctType, Boolean optional) throws RuntimeException {
            if (Boolean.TRUE == optional) {
                return new OptionalDomainInOutParameterMeta(this.parameterMeta.getName(), ctType);
            }
            return new DomainInOutParameterMeta(this.parameterMeta.getName(), ctType);
        }

        @Override
        public CallableSqlParameterMeta visitOptionalCtType(OptionalCtType ctType, Boolean p) throws RuntimeException {
            return ctType.getElementCtType().accept(this, true);
        }

        @Override
        public CallableSqlParameterMeta visitOptionalIntCtType(OptionalIntCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalIntInOutParameterMeta(this.parameterMeta.getName());
        }

        @Override
        public CallableSqlParameterMeta visitOptionalLongCtType(OptionalLongCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalLongInOutParameterMeta(this.parameterMeta.getName());
        }

        @Override
        public CallableSqlParameterMeta visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean p) throws RuntimeException {
            return new OptionalDoubleInOutParameterMeta(this.parameterMeta.getName());
        }
    }
}

