/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.Dao;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.generator.DaoImplGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.dao.DaoMeta;
import org.seasar.doma.internal.apt.meta.dao.DaoMetaFactory;
import org.seasar.doma.internal.apt.processor.AbstractGeneratingProcessor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ClassUtil;

@SupportedAnnotationTypes(value={"org.seasar.doma.Dao"})
@SupportedOptions(value={"doma.test", "doma.debug", "doma.dao.package", "doma.dao.subpackage", "doma.dao.suffix", "doma.expr.functions", "doma.sql.validation", "doma.version.validation", "doma.resources.dir", "doma.config.path", "doma.cdi.ApplicationScoped"})
public class DaoProcessor
extends AbstractGeneratingProcessor<DaoMeta> {
    private Function<TypeElement, ClassName> classNameProvider;

    public DaoProcessor() {
        super(Dao.class);
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.classNameProvider = this.createClassNameProvider();
    }

    @Override
    protected TypeElementMetaFactory<DaoMeta> createTypeElementMetaFactory() {
        return new DaoMetaFactory(this.ctx);
    }

    @Override
    protected ClassName createClassName(TypeElement typeElement, DaoMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        return this.classNameProvider.apply(typeElement);
    }

    @Override
    protected Generator createGenerator(ClassName className, Printer printer, DaoMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new DaoImplGenerator(this.ctx, className, printer, meta, this.classNameProvider);
    }

    private Function<TypeElement, ClassName> createClassNameProvider() {
        return typeElement -> {
            DaoImplClassNameBuilder builder = new DaoImplClassNameBuilder((TypeElement)typeElement);
            return builder.build();
        };
    }

    private class DaoImplClassNameBuilder {
        private final TypeElement typeElement;

        private DaoImplClassNameBuilder(TypeElement typeElement) {
            this.typeElement = typeElement;
        }

        protected String prefix() {
            String daoSubpackage;
            String daoPackage = DaoProcessor.this.ctx.getOptions().getDaoPackage();
            if (daoPackage != null) {
                return daoPackage + ".";
            }
            PackageElement packageElement = DaoProcessor.this.ctx.getMoreElements().getPackageOf(this.typeElement);
            Name packageName = packageElement.getQualifiedName();
            Object base = "";
            if (packageName.length() > 0) {
                base = packageName + ".";
            }
            if ((daoSubpackage = DaoProcessor.this.ctx.getOptions().getDaoSubpackage()) != null) {
                return (String)base + daoSubpackage + ".";
            }
            return base;
        }

        protected String infix() {
            Name binaryName = DaoProcessor.this.ctx.getMoreElements().getBinaryName(this.typeElement);
            String normalizedName = ClassNames.normalizeBinaryName((CharSequence)binaryName);
            return ClassUtil.getSimpleName((String)normalizedName);
        }

        protected String suffix() {
            return DaoProcessor.this.ctx.getOptions().getDaoSuffix();
        }

        public ClassName build() {
            return new ClassName(this.prefix() + this.infix() + this.suffix());
        }
    }
}

