/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.validator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.decl.TypeDeclaration;
import org.seasar.doma.internal.apt.validator.ExpressionValidator;
import org.seasar.doma.internal.expr.ExpressionException;
import org.seasar.doma.internal.expr.ExpressionParser;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.jdbc.sql.SimpleSqlNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.BindVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseifNode;
import org.seasar.doma.internal.jdbc.sql.node.EmbeddedVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.ExpandNode;
import org.seasar.doma.internal.jdbc.sql.node.ForNode;
import org.seasar.doma.internal.jdbc.sql.node.IfNode;
import org.seasar.doma.internal.jdbc.sql.node.LiteralVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.PopulateNode;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.jdbc.sql.node.ValueNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlValidator
extends SimpleSqlNodeVisitor<Void, Void> {
    private static final int SQL_MAX_LENGTH = 5000;
    protected final Context ctx;
    protected final ExecutableElement methodElement;
    private final LinkedHashMap<String, TypeMirror> parameterTypeMap;
    protected final String path;
    private final boolean expandable;
    private final boolean populatable;
    private final ExpressionValidator expressionValidator;

    public SqlValidator(Context ctx, ExecutableElement methodElement, LinkedHashMap<String, TypeMirror> parameterTypeMap, String path, boolean expandable, boolean populatable) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)methodElement, parameterTypeMap, (Object)path);
        this.ctx = ctx;
        this.methodElement = methodElement;
        this.parameterTypeMap = parameterTypeMap;
        this.path = path;
        this.expandable = expandable;
        this.populatable = populatable;
        this.expressionValidator = new ExpressionValidator(ctx, methodElement, parameterTypeMap);
    }

    public void validate(SqlNode sqlNode) {
        try {
            sqlNode.accept((SqlNodeVisitor)this, null);
            HashSet<String> unreferredName = new HashSet<String>(this.parameterTypeMap.keySet());
            unreferredName.removeAll(this.expressionValidator.getValidatedParameterNames());
            this.methodElement.getParameters().stream().filter(e -> unreferredName.contains(e.getSimpleName().toString())).forEach(this::reportUnreferredParameter);
        }
        catch (AptException e2) {
            this.ctx.getReporter().report(e2);
        }
    }

    private void reportUnreferredParameter(VariableElement e) {
        this.ctx.getReporter().report(Diagnostic.Kind.ERROR, (MessageResource)Message.DOMA4122, e, new Object[]{this.path, e.getSimpleName()});
    }

    public Void visitBindVariableNode(BindVariableNode node, Void p) {
        return this.visitValueNode((ValueNode)node, p);
    }

    public Void visitLiteralVariableNode(LiteralVariableNode node, Void p) {
        return this.visitValueNode((ValueNode)node, p);
    }

    private Void visitValueNode(ValueNode node, Void p) {
        SqlLocation location = node.getLocation();
        String variableName = node.getVariableName();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, variableName);
        if (node.getWordNode() != null) {
            if (!typeDeclaration.isScalarType()) {
                String sql = this.getSql(location);
                throw new AptException((MessageResource)Message.DOMA4153, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), variableName, typeDeclaration.getBinaryName()});
            }
        } else if (!typeDeclaration.isScalarIterableType() && !typeDeclaration.isScalarArrayType()) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4161, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), variableName, typeDeclaration.getBinaryName()});
        }
        this.visitNode((SqlNode)node, p);
        return null;
    }

    public Void visitEmbeddedVariableNode(EmbeddedVariableNode node, Void p) {
        SqlLocation location = node.getLocation();
        String variableName = node.getVariableName();
        this.validateExpressionVariable(location, variableName);
        this.visitNode((SqlNode)node, p);
        return null;
    }

    public Void visitIfNode(IfNode node, Void p) {
        String expression;
        SqlLocation location = node.getLocation();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, expression = node.getExpression());
        if (!typeDeclaration.isBooleanType()) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4140, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName()});
        }
        this.visitNode((SqlNode)node, p);
        return null;
    }

    public Void visitElseifNode(ElseifNode node, Void p) {
        String expression;
        SqlLocation location = node.getLocation();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, expression = node.getExpression());
        if (!typeDeclaration.isBooleanType()) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4141, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName()});
        }
        this.visitNode((SqlNode)node, p);
        return null;
    }

    public Void visitForNode(ForNode node, Void p) {
        List<? extends TypeMirror> typeArgs;
        SqlLocation location = node.getLocation();
        String identifier = node.getIdentifier();
        String expression = node.getExpression();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, expression);
        TypeMirror typeMirror = typeDeclaration.getType();
        if (this.ctx.getMoreTypes().isAssignableWithErasure(typeMirror, Iterable.class)) {
            DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(typeMirror);
            typeArgs = declaredType.getTypeArguments();
        } else if (this.ctx.getMoreTypes().isArray(typeMirror)) {
            ArrayType arrayType = this.ctx.getMoreTypes().toArrayType(typeMirror);
            typeArgs = Collections.singletonList(arrayType.getComponentType());
        } else {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4149, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName()});
        }
        if (typeArgs.isEmpty()) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4150, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName()});
        }
        TypeMirror originalIdentifierType = this.expressionValidator.removeParameterType(identifier);
        this.expressionValidator.putParameterType(identifier, typeArgs.get(0));
        String hasNextVariable = identifier + "_has_next";
        TypeMirror originalHasNextType = this.expressionValidator.removeParameterType(hasNextVariable);
        this.expressionValidator.putParameterType(hasNextVariable, this.ctx.getMoreTypes().getTypeMirror(Boolean.TYPE));
        String indexVariable = identifier + "_index";
        TypeMirror originalIndexType = this.expressionValidator.removeParameterType(indexVariable);
        this.expressionValidator.putParameterType(indexVariable, this.ctx.getMoreTypes().getTypeMirror(Integer.TYPE));
        this.visitNode((SqlNode)node, p);
        if (originalIdentifierType == null) {
            this.expressionValidator.removeParameterType(identifier);
        } else {
            this.expressionValidator.putParameterType(identifier, originalIdentifierType);
        }
        if (originalHasNextType == null) {
            this.expressionValidator.removeParameterType(hasNextVariable);
        } else {
            this.expressionValidator.putParameterType(hasNextVariable, originalHasNextType);
        }
        if (originalIndexType == null) {
            this.expressionValidator.removeParameterType(indexVariable);
        } else {
            this.expressionValidator.putParameterType(indexVariable, originalIndexType);
        }
        return null;
    }

    public Void visitExpandNode(ExpandNode node, Void p) {
        if (!this.expandable) {
            SqlLocation location = node.getLocation();
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4257, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition()});
        }
        return this.visitNode((SqlNode)node, p);
    }

    public Void visitPopulateNode(PopulateNode node, Void p) {
        if (!this.populatable) {
            SqlLocation location = node.getLocation();
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4270, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition()});
        }
        Iterator<String> it = this.parameterTypeMap.keySet().iterator();
        if (it.hasNext()) {
            this.expressionValidator.addValidatedParameterName(it.next());
        }
        return this.visitNode((SqlNode)node, p);
    }

    protected Void defaultAction(SqlNode node, Void p) {
        return this.visitNode(node, p);
    }

    private Void visitNode(SqlNode node, Void p) {
        for (SqlNode child : node.getChildren()) {
            child.accept((SqlNodeVisitor)this, (Object)p);
        }
        return null;
    }

    private TypeDeclaration validateExpressionVariable(SqlLocation location, String expression) {
        ExpressionNode expressionNode = this.parseExpression(location, expression);
        try {
            return this.expressionValidator.validate(expressionNode);
        }
        catch (AptException e) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4092, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), e.getMessage()});
        }
    }

    private ExpressionNode parseExpression(SqlLocation location, String expression) {
        try {
            ExpressionParser parser = new ExpressionParser(expression);
            return parser.parse();
        }
        catch (ExpressionException e) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4092, this.methodElement, new Object[]{this.path, sql, location.getLineNumber(), location.getPosition(), e.getMessage()});
        }
    }

    private String getSql(SqlLocation location) {
        Object sql = location.getSql();
        if (sql != null && ((String)sql).length() > 5000) {
            sql = ((String)sql).substring(0, 5000);
            sql = (String)sql + Message.DOMA4185.getSimpleMessage(new Object[]{5000});
        }
        return sql;
    }
}

