/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.ProcessingContext;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.processor.AggregateStrategyProcessor;
import org.seasar.doma.internal.apt.processor.DaoProcessor;
import org.seasar.doma.internal.apt.processor.DataTypeProcessor;
import org.seasar.doma.internal.apt.processor.DomainConvertersProcessor;
import org.seasar.doma.internal.apt.processor.DomainProcessor;
import org.seasar.doma.internal.apt.processor.ElementProcessor;
import org.seasar.doma.internal.apt.processor.EmbeddableProcessor;
import org.seasar.doma.internal.apt.processor.EntityProcessor;
import org.seasar.doma.internal.apt.processor.ExternalDomainProcessor;
import org.seasar.doma.internal.apt.processor.ScopeProcessor;

@SupportedAnnotationTypes(value={"org.seasar.doma.AggregateStrategy", "org.seasar.doma.Dao", "org.seasar.doma.DataType", "org.seasar.doma.DomainConverters", "org.seasar.doma.Domain", "org.seasar.doma.Embeddable", "org.seasar.doma.Entity", "org.seasar.doma.ExternalDomain", "org.seasar.doma.Scope"})
@SupportedOptions(value={"doma.config.path", "doma.dao.package", "doma.dao.subpackage", "doma.dao.suffix", "doma.debug", "doma.domain.converters", "doma.entity.field.prefix", "doma.expr.functions", "doma.lombok.AllArgsConstructor", "doma.lombok.Value", "doma.metamodel.enabled", "doma.metamodel.prefix", "doma.metamodel.suffix", "doma.resources.dir", "doma.sql.validation", "doma.test.integration", "doma.test.unit", "doma.trace", "doma.version.validation"})
public class DomaProcessor
extends AbstractProcessor {
    private static final List<Operation> operations = List.of(new Operation("org.seasar.doma.ExternalDomain", ExternalDomainProcessor::new), new Operation("org.seasar.doma.DataType", DataTypeProcessor::new), new Operation("org.seasar.doma.Domain", DomainProcessor::new), new Operation("org.seasar.doma.DomainConverters", DomainConvertersProcessor::new), new Operation("org.seasar.doma.Embeddable", EmbeddableProcessor::new), new Operation("org.seasar.doma.Entity", EntityProcessor::new), new Operation("org.seasar.doma.AggregateStrategy", AggregateStrategyProcessor::new), new Operation("org.seasar.doma.Dao", DaoProcessor::new), new Operation("org.seasar.doma.Scope", ScopeProcessor::new));
    private ProcessingContext processingContext;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingContext = ProcessingContext.of(processingEnv);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || annotations.isEmpty()) {
            return true;
        }
        RoundContext roundContext = this.processingContext.createRoundContext(roundEnv);
        Map annotationMap = annotations.stream().collect(Collectors.toUnmodifiableMap(it -> it.getQualifiedName().toString(), Function.identity()));
        for (Operation operation : operations) {
            Set<? extends Element> elements;
            TypeElement annotation = (TypeElement)annotationMap.get(operation.name);
            if (annotation == null || (elements = roundContext.getElementsAnnotatedWith(annotation)).isEmpty()) continue;
            ElementProcessor processor = operation.function.apply(roundContext);
            processor.process(elements);
        }
        return true;
    }

    private record Operation(String name, Function<RoundContext, ElementProcessor> function) {
        Operation {
            Objects.requireNonNull(name);
            Objects.requireNonNull(function);
        }
    }
}

