/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.Reporter;
import org.seasar.doma.internal.apt.Resources;
import org.seasar.doma.internal.apt.RoundContext;

public class ProcessingContext {
    private final ProcessingEnvironment env;
    private boolean initialized;
    private Options options;
    private Reporter reporter;
    private Resources resources;

    private ProcessingContext(ProcessingEnvironment env) {
        this.env = Objects.requireNonNull(env);
    }

    private void init() {
        if (this.initialized) {
            throw new AptIllegalStateException("already initialized");
        }
        String envClassName = this.env.getClass().getName();
        boolean isRunningOnEcj = envClassName.startsWith("org.eclipse.");
        String resourceDir = this.env.getOptions().get("doma.resources.dir");
        boolean canAcceptDirectoryPath = isRunningOnEcj || resourceDir != null;
        JavaFileManager.Location location = this.determineLocation(isRunningOnEcj);
        this.reporter = new Reporter(this.env.getMessager());
        this.resources = new Resources(this.env.getFiler(), this.reporter, resourceDir, canAcceptDirectoryPath, location, this.isDebug(this.env));
        this.options = new Options(this.env.getOptions(), this.resources);
        this.initialized = true;
    }

    private JavaFileManager.Location determineLocation(boolean isRunningOnEcj) {
        String unitTest = this.env.getOptions().get("doma.test.unit");
        String integrationTest = this.env.getOptions().get("doma.test.integration");
        if (isRunningOnEcj && !Boolean.parseBoolean(unitTest) && !Boolean.parseBoolean(integrationTest)) {
            return StandardLocation.CLASS_OUTPUT;
        }
        return StandardLocation.SOURCE_PATH;
    }

    private boolean isDebug(ProcessingEnvironment env) {
        String debug = env.getOptions().get("doma.debug");
        return Boolean.parseBoolean(debug);
    }

    public RoundContext createRoundContext(RoundEnvironment roundEnvironment) {
        Objects.requireNonNull(roundEnvironment);
        RoundContext roundContext = new RoundContext(this, roundEnvironment);
        roundContext.init();
        return roundContext;
    }

    public Options getOptions() {
        this.assertInitialized();
        return this.options;
    }

    public Reporter getReporter() {
        this.assertInitialized();
        return this.reporter;
    }

    public Resources getResources() {
        this.assertInitialized();
        return this.resources;
    }

    public Elements getElements() {
        this.assertInitialized();
        return this.env.getElementUtils();
    }

    public Types getTypes() {
        this.assertInitialized();
        return this.env.getTypeUtils();
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new AptIllegalStateException("not yet initialized");
        }
    }

    public static ProcessingContext of(ProcessingEnvironment env) {
        Objects.requireNonNull(env);
        ProcessingContext processingContext = new ProcessingContext(env);
        processingContext.init();
        return processingContext;
    }
}

