/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.seasar.doma.internal.apt.Reporter;
import org.seasar.doma.internal.util.AssertionUtil;

public class Resources {
    private final Filer filer;
    private final Reporter reporter;
    private final String resourcesDir;
    private final boolean canAcceptDirectoryPath;
    private final JavaFileManager.Location location;
    private final JavaFileManager.Location fallbackLocation = StandardLocation.CLASS_OUTPUT;
    private final boolean isDebug;

    Resources(Filer filer, Reporter reporter, String resourcesDir, boolean canAcceptDirectoryPath, JavaFileManager.Location location, boolean isDebug) {
        AssertionUtil.assertNotNull((Object)filer, (Object)reporter);
        this.filer = filer;
        this.reporter = reporter;
        this.resourcesDir = resourcesDir;
        this.canAcceptDirectoryPath = canAcceptDirectoryPath;
        this.location = location;
        this.isDebug = isDebug;
    }

    public JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        return this.filer.createSourceFile(name, originatingElements);
    }

    public boolean canAcceptDirectoryPath() {
        return this.canAcceptDirectoryPath;
    }

    public FileObject getResource(String relativePath) throws IOException {
        AssertionUtil.assertNotNull((Object)relativePath);
        if (this.resourcesDir != null) {
            Path path = Paths.get(this.resourcesDir, relativePath);
            return new FileObjectImpl(path);
        }
        try {
            return this.filer.getResource(this.location, "", relativePath);
        }
        catch (Exception e) {
            if (this.location != this.fallbackLocation) {
                if (this.isDebug) {
                    String message = String.format("Fall back from %s to %s: %s, exception: %s", this.location, this.fallbackLocation, relativePath, e);
                    this.reporter.debug(message);
                }
                return this.filer.getResource(this.fallbackLocation, "", relativePath);
            }
            throw e;
        }
    }

    protected static class FileObjectImpl
    implements FileObject {
        private final Path path;

        FileObjectImpl(Path path) {
            this.path = path;
        }

        @Override
        public URI toUri() {
            return this.path.toUri();
        }

        @Override
        public String getName() {
            return this.path.toString();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        public OutputStream openOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public boolean delete() {
            return false;
        }
    }
}

