/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.MoreElements;
import org.seasar.doma.internal.apt.MoreTypes;
import org.seasar.doma.internal.apt.Names;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.ProcessingContext;
import org.seasar.doma.internal.apt.Reporter;
import org.seasar.doma.internal.apt.Resources;
import org.seasar.doma.internal.apt.annot.Annotations;
import org.seasar.doma.internal.apt.cttype.CtTypes;
import org.seasar.doma.internal.apt.decl.Declarations;
import org.seasar.doma.internal.apt.meta.domain.ExternalDomainMeta;

public class RoundContext {
    private final ProcessingContext processingContext;
    private final RoundEnvironment roundEnvironment;
    private final List<ExternalDomainMeta> externalDomainMetaList = new ArrayList<ExternalDomainMeta>();
    private boolean initialized;
    private MoreElements moreElements;
    private MoreTypes moreTypes;
    private Annotations annotations;
    private Declarations declarations;
    private CtTypes ctTypes;
    private Names names;

    RoundContext(ProcessingContext processingContext, RoundEnvironment roundEnvironment) {
        this.processingContext = Objects.requireNonNull(processingContext);
        this.roundEnvironment = Objects.requireNonNull(roundEnvironment);
    }

    void init() {
        if (this.initialized) {
            throw new AptIllegalStateException("already initialized");
        }
        this.moreElements = new MoreElements(this, this.processingContext.getElements());
        this.moreTypes = new MoreTypes(this, this.processingContext.getTypes());
        this.annotations = new Annotations(this);
        this.declarations = new Declarations(this);
        this.ctTypes = new CtTypes(this);
        this.names = new Names(this);
        this.initialized = true;
    }

    public RoundEnvironment getRoundEnvironment() {
        this.assertInitialized();
        return this.roundEnvironment;
    }

    public MoreElements getMoreElements() {
        this.assertInitialized();
        return this.moreElements;
    }

    public MoreTypes getMoreTypes() {
        this.assertInitialized();
        return this.moreTypes;
    }

    public Options getOptions() {
        this.assertInitialized();
        return this.processingContext.getOptions();
    }

    public Reporter getReporter() {
        this.assertInitialized();
        return this.processingContext.getReporter();
    }

    public Resources getResources() {
        this.assertInitialized();
        return this.processingContext.getResources();
    }

    public Annotations getAnnotations() {
        this.assertInitialized();
        return this.annotations;
    }

    public Declarations getDeclarations() {
        this.assertInitialized();
        return this.declarations;
    }

    public CtTypes getCtTypes() {
        this.assertInitialized();
        return this.ctTypes;
    }

    public Names getNames() {
        this.assertInitialized();
        return this.names;
    }

    public List<ExternalDomainMeta> getExternalDomainMetaList() {
        this.assertInitialized();
        return this.externalDomainMetaList;
    }

    public Set<? extends Element> getElementsAnnotatedWith(TypeElement annotation) {
        this.assertInitialized();
        Objects.requireNonNull(annotation);
        return this.roundEnvironment.getElementsAnnotatedWith(annotation);
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new AptIllegalStateException("not yet initialized");
        }
    }
}

