/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class AggregateStrategyAnnot
extends AbstractAnnot {
    private static final String ROOT = "root";
    private static final String TABLE_ALIAS = "tableAlias";
    private final AnnotationValue root;
    private final AnnotationValue tableAlias;

    AggregateStrategyAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.root = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)ROOT);
        this.tableAlias = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)TABLE_ALIAS);
    }

    public AnnotationValue getRoot() {
        return this.root;
    }

    public AnnotationValue getTableAlias() {
        return this.tableAlias;
    }

    public TypeMirror getRootValue() {
        TypeMirror result = AnnotationValueUtil.toType(this.root);
        if (result == null) {
            throw new AptIllegalStateException(ROOT);
        }
        return result;
    }

    public String getTableAliasValue() {
        String result = AnnotationValueUtil.toString(this.tableAlias);
        if (result == null) {
            throw new AptIllegalStateException(TABLE_ALIAS);
        }
        return result;
    }
}

