/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.AggregateStrategy;
import org.seasar.doma.AnnotateWith;
import org.seasar.doma.AssociationLinker;
import org.seasar.doma.Column;
import org.seasar.doma.Dao;
import org.seasar.doma.DataType;
import org.seasar.doma.Domain;
import org.seasar.doma.DomainConverters;
import org.seasar.doma.Embeddable;
import org.seasar.doma.Embedded;
import org.seasar.doma.Entity;
import org.seasar.doma.ResultSet;
import org.seasar.doma.SequenceGenerator;
import org.seasar.doma.Sql;
import org.seasar.doma.Table;
import org.seasar.doma.TableGenerator;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.AggregateStrategyAnnot;
import org.seasar.doma.internal.apt.annot.AllArgsConstructorAnnot;
import org.seasar.doma.internal.apt.annot.AnnotateWithAnnot;
import org.seasar.doma.internal.apt.annot.AnnotationAnnot;
import org.seasar.doma.internal.apt.annot.ArrayFactoryAnnot;
import org.seasar.doma.internal.apt.annot.AssociationLinkerAnnot;
import org.seasar.doma.internal.apt.annot.BatchDeleteAnnot;
import org.seasar.doma.internal.apt.annot.BatchInsertAnnot;
import org.seasar.doma.internal.apt.annot.BatchUpdateAnnot;
import org.seasar.doma.internal.apt.annot.BlobFactoryAnnot;
import org.seasar.doma.internal.apt.annot.ClobFactoryAnnot;
import org.seasar.doma.internal.apt.annot.ColumnAnnot;
import org.seasar.doma.internal.apt.annot.ColumnOverrideAnnot;
import org.seasar.doma.internal.apt.annot.DaoAnnot;
import org.seasar.doma.internal.apt.annot.DataTypeAnnot;
import org.seasar.doma.internal.apt.annot.DeleteAnnot;
import org.seasar.doma.internal.apt.annot.DomainAnnot;
import org.seasar.doma.internal.apt.annot.DomainConvertersAnnot;
import org.seasar.doma.internal.apt.annot.EmbeddableAnnot;
import org.seasar.doma.internal.apt.annot.EmbeddedAnnot;
import org.seasar.doma.internal.apt.annot.EntityAnnot;
import org.seasar.doma.internal.apt.annot.FunctionAnnot;
import org.seasar.doma.internal.apt.annot.InsertAnnot;
import org.seasar.doma.internal.apt.annot.MetamodelAnnot;
import org.seasar.doma.internal.apt.annot.MultiInsertAnnot;
import org.seasar.doma.internal.apt.annot.NClobFactoryAnnot;
import org.seasar.doma.internal.apt.annot.ProcedureAnnot;
import org.seasar.doma.internal.apt.annot.ResultSetAnnot;
import org.seasar.doma.internal.apt.annot.ReturningAnnot;
import org.seasar.doma.internal.apt.annot.SQLXMLFactoryAnnot;
import org.seasar.doma.internal.apt.annot.ScriptAnnot;
import org.seasar.doma.internal.apt.annot.SelectAnnot;
import org.seasar.doma.internal.apt.annot.SequenceGeneratorAnnot;
import org.seasar.doma.internal.apt.annot.SqlAnnot;
import org.seasar.doma.internal.apt.annot.SqlProcessorAnnot;
import org.seasar.doma.internal.apt.annot.TableAnnot;
import org.seasar.doma.internal.apt.annot.TableGeneratorAnnot;
import org.seasar.doma.internal.apt.annot.UpdateAnnot;
import org.seasar.doma.internal.apt.annot.ValueAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class Annotations {
    private final RoundContext ctx;

    public Annotations(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    public AggregateStrategyAnnot newAggregateStrategyAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        return this.newInstance((Element)typeElement, AggregateStrategy.class, AggregateStrategyAnnot::new);
    }

    public AllArgsConstructorAnnot newAllArgsConstructorAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        return this.newInstance((Element)typeElement, this.ctx.getOptions().getLombokAllArgsConstructor(), AllArgsConstructorAnnot::new);
    }

    public List<AnnotateWithAnnot> newAnnotateWithAnnots(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        ArrayList<AnnotationMirror> annotateWiths = new ArrayList<AnnotationMirror>();
        AnnotationMirror annotateWith2 = this.ctx.getMoreElements().getAnnotationMirror((Element)typeElement, AnnotateWith.class);
        if (annotateWith2 != null) {
            annotateWiths.add(annotateWith2);
        }
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            AnnotationMirror annotateWith3;
            TypeElement ownerElement = this.ctx.getMoreElements().toTypeElement(annotationMirror.getAnnotationType().asElement());
            if (ownerElement == null || (annotateWith3 = this.ctx.getMoreElements().getAnnotationMirror((Element)ownerElement, AnnotateWith.class)) == null) continue;
            annotateWiths.add(annotateWith3);
        }
        return annotateWiths.stream().map(annotateWith -> {
            Map<String, AnnotationValue> values = this.ctx.getMoreElements().getValuesWithDefaults((AnnotationMirror)annotateWith);
            AnnotationValue annotations = values.get("annotations");
            ArrayList<AnnotationAnnot> annotationsValue = new ArrayList<AnnotationAnnot>();
            for (AnnotationMirror annotationMirror : AnnotationValueUtil.toAnnotationList(annotations)) {
                annotationsValue.add(this.newAnnotationAnnot(annotationMirror));
            }
            return new AnnotateWithAnnot((AnnotationMirror)annotateWith, annotations, annotationsValue);
        }).collect(Collectors.toList());
    }

    private AnnotationAnnot newAnnotationAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, AnnotationAnnot::new);
    }

    public AssociationLinkerAnnot newAssociationLinkerAnnot(VariableElement field) {
        AssertionUtil.assertNotNull((Object)field);
        return this.newInstance((Element)field, AssociationLinker.class, AssociationLinkerAnnot::new);
    }

    public ArrayFactoryAnnot newArrayFactoryAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, ArrayFactoryAnnot::new);
    }

    public BatchDeleteAnnot newBatchDeleteAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, BatchDeleteAnnot::new);
    }

    public BatchInsertAnnot newBatchInsertAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, BatchInsertAnnot::new);
    }

    public BatchUpdateAnnot newBatchUpdateAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, BatchUpdateAnnot::new);
    }

    public BlobFactoryAnnot newBlobFactoryAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return new BlobFactoryAnnot(annotation);
    }

    public ClobFactoryAnnot newClobFactoryAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return new ClobFactoryAnnot(annotation);
    }

    public ColumnAnnot newColumnAnnot(VariableElement field) {
        AssertionUtil.assertNotNull((Object)field);
        return this.newInstance((Element)field, Column.class, ColumnAnnot::new);
    }

    public ColumnOverrideAnnot newColumnOverrideAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        Map<String, AnnotationValue> values = this.ctx.getMoreElements().getValuesWithDefaults(annotation);
        return new ColumnOverrideAnnot(annotation, values, it -> this.ctx.getMoreElements().getValuesWithoutDefaults((AnnotationMirror)it));
    }

    public DaoAnnot newDaoAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        return this.newInstance((Element)typeElement, Dao.class, DaoAnnot::new);
    }

    public DataTypeAnnot newDataTypeAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        return this.newInstance((Element)typeElement, DataType.class, DataTypeAnnot::new);
    }

    public DomainAnnot newDomainAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        return this.newInstance((Element)typeElement, Domain.class, DomainAnnot::new);
    }

    public DomainConvertersAnnot newDomainConvertersAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        return this.newInstance((Element)typeElement, DomainConverters.class, DomainConvertersAnnot::new);
    }

    public DeleteAnnot newDeleteAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        ReturningAnnot returningAnnot = this.newReturningAnnot(annotation, "returning");
        Map<String, AnnotationValue> valuesWithDefaults = this.ctx.getMoreElements().getValuesWithDefaults(annotation);
        return new DeleteAnnot(annotation, returningAnnot, valuesWithDefaults);
    }

    public EmbeddableAnnot newEmbeddableAnnot(TypeElement typeElement) {
        AnnotationMirror metamodelMirror;
        AssertionUtil.assertNotNull((Object)typeElement);
        AnnotationMirror embeddableMirror = this.ctx.getMoreElements().getAnnotationMirror((Element)typeElement, Embeddable.class);
        if (embeddableMirror == null) {
            return null;
        }
        Map<String, AnnotationValue> valuesWithoutDefaults = this.ctx.getMoreElements().getValuesWithoutDefaults(embeddableMirror);
        AnnotationValue metamodel = valuesWithoutDefaults.get("metamodel");
        MetamodelAnnot metamodelAnnot = null;
        if (metamodel != null && (metamodelMirror = AnnotationValueUtil.toAnnotation(metamodel)) != null) {
            metamodelAnnot = this.newMetamodelAnnot(metamodelMirror);
        }
        return new EmbeddableAnnot(embeddableMirror, metamodelAnnot);
    }

    public EmbeddedAnnot newEmbeddedAnnot(VariableElement field) {
        AssertionUtil.assertNotNull((Object)field);
        AnnotationMirror annotation = this.ctx.getMoreElements().getAnnotationMirror((Element)field, Embedded.class);
        if (annotation == null) {
            return null;
        }
        Map<String, AnnotationValue> values = this.ctx.getMoreElements().getValuesWithDefaults(annotation);
        return new EmbeddedAnnot(annotation, values, this::newColumnOverrideAnnot);
    }

    public EntityAnnot newEntityAnnot(TypeElement typeElement) {
        AnnotationMirror metamodelMirror;
        AssertionUtil.assertNotNull((Object)typeElement);
        AnnotationMirror entityMirror = this.ctx.getMoreElements().getAnnotationMirror((Element)typeElement, Entity.class);
        if (entityMirror == null) {
            return null;
        }
        Map<String, AnnotationValue> valuesWithoutDefaults = this.ctx.getMoreElements().getValuesWithoutDefaults(entityMirror);
        AnnotationValue metamodel = valuesWithoutDefaults.get("metamodel");
        MetamodelAnnot metamodelAnnot = null;
        if (metamodel != null && (metamodelMirror = AnnotationValueUtil.toAnnotation(metamodel)) != null) {
            metamodelAnnot = this.newMetamodelAnnot(metamodelMirror);
        }
        Map<String, AnnotationValue> valuesWithDefaults = this.ctx.getMoreElements().getValuesWithDefaults(entityMirror);
        return new EntityAnnot(entityMirror, metamodelAnnot, valuesWithDefaults);
    }

    public FunctionAnnot newFunctionAnnot(AnnotationMirror annotation, String name) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, (annotationMirror, values) -> new FunctionAnnot((AnnotationMirror)annotationMirror, (Map<String, AnnotationValue>)values, name));
    }

    public InsertAnnot newInsertAnnot(AnnotationMirror annotation) {
        ReturningAnnot returningAnnot = this.newReturningAnnot(annotation, "returning");
        Map<String, AnnotationValue> valuesWithDefaults = this.ctx.getMoreElements().getValuesWithDefaults(annotation);
        return new InsertAnnot(annotation, returningAnnot, valuesWithDefaults);
    }

    public MultiInsertAnnot newMultiInsertAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        ReturningAnnot returningAnnot = this.newReturningAnnot(annotation, "returning");
        Map<String, AnnotationValue> valuesWithDefaults = this.ctx.getMoreElements().getValuesWithDefaults(annotation);
        return new MultiInsertAnnot(annotation, returningAnnot, valuesWithDefaults);
    }

    public MetamodelAnnot newMetamodelAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, MetamodelAnnot::new);
    }

    public NClobFactoryAnnot newNClobFactoryAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return new NClobFactoryAnnot(annotation);
    }

    public ProcedureAnnot newProcedureAnnot(AnnotationMirror annotation, String name) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, (annotationMirror, values) -> new ProcedureAnnot((AnnotationMirror)annotationMirror, (Map<String, AnnotationValue>)values, name));
    }

    public ResultSetAnnot newResultSetAnnot(VariableElement param) {
        AssertionUtil.assertNotNull((Object)param);
        return this.newInstance((Element)param, ResultSet.class, ResultSetAnnot::new);
    }

    private ReturningAnnot newReturningAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, ReturningAnnot::new);
    }

    private ReturningAnnot newReturningAnnot(AnnotationMirror ownerAnnotation, String returningElementName) {
        AssertionUtil.assertNotNull((Object)ownerAnnotation, (Object)returningElementName);
        Map<String, AnnotationValue> valuesWithoutDefaults = this.ctx.getMoreElements().getValuesWithoutDefaults(ownerAnnotation);
        AnnotationValue returning = valuesWithoutDefaults.get(returningElementName);
        if (returning == null) {
            return null;
        }
        AnnotationMirror returningMirror = AnnotationValueUtil.toAnnotation(returning);
        if (returningMirror == null) {
            return null;
        }
        return this.newReturningAnnot(returningMirror);
    }

    public ScriptAnnot newScriptAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, ScriptAnnot::new);
    }

    public SelectAnnot newSelectAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return this.newInstance(annotation, SelectAnnot::new);
    }

    public SequenceGeneratorAnnot newSequenceGeneratorAnnot(VariableElement field) {
        AssertionUtil.assertNotNull((Object)field);
        return this.newInstance((Element)field, SequenceGenerator.class, SequenceGeneratorAnnot::new);
    }

    public SqlAnnot newSqlAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull((Object)method);
        return this.newInstance((Element)method, Sql.class, SqlAnnot::new);
    }

    public SqlProcessorAnnot newSqlProcessorAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return new SqlProcessorAnnot(annotation);
    }

    public SQLXMLFactoryAnnot newSQLXMLFactoryAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        return new SQLXMLFactoryAnnot(annotation);
    }

    public TableGeneratorAnnot newTableGeneratorAnnot(VariableElement field) {
        AssertionUtil.assertNotNull((Object)field);
        return this.newInstance((Element)field, TableGenerator.class, TableGeneratorAnnot::new);
    }

    public TableAnnot newTableAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        return this.newInstance((Element)typeElement, Table.class, TableAnnot::new);
    }

    public UpdateAnnot newUpdateAnnot(AnnotationMirror annotation) {
        AssertionUtil.assertNotNull((Object)annotation);
        ReturningAnnot returningAnnot = this.newReturningAnnot(annotation, "returning");
        Map<String, AnnotationValue> valuesWithDefaults = this.ctx.getMoreElements().getValuesWithDefaults(annotation);
        return new UpdateAnnot(annotation, returningAnnot, valuesWithDefaults);
    }

    public ValueAnnot newValueAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)typeElement);
        return this.newInstance((Element)typeElement, this.ctx.getOptions().getLombokValue(), ValueAnnot::new);
    }

    private <ANNOT> ANNOT newInstance(Element element, Class<? extends Annotation> annotationClass, BiFunction<AnnotationMirror, Map<String, AnnotationValue>, ANNOT> biFunction) {
        AnnotationMirror annotation = this.ctx.getMoreElements().getAnnotationMirror(element, annotationClass);
        if (annotation == null) {
            return null;
        }
        return this.newInstance(annotation, biFunction);
    }

    private <ANNOT> ANNOT newInstance(Element element, String annotationClassName, BiFunction<AnnotationMirror, Map<String, AnnotationValue>, ANNOT> biFunction) {
        AnnotationMirror annotation = this.ctx.getMoreElements().getAnnotationMirror(element, annotationClassName);
        if (annotation == null) {
            return null;
        }
        return this.newInstance(annotation, biFunction);
    }

    private <ANNOT> ANNOT newInstance(AnnotationMirror annotation, BiFunction<AnnotationMirror, Map<String, AnnotationValue>, ANNOT> biFunction) {
        AssertionUtil.assertNotNull((Object)annotation);
        Map<String, AnnotationValue> values = this.ctx.getMoreElements().getValuesWithDefaults(annotation);
        return biFunction.apply(annotation, values);
    }
}

