/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class ColumnOverrideAnnot
extends AbstractAnnot {
    public static final String NAME = "name";
    public static final String COLUMN = "column";
    private final AnnotationValue name;
    private final AnnotationValue column;
    private final Function<AnnotationMirror, Map<String, AnnotationValue>> getValuesWithoutDefaults;

    ColumnOverrideAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values, Function<AnnotationMirror, Map<String, AnnotationValue>> getValuesWithoutDefaults) {
        super(annotationMirror);
        this.name = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)NAME);
        this.column = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)COLUMN);
        this.getValuesWithoutDefaults = Objects.requireNonNull(getValuesWithoutDefaults);
    }

    public AnnotationValue getName() {
        return this.name;
    }

    public AnnotationValue getColumn() {
        return this.column;
    }

    public String getNameValue() {
        String value = AnnotationValueUtil.toString(this.name);
        if (value == null) {
            throw new AptIllegalStateException(NAME);
        }
        return value;
    }

    public ColumnAnnot getColumnValue() {
        AnnotationMirror value = AnnotationValueUtil.toAnnotation(this.column);
        if (value == null) {
            throw new AptIllegalStateException(COLUMN);
        }
        Map<String, AnnotationValue> valuesWithoutDefaults = this.getValuesWithoutDefaults.apply(value);
        return new ColumnAnnot(value, valuesWithoutDefaults);
    }

    public static class ColumnAnnot
    extends AbstractAnnot {
        public static final String INSERTABLE = "insertable";
        public static final String UPDATABLE = "updatable";
        public static final String QUOTE = "quote";
        public static final String NAME = "name";
        private final AnnotationValue name;
        private final AnnotationValue insertable;
        private final AnnotationValue updatable;
        private final AnnotationValue quote;

        ColumnAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
            super(annotationMirror);
            this.name = values.get("name");
            this.insertable = values.get(INSERTABLE);
            this.updatable = values.get(UPDATABLE);
            this.quote = values.get(QUOTE);
        }

        public AnnotationValue getName() {
            return this.name;
        }

        public AnnotationValue getInsertable() {
            return this.insertable;
        }

        public AnnotationValue getUpdatable() {
            return this.updatable;
        }

        public AnnotationValue getQuote() {
            return this.quote;
        }

        public String getNameValue() {
            return AnnotationValueUtil.toString(this.name);
        }

        public Boolean getInsertableValue() {
            return AnnotationValueUtil.toBoolean(this.insertable);
        }

        public Boolean getUpdatableValue() {
            return AnnotationValueUtil.toBoolean(this.updatable);
        }

        public Boolean getQuoteValue() {
            return AnnotationValueUtil.toBoolean(this.quote);
        }
    }
}

