/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.annot.ColumnOverrideAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class EmbeddedAnnot
extends AbstractAnnot {
    public static final String PREFIX = "prefix";
    public static final String COLUMN_OVERRIDES = "columnOverrides";
    private final AnnotationValue prefix;
    private final AnnotationValue columnOverrides;
    private final Function<AnnotationMirror, ColumnOverrideAnnot> columnOverrideAnnotFactory;

    EmbeddedAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values, Function<AnnotationMirror, ColumnOverrideAnnot> columnOverrideAnnotFactory) {
        super(annotationMirror);
        this.prefix = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)PREFIX);
        this.columnOverrides = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)COLUMN_OVERRIDES);
        this.columnOverrideAnnotFactory = Objects.requireNonNull(columnOverrideAnnotFactory);
    }

    public AnnotationValue getPrefix() {
        return this.prefix;
    }

    public String getPrefixValue() {
        String value = AnnotationValueUtil.toString(this.prefix);
        if (value == null) {
            throw new AptIllegalStateException(PREFIX);
        }
        return value;
    }

    public AnnotationValue getColumnOverrides() {
        return this.columnOverrides;
    }

    public List<ColumnOverrideAnnot> getColumnOverridesValue() {
        List<AnnotationMirror> value = AnnotationValueUtil.toAnnotationList(this.columnOverrides);
        if (value == null) {
            throw new AptIllegalStateException(COLUMN_OVERRIDES);
        }
        return value.stream().map(this.columnOverrideAnnotFactory).toList();
    }
}

