/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.annot.ReturningAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.query.DuplicateKeyType;

public class MultiInsertAnnot
extends AbstractAnnot {
    private static final String QUERY_TIMEOUT = "queryTimeout";
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private static final String SQL_LOG = "sqlLog";
    private static final String DUPLICATE_KEY_TYPE = "duplicateKeyType";
    private static final String DUPLICATE_KEYS = "duplicateKeys";
    static final String RETURNING = "returning";
    private final AnnotationValue queryTimeout;
    private final AnnotationValue include;
    private final AnnotationValue exclude;
    private final AnnotationValue sqlLog;
    private final AnnotationValue duplicateKeyType;
    private final AnnotationValue duplicateKeys;
    private final ReturningAnnot returningAnnot;

    MultiInsertAnnot(AnnotationMirror annotationMirror, ReturningAnnot returningAnnot, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.queryTimeout = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)QUERY_TIMEOUT);
        this.sqlLog = (AnnotationValue)AssertionUtil.assertNonNullValue(values, (Object)SQL_LOG);
        this.include = values.get(INCLUDE);
        this.exclude = values.get(EXCLUDE);
        this.duplicateKeyType = values.get(DUPLICATE_KEY_TYPE);
        this.duplicateKeys = values.get(DUPLICATE_KEYS);
        this.returningAnnot = returningAnnot;
    }

    public AnnotationValue getQueryTimeout() {
        return this.queryTimeout;
    }

    public AnnotationValue getInclude() {
        return this.include;
    }

    public AnnotationValue getExclude() {
        return this.exclude;
    }

    public AnnotationValue getDuplicateKeys() {
        return this.duplicateKeys;
    }

    public AnnotationValue getSqlLog() {
        return this.sqlLog;
    }

    public ReturningAnnot getReturningAnnot() {
        return this.returningAnnot;
    }

    public int getQueryTimeoutValue() {
        Integer value = AnnotationValueUtil.toInteger(this.queryTimeout);
        if (value == null) {
            throw new AptIllegalStateException(QUERY_TIMEOUT);
        }
        return value;
    }

    public List<String> getIncludeValue() {
        return AnnotationValueUtil.toStringList(this.include);
    }

    public List<String> getExcludeValue() {
        return AnnotationValueUtil.toStringList(this.exclude);
    }

    public DuplicateKeyType getDuplicateKeyTypeValue() {
        if (this.duplicateKeys == null) {
            return null;
        }
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.duplicateKeyType);
        if (enumConstant == null) {
            throw new AptIllegalStateException(DUPLICATE_KEY_TYPE);
        }
        return DuplicateKeyType.valueOf((String)enumConstant.getSimpleName().toString());
    }

    public List<String> getDuplicateKeysValue() {
        return AnnotationValueUtil.toStringList(this.duplicateKeys);
    }

    public SqlLogType getSqlLogValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.sqlLog);
        if (enumConstant == null) {
            throw new AptIllegalStateException(SQL_LOG);
        }
        return SqlLogType.valueOf((String)enumConstant.getSimpleName().toString());
    }
}

