/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor14;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.wrapper.ArrayWrapper;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.BigIntegerWrapper;
import org.seasar.doma.wrapper.BlobWrapper;
import org.seasar.doma.wrapper.BooleanWrapper;
import org.seasar.doma.wrapper.ByteWrapper;
import org.seasar.doma.wrapper.BytesWrapper;
import org.seasar.doma.wrapper.ClobWrapper;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.DoubleWrapper;
import org.seasar.doma.wrapper.EnumWrapper;
import org.seasar.doma.wrapper.FloatWrapper;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.LocalDateTimeWrapper;
import org.seasar.doma.wrapper.LocalDateWrapper;
import org.seasar.doma.wrapper.LocalTimeWrapper;
import org.seasar.doma.wrapper.LongWrapper;
import org.seasar.doma.wrapper.NClobWrapper;
import org.seasar.doma.wrapper.ObjectWrapper;
import org.seasar.doma.wrapper.PrimitiveBooleanWrapper;
import org.seasar.doma.wrapper.PrimitiveByteWrapper;
import org.seasar.doma.wrapper.PrimitiveDoubleWrapper;
import org.seasar.doma.wrapper.PrimitiveFloatWrapper;
import org.seasar.doma.wrapper.PrimitiveIntWrapper;
import org.seasar.doma.wrapper.PrimitiveLongWrapper;
import org.seasar.doma.wrapper.PrimitiveShortWrapper;
import org.seasar.doma.wrapper.SQLXMLWrapper;
import org.seasar.doma.wrapper.ShortWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;

class BasicCtTypeFactory {
    private final RoundContext ctx;

    BasicCtTypeFactory(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    BasicCtType newPrimitiveBooleanCtType(TypeMirror type) {
        AssertionUtil.assertTrue((type.getKind() == TypeKind.BOOLEAN ? 1 : 0) != 0, (Object[])new Object[0]);
        return this.newBasicCtType(type, PrimitiveBooleanWrapper.class);
    }

    BasicCtType newPrimitiveByteCtType(TypeMirror type) {
        AssertionUtil.assertTrue((type.getKind() == TypeKind.BYTE ? 1 : 0) != 0, (Object[])new Object[0]);
        return this.newBasicCtType(type, PrimitiveByteWrapper.class);
    }

    BasicCtType newPrimitiveDoubleCtType(TypeMirror type) {
        AssertionUtil.assertTrue((type.getKind() == TypeKind.DOUBLE ? 1 : 0) != 0, (Object[])new Object[0]);
        return this.newBasicCtType(type, PrimitiveDoubleWrapper.class);
    }

    BasicCtType newPrimitiveFloatCtType(TypeMirror type) {
        AssertionUtil.assertTrue((type.getKind() == TypeKind.FLOAT ? 1 : 0) != 0, (Object[])new Object[0]);
        return this.newBasicCtType(type, PrimitiveFloatWrapper.class);
    }

    BasicCtType newPrimitiveIntCtType(TypeMirror type) {
        AssertionUtil.assertTrue((type.getKind() == TypeKind.INT ? 1 : 0) != 0, (Object[])new Object[0]);
        return this.newBasicCtType(type, PrimitiveIntWrapper.class);
    }

    BasicCtType newPrimitiveLongCtType(TypeMirror type) {
        AssertionUtil.assertTrue((type.getKind() == TypeKind.LONG ? 1 : 0) != 0, (Object[])new Object[0]);
        return this.newBasicCtType(type, PrimitiveLongWrapper.class);
    }

    BasicCtType newPrimitiveShortCtType(TypeMirror type) {
        AssertionUtil.assertTrue((type.getKind() == TypeKind.SHORT ? 1 : 0) != 0, (Object[])new Object[0]);
        return this.newBasicCtType(type, PrimitiveShortWrapper.class);
    }

    BasicCtType newArrayCtType(TypeMirror type) {
        return this.newBasicCtType(type, ArrayWrapper.class);
    }

    BasicCtType newBigDecimalCtType(TypeMirror type) {
        return this.newBasicCtType(type, BigDecimalWrapper.class);
    }

    BasicCtType newBigIntegerCtType(TypeMirror type) {
        return this.newBasicCtType(type, BigIntegerWrapper.class);
    }

    BasicCtType newBlobCtType(TypeMirror type) {
        return this.newBasicCtType(type, BlobWrapper.class);
    }

    BasicCtType newBooleanCtType(TypeMirror type) {
        return this.newBasicCtType(type, BooleanWrapper.class);
    }

    BasicCtType newByteCtType(TypeMirror type) {
        return this.newBasicCtType(type, ByteWrapper.class);
    }

    BasicCtType newBytesCtType(TypeMirror type) {
        return this.newBasicCtType(type, BytesWrapper.class);
    }

    BasicCtType newClobCtType(TypeMirror type) {
        return this.newBasicCtType(type, ClobWrapper.class);
    }

    BasicCtType newDateCtType(TypeMirror type) {
        return this.newBasicCtType(type, DateWrapper.class);
    }

    BasicCtType newDoubleCtType(TypeMirror type) {
        return this.newBasicCtType(type, DoubleWrapper.class);
    }

    BasicCtType newEnumCtType(TypeMirror type) {
        return this.newBasicCtType(type, EnumWrapper.class);
    }

    BasicCtType newFloatCtType(TypeMirror type) {
        return this.newBasicCtType(type, FloatWrapper.class);
    }

    BasicCtType newIntegerCtType(TypeMirror type) {
        return this.newBasicCtType(type, IntegerWrapper.class);
    }

    BasicCtType newLocalDateCtType(TypeMirror type) {
        return this.newBasicCtType(type, LocalDateWrapper.class);
    }

    BasicCtType newLocalDateTimeCtType(TypeMirror type) {
        return this.newBasicCtType(type, LocalDateTimeWrapper.class);
    }

    BasicCtType newLocalTimeCtType(TypeMirror type) {
        return this.newBasicCtType(type, LocalTimeWrapper.class);
    }

    BasicCtType newLongCtType(TypeMirror type) {
        return this.newBasicCtType(type, LongWrapper.class);
    }

    BasicCtType newNClobCtType(TypeMirror type) {
        return this.newBasicCtType(type, NClobWrapper.class);
    }

    BasicCtType newObjectCtType(TypeMirror type) {
        return this.newBasicCtType(type, ObjectWrapper.class);
    }

    BasicCtType newShortCtType(TypeMirror type) {
        return this.newBasicCtType(type, ShortWrapper.class);
    }

    BasicCtType newStringCtType(TypeMirror type) {
        return this.newBasicCtType(type, StringWrapper.class);
    }

    BasicCtType newSQLXMLCtType(TypeMirror type) {
        return this.newBasicCtType(type, SQLXMLWrapper.class);
    }

    BasicCtType newTimeCtType(TypeMirror type) {
        return this.newBasicCtType(type, TimeWrapper.class);
    }

    BasicCtType newTimestampCtType(TypeMirror type) {
        return this.newBasicCtType(type, TimestampWrapper.class);
    }

    BasicCtType newUtilDateCtType(TypeMirror type) {
        return this.newBasicCtType(type, UtilDateWrapper.class);
    }

    private BasicCtType newBasicCtType(TypeMirror type, Class<?> wrapperType) {
        TypeElement wrapperTypeElement = this.ctx.getMoreElements().getTypeElement(wrapperType);
        if (wrapperTypeElement == null) {
            return null;
        }
        return new BasicCtType(this.ctx, type, wrapperTypeElement);
    }

    BasicCtType newBasicCtType(TypeMirror type) {
        return type.accept(new BasicCtTypeResolver(), null);
    }

    private class BasicCtTypeResolver
    extends SimpleTypeVisitor14<BasicCtType, Void> {
        private BasicCtTypeResolver() {
        }

        @Override
        public BasicCtType visitArray(ArrayType t, Void p) {
            if (t.getComponentType().getKind() == TypeKind.BYTE) {
                return BasicCtTypeFactory.this.newBytesCtType(t);
            }
            return null;
        }

        @Override
        public BasicCtType visitDeclared(DeclaredType t, Void p) {
            TypeElement typeElement = BasicCtTypeFactory.this.ctx.getMoreTypes().toTypeElement(t);
            if (typeElement == null) {
                return null;
            }
            if (typeElement.getKind() == ElementKind.ENUM) {
                return BasicCtTypeFactory.this.newEnumCtType(t);
            }
            String name = typeElement.getQualifiedName().toString();
            if (String.class.getName().equals(name)) {
                return BasicCtTypeFactory.this.newStringCtType(t);
            }
            if (Boolean.class.getName().equals(name)) {
                return BasicCtTypeFactory.this.newBooleanCtType(t);
            }
            if (Byte.class.getName().equals(name)) {
                return BasicCtTypeFactory.this.newByteCtType(t);
            }
            if (Short.class.getName().equals(name)) {
                return BasicCtTypeFactory.this.newShortCtType(t);
            }
            if (Integer.class.getName().equals(name)) {
                return BasicCtTypeFactory.this.newIntegerCtType(t);
            }
            if (Long.class.getName().equals(name)) {
                return BasicCtTypeFactory.this.newLongCtType(t);
            }
            if (Float.class.getName().equals(name)) {
                return BasicCtTypeFactory.this.newFloatCtType(t);
            }
            if (Double.class.getName().equals(name)) {
                return BasicCtTypeFactory.this.newDoubleCtType(t);
            }
            if (Object.class.getName().equals(name)) {
                return BasicCtTypeFactory.this.newObjectCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, BigDecimal.class)) {
                return BasicCtTypeFactory.this.newBigDecimalCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, BigInteger.class)) {
                return BasicCtTypeFactory.this.newBigIntegerCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Time.class)) {
                return BasicCtTypeFactory.this.newTimeCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Timestamp.class)) {
                return BasicCtTypeFactory.this.newTimestampCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Date.class)) {
                return BasicCtTypeFactory.this.newDateCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, java.util.Date.class)) {
                return BasicCtTypeFactory.this.newUtilDateCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, LocalTime.class)) {
                return BasicCtTypeFactory.this.newLocalTimeCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, LocalDateTime.class)) {
                return BasicCtTypeFactory.this.newLocalDateTimeCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, LocalDate.class)) {
                return BasicCtTypeFactory.this.newLocalDateCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Array.class)) {
                return BasicCtTypeFactory.this.newArrayCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Blob.class)) {
                return BasicCtTypeFactory.this.newBlobCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, NClob.class)) {
                return BasicCtTypeFactory.this.newNClobCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, Clob.class)) {
                return BasicCtTypeFactory.this.newClobCtType(t);
            }
            if (BasicCtTypeFactory.this.ctx.getMoreTypes().isAssignableWithErasure((TypeMirror)t, SQLXML.class)) {
                return BasicCtTypeFactory.this.newSQLXMLCtType(t);
            }
            return null;
        }

        @Override
        public BasicCtType visitPrimitive(PrimitiveType t, Void p) {
            return switch (t.getKind()) {
                case TypeKind.BOOLEAN -> BasicCtTypeFactory.this.newPrimitiveBooleanCtType(t);
                case TypeKind.BYTE -> BasicCtTypeFactory.this.newPrimitiveByteCtType(t);
                case TypeKind.SHORT -> BasicCtTypeFactory.this.newPrimitiveShortCtType(t);
                case TypeKind.INT -> BasicCtTypeFactory.this.newPrimitiveIntCtType(t);
                case TypeKind.LONG -> BasicCtTypeFactory.this.newPrimitiveLongCtType(t);
                case TypeKind.FLOAT -> BasicCtTypeFactory.this.newPrimitiveFloatCtType(t);
                case TypeKind.DOUBLE -> BasicCtTypeFactory.this.newPrimitiveDoubleCtType(t);
                case TypeKind.CHAR -> null;
                default -> (BasicCtType)AssertionUtil.assertUnreachable();
            };
        }
    }
}

