/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.DataType;
import org.seasar.doma.Domain;
import org.seasar.doma.Embeddable;
import org.seasar.doma.Entity;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.AggregateStrategyAnnot;
import org.seasar.doma.internal.apt.cttype.AggregateStrategyCtType;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.ArrayCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtTypeFactory;
import org.seasar.doma.internal.apt.cttype.BatchResultCtType;
import org.seasar.doma.internal.apt.cttype.BiConsumerCtType;
import org.seasar.doma.internal.apt.cttype.BiFunctionCtType;
import org.seasar.doma.internal.apt.cttype.CollectorCtType;
import org.seasar.doma.internal.apt.cttype.ConfigCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.ExternalDomainCtTypeFactory;
import org.seasar.doma.internal.apt.cttype.FunctionCtType;
import org.seasar.doma.internal.apt.cttype.InternalDomainCtTypeFactory;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.MultiResultCtType;
import org.seasar.doma.internal.apt.cttype.NoneCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.PreparedSqlCtType;
import org.seasar.doma.internal.apt.cttype.ReferenceCtType;
import org.seasar.doma.internal.apt.cttype.ResultCtType;
import org.seasar.doma.internal.apt.cttype.SelectOptionsCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.jdbc.BatchResult;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.MultiResult;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.Reference;
import org.seasar.doma.jdbc.Result;
import org.seasar.doma.jdbc.SelectOptions;

public class CtTypes {
    private final RoundContext ctx;
    private final BasicCtTypeFactory basicCtTypeFactory;
    private final InternalDomainCtTypeFactory internalDomainCtTypeFactory;
    private final ExternalDomainCtTypeFactory externalDomainCtTypeFactory;
    private final Map<String, Function<TypeMirror, CtType>> nameToTypeHandlers;
    private final List<Function<TypeMirror, CtType>> typeHandlers;

    public CtTypes(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
        this.basicCtTypeFactory = new BasicCtTypeFactory(ctx);
        this.internalDomainCtTypeFactory = new InternalDomainCtTypeFactory(ctx);
        this.externalDomainCtTypeFactory = new ExternalDomainCtTypeFactory(ctx);
        this.nameToTypeHandlers = this.createNameToTypeHandlers();
        this.typeHandlers = this.createTypeHandlers();
    }

    private Map<String, Function<TypeMirror, CtType>> createNameToTypeHandlers() {
        Map.Entry[] entryArray = new Map.Entry[43];
        entryArray[0] = Map.entry(Array.class.getName(), this.basicCtTypeFactory::newArrayCtType);
        entryArray[1] = Map.entry(BigDecimal.class.getName(), this.basicCtTypeFactory::newBigDecimalCtType);
        entryArray[2] = Map.entry(BigInteger.class.getName(), this.basicCtTypeFactory::newBigIntegerCtType);
        entryArray[3] = Map.entry(Blob.class.getName(), this.basicCtTypeFactory::newBlobCtType);
        entryArray[4] = Map.entry(Boolean.class.getName(), this.basicCtTypeFactory::newBooleanCtType);
        entryArray[5] = Map.entry(Byte.class.getName(), this.basicCtTypeFactory::newByteCtType);
        entryArray[6] = Map.entry(Clob.class.getName(), this.basicCtTypeFactory::newClobCtType);
        entryArray[7] = Map.entry(java.sql.Date.class.getName(), this.basicCtTypeFactory::newDateCtType);
        entryArray[8] = Map.entry(Double.class.getName(), this.basicCtTypeFactory::newDoubleCtType);
        entryArray[9] = Map.entry(Float.class.getName(), this.basicCtTypeFactory::newFloatCtType);
        entryArray[10] = Map.entry(Integer.class.getName(), this.basicCtTypeFactory::newIntegerCtType);
        entryArray[11] = Map.entry(LocalDate.class.getName(), this.basicCtTypeFactory::newLocalDateCtType);
        entryArray[12] = Map.entry(LocalDateTime.class.getName(), this.basicCtTypeFactory::newLocalDateTimeCtType);
        entryArray[13] = Map.entry(LocalTime.class.getName(), this.basicCtTypeFactory::newLocalTimeCtType);
        entryArray[14] = Map.entry(Long.class.getName(), this.basicCtTypeFactory::newLongCtType);
        entryArray[15] = Map.entry(NClob.class.getName(), this.basicCtTypeFactory::newNClobCtType);
        entryArray[16] = Map.entry(Object.class.getName(), this.basicCtTypeFactory::newObjectCtType);
        entryArray[17] = Map.entry(String.class.getName(), this.basicCtTypeFactory::newStringCtType);
        entryArray[18] = Map.entry(Short.class.getName(), this.basicCtTypeFactory::newShortCtType);
        entryArray[19] = Map.entry(SQLXML.class.getName(), this.basicCtTypeFactory::newSQLXMLCtType);
        entryArray[20] = Map.entry(Time.class.getName(), this.basicCtTypeFactory::newTimeCtType);
        entryArray[21] = Map.entry(Timestamp.class.getName(), this.basicCtTypeFactory::newTimestampCtType);
        entryArray[22] = Map.entry(Date.class.getName(), this.basicCtTypeFactory::newUtilDateCtType);
        entryArray[23] = Map.entry(Iterable.class.getName(), this::newIterableCtType);
        entryArray[24] = Map.entry(Collection.class.getName(), this::newIterableCtType);
        entryArray[25] = Map.entry(List.class.getName(), this::newIterableCtType);
        entryArray[26] = Map.entry(Set.class.getName(), this::newIterableCtType);
        entryArray[27] = Map.entry(Optional.class.getName(), this::newOptionalCtType);
        entryArray[28] = Map.entry(OptionalDouble.class.getName(), this::newOptionalDoubleCtType);
        entryArray[29] = Map.entry(OptionalInt.class.getName(), this::newOptionalIntCtType);
        entryArray[30] = Map.entry(OptionalLong.class.getName(), this::newOptionalLongCtType);
        entryArray[31] = Map.entry(Map.class.getName(), this::newMapCtType);
        entryArray[32] = Map.entry(Stream.class.getName(), this::newStreamCtType);
        entryArray[33] = Map.entry(Collector.class.getName(), this::newCollectorCtType);
        entryArray[34] = Map.entry(SelectOptions.class.getName(), this::newSelectOptionsCtType);
        entryArray[35] = Map.entry(Function.class.getName(), this::newFunctionCtType);
        entryArray[36] = Map.entry(BiFunction.class.getName(), this::newBiFunctionCtType);
        entryArray[37] = Map.entry(Reference.class.getName(), this::newReferenceCtType);
        entryArray[38] = Map.entry(PreparedSql.class.getName(), this::newPreparedSqlCtType);
        entryArray[39] = Map.entry(Config.class.getName(), this::newConfigCtType);
        entryArray[40] = Map.entry(Result.class.getName(), this::newResultCtType);
        entryArray[41] = Map.entry(BatchResult.class.getName(), this::newBatchResultCtType);
        entryArray[42] = Map.entry(MultiResult.class.getName(), this::newMultiResultCtType);
        return Map.ofEntries(entryArray);
    }

    private List<Function<TypeMirror, CtType>> createTypeHandlers() {
        return List.of(this.externalDomainCtTypeFactory::newDomainCtType, this::newIterableCtType, this.basicCtTypeFactory::newBasicCtType, this::newFunctionCtType, this::newCollectorCtType, this::newReferenceCtType, this::newBiFunctionCtType, this::newArrayCtType);
    }

    public AggregateStrategyCtType newAggregateStrategyCtType(TypeMirror type) {
        Objects.requireNonNull(type);
        if (this.ctx.getMoreTypes().isSameTypeWithErasure(type, Void.class)) {
            return null;
        }
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(type);
        if (typeElement == null) {
            return null;
        }
        AggregateStrategyAnnot aggregateStrategyAnnot = this.ctx.getAnnotations().newAggregateStrategyAnnot(typeElement);
        if (aggregateStrategyAnnot == null) {
            return null;
        }
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        ClassName typeClassName = ClassNames.newAggregateStrategyTypeClassName((CharSequence)binaryName);
        return new AggregateStrategyCtType(this.ctx, type, typeClassName, aggregateStrategyAnnot);
    }

    private AnyCtType newAnyCtType(TypeMirror type) {
        return new AnyCtType(this.ctx, type);
    }

    private BatchResultCtType newBatchResultCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, BatchResult.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        CtType elementCtType = this.getTypeArgument(declaredType);
        return new BatchResultCtType(this.ctx, type, elementCtType);
    }

    public BasicCtType newBasicCtType(TypeMirror type) {
        Objects.requireNonNull(type);
        return this.basicCtTypeFactory.newBasicCtType(type);
    }

    public BiFunctionCtType newBiFunctionCtType(TypeMirror type) {
        Objects.requireNonNull(type);
        DeclaredType declaredType = this.getSuperDeclaredType(type, BiFunction.class);
        if (declaredType == null) {
            return null;
        }
        Triple triple = this.getThreeTypeArguments(declaredType);
        return new BiFunctionCtType(this.ctx, type, triple.first, triple.second, triple.third);
    }

    public BiConsumerCtType newBiConsumerCtType(TypeMirror type) {
        Objects.requireNonNull(type);
        DeclaredType declaredType = this.getSuperDeclaredType(type, BiConsumer.class);
        if (declaredType == null) {
            return null;
        }
        Pair pair = this.getTwoTypeArguments(declaredType);
        return new BiConsumerCtType(this.ctx, type, pair.first, pair.second);
    }

    private CollectorCtType newCollectorCtType(TypeMirror type) {
        DeclaredType declaredType = this.getSuperDeclaredType(type, Collector.class);
        if (declaredType == null) {
            return null;
        }
        Triple triple = this.getThreeTypeArguments(declaredType);
        return new CollectorCtType(this.ctx, type, triple.first, triple.third);
    }

    private ConfigCtType newConfigCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, Config.class)) {
            return null;
        }
        return new ConfigCtType(this.ctx, type);
    }

    private EmbeddableCtType newEmbeddableCtType(TypeMirror type, TypeElement typeElement, Embeddable embeddable) {
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        ClassName typeClassName = ClassNames.newEmbeddableTypeClassName((CharSequence)binaryName);
        return new EmbeddableCtType(this.ctx, type, typeClassName);
    }

    public EntityCtType newEntityCtType(TypeMirror type) {
        Objects.requireNonNull(type);
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(type);
        if (typeElement == null) {
            return null;
        }
        Entity entity = typeElement.getAnnotation(Entity.class);
        if (entity == null) {
            return null;
        }
        return this.newEntityCtType(type, typeElement, entity);
    }

    private EntityCtType newEntityCtType(TypeMirror type, TypeElement typeElement, Entity entity) {
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        ClassName typeClassName = ClassNames.newEntityTypeClassName((CharSequence)binaryName);
        boolean immutable = typeElement.getKind() == ElementKind.RECORD || entity.immutable();
        return new EntityCtType(this.ctx, type, immutable, typeClassName);
    }

    private FunctionCtType newFunctionCtType(TypeMirror type) {
        DeclaredType declaredType = this.getSuperDeclaredType(type, Function.class);
        if (declaredType == null) {
            return null;
        }
        Pair pair = this.getTwoTypeArguments(declaredType);
        return new FunctionCtType(this.ctx, type, pair.first, pair.second);
    }

    private IterableCtType newIterableCtType(TypeMirror type) {
        DeclaredType declaredType = this.getSuperDeclaredType(type, Iterable.class);
        if (declaredType == null) {
            return null;
        }
        CtType elementCtType = this.getTypeArgument(declaredType);
        return new IterableCtType(this.ctx, type, elementCtType);
    }

    private ArrayCtType newArrayCtType(TypeMirror type) {
        if (type.getKind() != TypeKind.ARRAY) {
            return null;
        }
        TypeMirror componentType = ((ArrayType)type).getComponentType();
        if (componentType.getKind() == TypeKind.BYTE) {
            return null;
        }
        CtType elementCtType = this.newCtType(componentType);
        return new ArrayCtType(this.ctx, type, elementCtType);
    }

    private MultiResultCtType newMultiResultCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, MultiResult.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        CtType elementCtType = this.getTypeArgument(declaredType);
        return new MultiResultCtType(this.ctx, type, elementCtType);
    }

    private MapCtType newMapCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, Map.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
        if (typeArgs.size() != 2) {
            return null;
        }
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(typeArgs.get(0), String.class)) {
            return null;
        }
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(typeArgs.get(1), Object.class)) {
            return null;
        }
        return new MapCtType(this.ctx, type);
    }

    private NoneCtType newNoneCtType() {
        NoType type = this.ctx.getMoreTypes().getNoType(TypeKind.NONE);
        return new NoneCtType(this.ctx, type);
    }

    private OptionalCtType newOptionalCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, Optional.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        CtType elementCtType = this.getTypeArgument(declaredType);
        return new OptionalCtType(this.ctx, type, elementCtType);
    }

    private OptionalDoubleCtType newOptionalDoubleCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, OptionalDouble.class)) {
            return null;
        }
        PrimitiveType primitiveType = this.ctx.getMoreTypes().getPrimitiveType(TypeKind.DOUBLE);
        BasicCtType elementCtType = this.basicCtTypeFactory.newPrimitiveDoubleCtType(primitiveType);
        return new OptionalDoubleCtType(this.ctx, type, elementCtType);
    }

    private OptionalIntCtType newOptionalIntCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, OptionalInt.class)) {
            return null;
        }
        PrimitiveType primitiveType = this.ctx.getMoreTypes().getPrimitiveType(TypeKind.INT);
        BasicCtType elementCtType = this.basicCtTypeFactory.newPrimitiveIntCtType(primitiveType);
        return new OptionalIntCtType(this.ctx, type, elementCtType);
    }

    private OptionalLongCtType newOptionalLongCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, OptionalLong.class)) {
            return null;
        }
        PrimitiveType primitiveType = this.ctx.getMoreTypes().getPrimitiveType(TypeKind.LONG);
        BasicCtType elementCtType = this.basicCtTypeFactory.newPrimitiveLongCtType(primitiveType);
        return new OptionalLongCtType(this.ctx, type, elementCtType);
    }

    private PreparedSqlCtType newPreparedSqlCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, PreparedSql.class)) {
            return null;
        }
        return new PreparedSqlCtType(this.ctx, type);
    }

    private ReferenceCtType newReferenceCtType(TypeMirror type) {
        DeclaredType declaredType = this.getSuperDeclaredType(type, Reference.class);
        if (declaredType == null) {
            return null;
        }
        CtType referentCtType = this.getTypeArgument(declaredType);
        return new ReferenceCtType(this.ctx, type, referentCtType);
    }

    private ResultCtType newResultCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, Result.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        CtType elementCtType = this.getTypeArgument(declaredType);
        return new ResultCtType(this.ctx, type, elementCtType);
    }

    private SelectOptionsCtType newSelectOptionsCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isAssignableWithErasure(type, SelectOptions.class)) {
            return null;
        }
        return new SelectOptionsCtType(this.ctx, type);
    }

    private StreamCtType newStreamCtType(TypeMirror type) {
        if (!this.ctx.getMoreTypes().isSameTypeWithErasure(type, Stream.class)) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        CtType elementCtType = this.getTypeArgument(declaredType);
        return new StreamCtType(this.ctx, type, elementCtType);
    }

    private DeclaredType getSuperDeclaredType(TypeMirror type, Class<?> superclass) {
        if (this.ctx.getMoreTypes().isSameTypeWithErasure(type, superclass)) {
            return this.ctx.getMoreTypes().toDeclaredType(type);
        }
        for (TypeMirror typeMirror : this.ctx.getMoreTypes().directSupertypes(type)) {
            if (this.ctx.getMoreTypes().isSameTypeWithErasure(typeMirror, superclass)) {
                return this.ctx.getMoreTypes().toDeclaredType(typeMirror);
            }
            DeclaredType result = this.getSuperDeclaredType(typeMirror, superclass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private CtType getTypeArgument(DeclaredType declaredType) {
        Iterator<? extends TypeMirror> typeArguments = declaredType.getTypeArguments().iterator();
        return typeArguments.hasNext() ? this.newCtType(typeArguments.next()) : this.newNoneCtType();
    }

    private Pair getTwoTypeArguments(DeclaredType declaredType) {
        Iterator<? extends TypeMirror> typeArguments = declaredType.getTypeArguments().iterator();
        NoneCtType first = typeArguments.hasNext() ? this.newCtType(typeArguments.next()) : this.newNoneCtType();
        NoneCtType second = typeArguments.hasNext() ? this.newCtType(typeArguments.next()) : this.newNoneCtType();
        return new Pair(first, second);
    }

    private Triple getThreeTypeArguments(DeclaredType declaredType) {
        Iterator<? extends TypeMirror> typeArguments = declaredType.getTypeArguments().iterator();
        NoneCtType first = typeArguments.hasNext() ? this.newCtType(typeArguments.next()) : this.newNoneCtType();
        NoneCtType second = typeArguments.hasNext() ? this.newCtType(typeArguments.next()) : this.newNoneCtType();
        NoneCtType third = typeArguments.hasNext() ? this.newCtType(typeArguments.next()) : this.newNoneCtType();
        return new Triple(first, second, third);
    }

    List<CtType> getAllTypeArguments(TypeElement typeElement, DeclaredType declaredType) {
        Iterator<? extends TypeMirror> typeArguments = declaredType.getTypeArguments().iterator();
        return typeElement.getTypeParameters().stream().map(__ -> typeArguments.hasNext() ? this.newCtType((TypeMirror)typeArguments.next()) : this.newNoneCtType()).collect(Collectors.toList());
    }

    public CtType newCtType(TypeMirror type) {
        Objects.requireNonNull(type);
        return this.newCtTypeInternal(type, new SimpleCtTypeVisitor<Void, Void, AptException>());
    }

    public CtType newCtType(TypeMirror type, CtTypeVisitor<Void, Void, AptException> validator) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(validator);
        return this.newCtTypeInternal(type, validator);
    }

    private CtType newCtTypeInternal(TypeMirror type, CtTypeVisitor<Void, Void, AptException> validator) {
        CtType ctType = this.findCtType(type);
        ctType.accept(validator, null);
        return ctType;
    }

    private CtType findCtType(TypeMirror type) {
        TypeKind kind = type.getKind();
        if (kind.isPrimitive()) {
            CtType result = this.findCtTypeByPrimitiveTypeKind(type, kind);
            if (result != null) {
                return result;
            }
            return this.newAnyCtType(type);
        }
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(type);
        if (typeElement != null) {
            CtType result = this.findCtTypeByAnnotation(type, typeElement);
            if (result != null) {
                return result;
            }
            result = this.findCtTypeByName(type, typeElement);
            if (result != null) {
                return result;
            }
        }
        for (Function<TypeMirror, CtType> handler : this.typeHandlers) {
            CtType result = handler.apply(type);
            if (result == null) continue;
            return result;
        }
        return this.newAnyCtType(type);
    }

    private CtType findCtTypeByAnnotation(TypeMirror type, TypeElement typeElement) {
        DomainCtType result;
        DomainCtType result2;
        Domain domain = typeElement.getAnnotation(Domain.class);
        if (domain != null && (result2 = this.internalDomainCtTypeFactory.newDomainCtType(type, typeElement, domain)) != null) {
            return result2;
        }
        DataType dataType = typeElement.getAnnotation(DataType.class);
        if (dataType != null && (result = this.internalDomainCtTypeFactory.newDataTypeCtType(type, typeElement, dataType)) != null) {
            return result;
        }
        Embeddable embeddable = typeElement.getAnnotation(Embeddable.class);
        if (embeddable != null) {
            return this.newEmbeddableCtType(type, typeElement, embeddable);
        }
        Entity entity = typeElement.getAnnotation(Entity.class);
        if (entity != null) {
            return this.newEntityCtType(type, typeElement, entity);
        }
        return null;
    }

    private CtType findCtTypeByName(TypeMirror type, TypeElement typeElement) {
        String name = typeElement.getQualifiedName().toString();
        Function<TypeMirror, CtType> handler = this.nameToTypeHandlers.get(name);
        if (handler != null) {
            return handler.apply(type);
        }
        return null;
    }

    private CtType findCtTypeByPrimitiveTypeKind(TypeMirror type, TypeKind kind) {
        return switch (kind) {
            case TypeKind.BOOLEAN -> this.basicCtTypeFactory.newPrimitiveBooleanCtType(type);
            case TypeKind.BYTE -> this.basicCtTypeFactory.newPrimitiveByteCtType(type);
            case TypeKind.DOUBLE -> this.basicCtTypeFactory.newPrimitiveDoubleCtType(type);
            case TypeKind.FLOAT -> this.basicCtTypeFactory.newPrimitiveFloatCtType(type);
            case TypeKind.INT -> this.basicCtTypeFactory.newPrimitiveIntCtType(type);
            case TypeKind.LONG -> this.basicCtTypeFactory.newPrimitiveLongCtType(type);
            case TypeKind.SHORT -> this.basicCtTypeFactory.newPrimitiveShortCtType(type);
            default -> null;
        };
    }

    private record Triple(CtType first, CtType second, CtType third) {
    }

    private record Pair(CtType first, CtType second) {
    }
}

