/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.AptIllegalOptionException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.DomainConvertersAnnot;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.meta.domain.ExternalDomainMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.domain.DomainConverter;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.message.Message;

class ExternalDomainCtTypeFactory {
    private final RoundContext ctx;

    public ExternalDomainCtTypeFactory(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    DomainCtType newDomainCtType(TypeMirror type) {
        TypeMirror valueType = this.getValueType(type);
        if (valueType == null) {
            return null;
        }
        BasicCtType basicCtType = this.ctx.getCtTypes().newBasicCtType(valueType);
        if (basicCtType == null) {
            return null;
        }
        if (type.getKind() == TypeKind.ARRAY) {
            return this.newDomainCtType(type, basicCtType, Collections.emptyList());
        }
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(type);
        if (typeElement == null) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        List<CtType> typeArgCtTypes = this.ctx.getCtTypes().getAllTypeArguments(typeElement, declaredType);
        return this.newDomainCtType(type, basicCtType, typeArgCtTypes);
    }

    private TypeMirror getValueType(TypeMirror domainType) {
        TypeMirror valueType = this.getValueTypeFromOptions(domainType);
        if (valueType != null) {
            return valueType;
        }
        valueType = this.getValueTypeFromRoundContext(domainType);
        if (valueType != null) {
            return valueType;
        }
        return this.getValueTypeFromCompiledMetadata(domainType);
    }

    private TypeMirror getValueTypeFromOptions(TypeMirror domainType) {
        String csv = this.ctx.getOptions().getDomainConverters();
        if (csv != null) {
            for (String value : csv.split(",")) {
                String className = value.trim();
                if (className.isEmpty()) continue;
                TypeElement convertersProviderElement = this.ctx.getMoreElements().getTypeElementFromBinaryName(className);
                if (convertersProviderElement == null) {
                    throw new AptIllegalOptionException(Message.DOMA4200.getMessage(new Object[]{className}));
                }
                DomainConvertersAnnot convertersMirror = this.ctx.getAnnotations().newDomainConvertersAnnot(convertersProviderElement);
                if (convertersMirror == null) {
                    throw new AptIllegalOptionException(Message.DOMA4201.getMessage(new Object[]{className}));
                }
                for (TypeMirror converterType : convertersMirror.getValueValue()) {
                    TypeMirror[] argTypes;
                    if ((converterType = this.reloadTypeMirror(converterType)) == null || (argTypes = this.getConverterArgTypes(converterType)) == null || !this.ctx.getMoreTypes().isSameTypeWithErasure(domainType, argTypes[0])) continue;
                    return argTypes[1];
                }
            }
        }
        return null;
    }

    private TypeMirror reloadTypeMirror(TypeMirror typeMirror) {
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(typeMirror);
        if (typeElement == null) {
            return null;
        }
        typeElement = this.ctx.getMoreElements().getTypeElement(typeElement.getQualifiedName());
        if (typeElement == null) {
            return null;
        }
        return typeElement.asType();
    }

    private TypeMirror[] getConverterArgTypes(TypeMirror typeMirror) {
        for (TypeMirror typeMirror2 : this.ctx.getMoreTypes().directSupertypes(typeMirror)) {
            if (!this.ctx.getMoreTypes().isAssignableWithErasure(typeMirror2, DomainConverter.class)) continue;
            if (this.ctx.getMoreTypes().isSameTypeWithErasure(typeMirror2, DomainConverter.class)) {
                DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(typeMirror2);
                AssertionUtil.assertNotNull((Object)declaredType);
                List<? extends TypeMirror> args = declaredType.getTypeArguments();
                AssertionUtil.assertEquals((Object)2, (Object)args.size());
                return new TypeMirror[]{args.get(0), args.get(1)};
            }
            TypeMirror[] argTypes = this.getConverterArgTypes(typeMirror2);
            if (argTypes == null) continue;
            return argTypes;
        }
        return null;
    }

    private TypeMirror getValueTypeFromRoundContext(TypeMirror domainType) {
        return this.ctx.getExternalDomainMetaList().stream().filter(it -> this.ctx.getMoreTypes().isSameTypeWithErasure(it.asType(), domainType)).findFirst().map(ExternalDomainMeta::getValueType).orElse(null);
    }

    private TypeMirror getValueTypeFromCompiledMetadata(TypeMirror domainType) {
        TypeElement domainTypeElement = this.ctx.getMoreTypes().toTypeElement(domainType);
        if (domainTypeElement == null) {
            return null;
        }
        ClassName className = ClassNames.newExternalDomainTypeClassName((CharSequence)domainTypeElement.getQualifiedName());
        TypeElement externalDomainMetadataElement = this.ctx.getMoreElements().getTypeElement((CharSequence)className);
        if (externalDomainMetadataElement == null) {
            return null;
        }
        TypeMirror[] argTypes = this.getDomainTypeArgTypes(externalDomainMetadataElement.asType());
        if (argTypes == null) {
            return null;
        }
        return argTypes[0];
    }

    private TypeMirror[] getDomainTypeArgTypes(TypeMirror typeMirror) {
        for (TypeMirror typeMirror2 : this.ctx.getMoreTypes().directSupertypes(typeMirror)) {
            if (!this.ctx.getMoreTypes().isAssignableWithErasure(typeMirror2, DomainType.class)) continue;
            if (this.ctx.getMoreTypes().isSameTypeWithErasure(typeMirror2, DomainType.class)) {
                DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(typeMirror2);
                AssertionUtil.assertNotNull((Object)declaredType);
                List<? extends TypeMirror> args = declaredType.getTypeArguments();
                AssertionUtil.assertEquals((Object)2, (Object)args.size());
                return new TypeMirror[]{args.get(0), args.get(1)};
            }
            TypeMirror[] argTypes = this.getDomainTypeArgTypes(typeMirror2);
            if (argTypes == null) continue;
            return argTypes;
        }
        return null;
    }

    private DomainCtType newDomainCtType(TypeMirror type, BasicCtType typeElement, List<CtType> typeArgCtTypes) {
        Name name = this.ctx.getNames().createExternalDomainName(type);
        ClassName typeClassName = ClassNames.newExternalDomainTypeClassName((CharSequence)name);
        return new DomainCtType(this.ctx, type, typeElement, typeArgCtTypes, typeClassName);
    }
}

