/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.AbstractCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.CtTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;

public final class FunctionCtType
extends AbstractCtType {
    private final CtType targetCtType;
    private final CtType returnCtType;

    FunctionCtType(RoundContext ctx, TypeMirror type, CtType targetCtType, CtType returnCtType) {
        super(ctx, type);
        AssertionUtil.assertNotNull((Object)targetCtType, (Object)returnCtType);
        this.targetCtType = targetCtType;
        this.returnCtType = returnCtType;
    }

    public CtType getTargetCtType() {
        return this.targetCtType;
    }

    public CtType getReturnCtType() {
        return this.returnCtType;
    }

    public boolean isRaw() {
        return this.returnCtType.isNone() || this.targetCtType.isNone();
    }

    public boolean hasWildcard() {
        return this.returnCtType.isWildcard() || this.targetCtType.isWildcard();
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CtTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitFunctionCtType(this, p);
    }
}

