/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.cttype;

import java.util.List;
import java.util.Objects;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.DataType;
import org.seasar.doma.Domain;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;

class InternalDomainCtTypeFactory {
    private final RoundContext ctx;

    InternalDomainCtTypeFactory(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    DomainCtType newDomainCtType(TypeMirror type, TypeElement typeElement, Domain domain) {
        TypeMirror valueType = this.getValueType(domain);
        return this.newDomainCtType(type, typeElement, valueType);
    }

    private TypeMirror getValueType(Domain domain) {
        try {
            domain.valueType();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
        throw new AptIllegalStateException("unreachable.");
    }

    DomainCtType newDataTypeCtType(TypeMirror type, TypeElement typeElement, DataType dataType) {
        TypeMirror valueType = this.getValueType(typeElement, dataType);
        return this.newDomainCtType(type, typeElement, valueType);
    }

    private TypeMirror getValueType(TypeElement typeElement, DataType dataType) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(c -> !c.getModifiers().contains((Object)Modifier.PRIVATE)).filter(c -> c.getParameters().size() == 1).toList();
        if (constructors.size() != 1) {
            throw new AptIllegalStateException(String.format("%s : %d", typeElement.getQualifiedName(), constructors.size()));
        }
        ExecutableElement constructor = constructors.iterator().next();
        VariableElement param = constructor.getParameters().iterator().next();
        if (param == null) {
            throw new AptIllegalStateException("param is null");
        }
        return param.asType();
    }

    private DomainCtType newDomainCtType(TypeMirror type, TypeElement typeElement, TypeMirror valueType) {
        if (valueType == null) {
            return null;
        }
        BasicCtType basicCtType = this.ctx.getCtTypes().newBasicCtType(valueType);
        if (basicCtType == null) {
            return null;
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(type);
        if (declaredType == null) {
            return null;
        }
        List<CtType> typeArgCtTypes = this.ctx.getCtTypes().getAllTypeArguments(typeElement, declaredType);
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        ClassName typeClassName = ClassNames.newDomainTypeClassName((CharSequence)binaryName);
        return new DomainCtType(this.ctx, type, basicCtType, typeArgCtTypes, typeClassName);
    }
}

