/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.decl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.apt.MoreTypes;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.ArrayCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.decl.ConstructorDeclaration;
import org.seasar.doma.internal.apt.decl.FieldDeclaration;
import org.seasar.doma.internal.apt.decl.MethodDeclaration;
import org.seasar.doma.internal.apt.decl.TypeParameterDeclaration;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.internal.util.Zip;

public class TypeDeclaration {
    private static final Map<String, NumberTypePriority> NUMBER_PRIORITY_MAP = TypeDeclaration.createNumberPriorityMap();
    private final RoundContext ctx;
    private final TypeMirror type;
    private final CtType ctType;
    private final TypeElement typeElement;
    private final Map<Name, List<TypeParameterDeclaration>> typeParameterDeclarationsMap;
    private final NumberTypePriority numberPriority;

    private static Map<String, NumberTypePriority> createNumberPriorityMap() {
        HashMap<String, NumberTypePriority> map = new HashMap<String, NumberTypePriority>();
        map.put(BigDecimal.class.getName(), NumberTypePriority.BIG_DECIMAL);
        map.put(BigInteger.class.getName(), NumberTypePriority.BIG_INTEGER);
        map.put(Double.TYPE.getName(), NumberTypePriority.DOUBLE);
        map.put(Double.class.getName(), NumberTypePriority.DOUBLE);
        map.put(Float.TYPE.getName(), NumberTypePriority.FLOAT);
        map.put(Float.class.getName(), NumberTypePriority.FLOAT);
        map.put(Long.TYPE.getName(), NumberTypePriority.LONG);
        map.put(Long.class.getName(), NumberTypePriority.LONG);
        map.put(Integer.TYPE.getName(), NumberTypePriority.INT);
        map.put(Integer.class.getName(), NumberTypePriority.INT);
        map.put(Short.TYPE.getName(), NumberTypePriority.SHORT);
        map.put(Short.class.getName(), NumberTypePriority.SHORT);
        map.put(Byte.TYPE.getName(), NumberTypePriority.BYTE);
        map.put(Byte.class.getName(), NumberTypePriority.BYTE);
        return map;
    }

    protected TypeDeclaration(RoundContext ctx, TypeMirror type, CtType ctType, TypeElement typeElement, Map<Name, List<TypeParameterDeclaration>> typeParameterDeclarationsMap) {
        this.ctx = Objects.requireNonNull(ctx);
        this.type = Objects.requireNonNull(type);
        this.ctType = Objects.requireNonNull(ctType);
        this.typeElement = typeElement;
        this.typeParameterDeclarationsMap = Objects.requireNonNull(typeParameterDeclarationsMap);
        this.numberPriority = TypeDeclaration.determineNumberPriority(typeElement, type);
    }

    public TypeMirror getType() {
        return this.type;
    }

    public String getBinaryName() {
        if (this.typeElement == null) {
            return this.type.toString();
        }
        return this.ctx.getMoreElements().getBinaryName(this.typeElement).toString();
    }

    public boolean isUnknownType() {
        return this.type.getKind() == TypeKind.NONE;
    }

    public boolean isNullType() {
        return this.type.getKind() == TypeKind.NULL;
    }

    public boolean isBooleanType() {
        return this.isPrimitiveTypeKind(TypeKind.BOOLEAN) || this.isBoxedType(Boolean.class);
    }

    public boolean isTextType() {
        return this.isPrimitiveTypeKind(TypeKind.CHAR) || this.isBoxedType(String.class) || this.isBoxedType(Character.class);
    }

    public boolean isNumberType() {
        return this.isPrimitiveNumberType() || this.isBoxedNumberType();
    }

    private boolean isPrimitiveTypeKind(TypeKind kind) {
        return this.type.getKind() == kind;
    }

    private boolean isBoxedType(Class<?> clazz) {
        return this.ctx.getMoreTypes().isSameTypeWithErasure(this.type, clazz);
    }

    private boolean isPrimitiveNumberType() {
        return switch (this.type.getKind()) {
            case TypeKind.BYTE, TypeKind.SHORT, TypeKind.INT, TypeKind.LONG, TypeKind.FLOAT, TypeKind.DOUBLE -> true;
            default -> false;
        };
    }

    private boolean isBoxedNumberType() {
        if (this.typeElement == null) {
            return false;
        }
        String canonicalName = this.typeElement.getQualifiedName().toString();
        return NUMBER_PRIORITY_MAP.containsKey(canonicalName);
    }

    public boolean is(Class<?> clazz) {
        return this.ctx.getMoreTypes().isSameTypeWithErasure(this.type, clazz);
    }

    public boolean isScalarType() {
        return this.isScalarCtType(this.ctType);
    }

    public boolean isScalarIterableType() {
        CtType ctType = this.ctType;
        if (ctType instanceof IterableCtType) {
            IterableCtType iterableCtType = (IterableCtType)ctType;
            return this.isScalarCtType(iterableCtType.getElementCtType());
        }
        return false;
    }

    public boolean isScalarArrayType() {
        CtType ctType = this.ctType;
        if (ctType instanceof ArrayCtType) {
            ArrayCtType arrayCtType = (ArrayCtType)ctType;
            return this.isScalarCtType(arrayCtType.getElementCtType());
        }
        return false;
    }

    private boolean isScalarCtType(CtType ctType) {
        return ctType instanceof BasicCtType || ctType instanceof DomainCtType;
    }

    public List<TypeParameterDeclaration> getTypeParameterDeclarations() {
        Optional<List<TypeParameterDeclaration>> typeParameterDeclarations = this.typeParameterDeclarationsMap.values().stream().findFirst();
        return typeParameterDeclarations.orElse(Collections.emptyList());
    }

    public List<TypeParameterDeclaration> getAllTypeParameterDeclarations() {
        return this.typeParameterDeclarationsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Optional<ConstructorDeclaration> getConstructorDeclaration(List<TypeDeclaration> parameterTypeDeclarations) {
        if (this.typeElement == null) {
            return Optional.empty();
        }
        return ElementFilter.constructorsIn(this.typeElement.getEnclosedElements()).stream().filter(c -> c.getModifiers().contains((Object)Modifier.PUBLIC)).filter(c -> c.getParameters().size() == parameterTypeDeclarations.size()).filter(c -> this.isAssignable(parameterTypeDeclarations, c.getParameters())).map(c -> this.ctx.getDeclarations().newConstructorDeclaration((ExecutableElement)c)).findAny();
    }

    public Optional<FieldDeclaration> getFieldDeclaration(String name) {
        return this.getFieldDeclarationInternal(name, false);
    }

    public Optional<FieldDeclaration> getStaticFieldDeclaration(String name) {
        return this.getFieldDeclarationInternal(name, true);
    }

    private Optional<FieldDeclaration> getFieldDeclarationInternal(String name, boolean statik) {
        List<FieldDeclaration> candidates = this.getCandidateFieldDeclarations(name, statik);
        this.removeHiddenFieldDeclarations(candidates);
        return candidates.stream().findFirst();
    }

    private List<FieldDeclaration> getCandidateFieldDeclarations(String name, boolean statik) {
        return this.processTypeParameterDeclarations((typeElement, typeParams) -> ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(f -> this.matchesFieldCriteria((VariableElement)f, name, statik)).map(f -> this.ctx.getDeclarations().newFieldDeclaration((VariableElement)f, typeParams)));
    }

    private boolean matchesFieldCriteria(VariableElement field, String name, boolean statik) {
        return (!statik || field.getModifiers().contains((Object)Modifier.STATIC)) && field.getSimpleName().contentEquals(name);
    }

    private <T> List<T> processTypeParameterDeclarations(TypeElementProcessor<T> processor) {
        return this.typeParameterDeclarationsMap.entrySet().stream().map(e -> new Pair((Object)((Name)e.getKey()), (Object)((List)e.getValue()))).map(p -> new Pair((Object)this.ctx.getMoreElements().getTypeElement((CharSequence)p.fst), (Object)((List)p.snd))).filter(p -> Objects.nonNull(p.fst)).flatMap(p -> processor.process((TypeElement)p.fst, (List)p.snd)).collect(Collectors.toList());
    }

    private void removeHiddenFieldDeclarations(List<FieldDeclaration> candidates) {
        this.removeHiddenDeclarations(candidates, (hider, hidden) -> this.ctx.getMoreElements().hides(hider.element(), hidden.element()));
    }

    private <T> void removeHiddenDeclarations(List<T> candidates, HidingPredicate<T> hidesPredicate) {
        LinkedList<T> hiders = new LinkedList<T>(candidates);
        Iterator<T> it = candidates.iterator();
        block0: while (it.hasNext()) {
            T hidden = it.next();
            for (Object hider : hiders) {
                if (!hidesPredicate.hides(hider, hidden)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    public Optional<MethodDeclaration> getMethodDeclaration(String name, List<TypeDeclaration> parameterTypeDeclarations) {
        return this.getMethodDeclarationInternal(name, parameterTypeDeclarations, false);
    }

    public Optional<MethodDeclaration> getStaticMethodDeclaration(String name, List<TypeDeclaration> parameterTypeDeclarations) {
        return this.getMethodDeclarationInternal(name, parameterTypeDeclarations, true);
    }

    private Optional<MethodDeclaration> getMethodDeclarationInternal(String name, List<TypeDeclaration> parameterTypeDeclarations, boolean statik) {
        List<MethodDeclaration> candidates = this.getCandidateMethodDeclarations(name, parameterTypeDeclarations, statik);
        this.removeOverriddenMethodDeclarations(candidates);
        this.removeHiddenMethodDeclarations(candidates);
        return candidates.stream().findFirst();
    }

    private List<MethodDeclaration> getCandidateMethodDeclarations(String name, List<TypeDeclaration> parameterTypeDeclarations, boolean statik) {
        return this.processTypeParameterDeclarations((typeElement, typeParams) -> ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(m -> this.matchesMethodCriteria((ExecutableElement)m, name, parameterTypeDeclarations, statik)).map(m -> this.ctx.getDeclarations().newMethodDeclaration((ExecutableElement)m, typeParams)));
    }

    private boolean matchesMethodCriteria(ExecutableElement method, String name, List<TypeDeclaration> parameterTypeDeclarations, boolean statik) {
        return (!statik || method.getModifiers().contains((Object)Modifier.STATIC)) && method.getModifiers().contains((Object)Modifier.PUBLIC) && method.getSimpleName().contentEquals(name) && method.getReturnType().getKind() != TypeKind.VOID && method.getParameters().size() == parameterTypeDeclarations.size() && this.isAssignable(parameterTypeDeclarations, method.getParameters());
    }

    private void removeOverriddenMethodDeclarations(List<MethodDeclaration> candidates) {
        this.removeHiddenDeclarations(candidates, this::methodOverrides);
    }

    private boolean methodOverrides(MethodDeclaration overrider, MethodDeclaration overridden) {
        TypeElement overriderTypeElement = this.ctx.getMoreElements().toTypeElement(overrider.element().getEnclosingElement());
        if (overriderTypeElement == null) {
            return false;
        }
        return this.ctx.getMoreElements().overrides(overrider.element(), overridden.element(), overriderTypeElement);
    }

    private void removeHiddenMethodDeclarations(List<MethodDeclaration> candidates) {
        this.removeHiddenDeclarations(candidates, this::methodHides);
    }

    private boolean methodHides(MethodDeclaration hider, MethodDeclaration hidden) {
        TypeMirror subtype = hider.element().getEnclosingElement().asType();
        TypeMirror supertype = hidden.element().getEnclosingElement().asType();
        return this.ctx.getMoreTypes().isAssignableWithErasure(subtype, supertype) && this.ctx.getMoreElements().hides(hider.element(), hidden.element());
    }

    public TypeDeclaration emulateConcatOperation(TypeDeclaration other) {
        Objects.requireNonNull(other);
        AssertionUtil.assertTrue((boolean)this.isTextType(), (Object[])new Object[0]);
        AssertionUtil.assertTrue((boolean)other.isTextType(), (Object[])new Object[0]);
        TypeMirror type = this.ctx.getMoreTypes().getTypeMirror(String.class);
        return this.ctx.getDeclarations().newTypeDeclaration(type);
    }

    public TypeDeclaration emulateArithmeticOperation(TypeDeclaration other) {
        Objects.requireNonNull(other);
        AssertionUtil.assertTrue((boolean)this.isNumberType(), (Object[])new Object[0]);
        AssertionUtil.assertTrue((boolean)other.isNumberType(), (Object[])new Object[0]);
        TypeMirror type = this.numberPriority.getValue() >= other.numberPriority.getValue() ? this.type : other.type;
        return this.ctx.getDeclarations().newTypeDeclaration(type);
    }

    public boolean isSameType(TypeDeclaration other) {
        if (this.ctx.getMoreTypes().isSameTypeWithErasure(this.type, other.type)) {
            return true;
        }
        if (this.isNumberType() && other.isNumberType()) {
            return this.numberPriority.getValue() == other.numberPriority.getValue();
        }
        return false;
    }

    public String toString() {
        return this.type.toString();
    }

    private static NumberTypePriority determineNumberPriority(TypeElement typeElement, TypeMirror type) {
        return Optional.ofNullable(typeElement).map(TypeElement::getQualifiedName).map(Object::toString).map(NUMBER_PRIORITY_MAP::get).orElseGet(() -> NUMBER_PRIORITY_MAP.getOrDefault(type.getKind().name().toLowerCase(), NumberTypePriority.DEFAULT));
    }

    private boolean isAssignable(List<TypeDeclaration> parameterTypeDeclarations, List<? extends VariableElement> parameters) {
        MoreTypes types = this.ctx.getMoreTypes();
        return Zip.stream(parameterTypeDeclarations, parameters).map(p -> p.map(TypeDeclaration::getType, Element::asType)).map(p -> p.map(types::boxIfPrimitive, types::boxIfPrimitive)).allMatch(p -> types.isAssignableWithErasure((TypeMirror)p.fst, (TypeMirror)p.snd));
    }

    private static enum NumberTypePriority {
        BIG_DECIMAL(80),
        BIG_INTEGER(70),
        DOUBLE(60),
        FLOAT(50),
        LONG(40),
        INT(30),
        SHORT(20),
        BYTE(10),
        DEFAULT(0);

        private final int value;

        private NumberTypePriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    @FunctionalInterface
    private static interface TypeElementProcessor<T> {
        public Stream<T> process(TypeElement var1, List<TypeParameterDeclaration> var2);
    }

    @FunctionalInterface
    private static interface HidingPredicate<T> {
        public boolean hides(T var1, T var2);
    }
}

