/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.util.Iterator;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.aggregate.AggregateStrategyMeta;
import org.seasar.doma.internal.apt.meta.aggregate.AssociationLinkerKind;
import org.seasar.doma.internal.apt.meta.aggregate.AssociationLinkerMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.aggregate.AbstractAggregateStrategyType;
import org.seasar.doma.jdbc.aggregate.AssociationLinkerType;

public class AggregateStrategyTypeGenerator
extends AbstractGenerator {
    private final AggregateStrategyMeta strategyMeta;

    public AggregateStrategyTypeGenerator(RoundContext ctx, ClassName className, Printer printer, AggregateStrategyMeta strategyMeta) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)strategyMeta);
        this.strategyMeta = strategyMeta;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    private void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    private void printClass() {
        this.iprint("/** */%n", new Object[0]);
        this.printGenerated();
        this.iprint("public final class %1$s extends %2$s {%n", this.simpleName, AbstractAggregateStrategyType.class);
        this.print("%n", new Object[0]);
        this.indent();
        this.printFields();
        this.printValidateVersionStaticInitializer();
        this.printConstructor();
        this.printMethods();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    private void printFields() {
        this.printSingletonField();
    }

    private void printSingletonField() {
        this.iprint("private static final %1$s __singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
    }

    private void printConstructor() {
        this.iprint("private %1$s() {%n", this.simpleName);
        this.indent();
        this.iprint("super(\"%1$s\", %2$s, \"%3$s\", java.util.List.of(%n", this.strategyMeta.typeElement().getQualifiedName(), this.strategyMeta.root().getTypeCode(), this.strategyMeta.tableAlias());
        this.indent();
        Iterator<AssociationLinkerMeta> iter = this.strategyMeta.associationLinkerMetas().iterator();
        while (iter.hasNext()) {
            AssociationLinkerMeta linkerMeta = iter.next();
            String linkerExpression = this.createLinkerExpression(linkerMeta);
            this.iprint("%1$s.of(\"%2$s\", \"%3$s\", %4$s, \"%5$s\", %6$s, %7$s, %8$s)", AssociationLinkerType.class, linkerMeta.ancestorPath(), linkerMeta.propertyPath(), linkerMeta.propertyPathDepth(), linkerMeta.tableAlias(), linkerMeta.source().getTypeCode(), linkerMeta.target().getTypeCode(), linkerExpression);
            if (iter.hasNext()) {
                this.print(",", new Object[0]);
            }
            this.print("%n", new Object[0]);
        }
        this.unindent();
        this.iprint("));%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printMethods() {
        this.printGetSingletonInternalMethod();
    }

    private void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleName);
        this.iprint("    return __singleton;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private String createLinkerExpression(AssociationLinkerMeta linkerMeta) {
        String expression = String.format("%1$s.%2$s", linkerMeta.classElement(), linkerMeta.filedElement());
        return switch (linkerMeta.linkerKind()) {
            default -> throw new IncompatibleClassChangeError();
            case AssociationLinkerKind.BI_FUNCTION -> expression;
            case AssociationLinkerKind.BI_CONSUMER -> String.format("(a, b) -> { %1$s.accept(a, b); return null; }", expression);
        };
    }
}

