/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.generator.UnwrapOptionalVisitor;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableFieldMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddedMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.criteria.metamodel.DefaultPropertyMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.entity.EntityType;

public class EmbeddableMetamodelGenerator
extends AbstractGenerator {
    private final EmbeddableMeta embeddableMeta;

    public EmbeddableMetamodelGenerator(RoundContext ctx, ClassName className, Printer printer, EmbeddableMeta embeddableMeta) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)embeddableMeta);
        this.embeddableMeta = embeddableMeta;
    }

    @Override
    public void generate() {
        this.printClass();
    }

    private void printClass() {
        this.iprint("/** */%n", new Object[0]);
        this.iprint("public static final class Metamodel {%n", new Object[0]);
        this.print("%n", new Object[0]);
        this.indent();
        this.printFields();
        this.printConstructor();
        this.printMethods();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    private void printFields() {
        this.printAllPropertyModelFields();
        this.printPropertyMetamodelFields();
    }

    private void printAllPropertyModelFields() {
        this.iprint("private final java.util.List<%1$s<?>> __allPropertyMetamodels;%n", PropertyMetamodel.class);
        this.print("%n", new Object[0]);
    }

    private void printPropertyMetamodelFields() {
        UnwrapOptionalVisitor visitor = new UnwrapOptionalVisitor();
        for (EmbeddableFieldMeta f : this.embeddableMeta.getEmbeddableFieldMetas()) {
            if (f instanceof EmbeddedMeta) {
                EmbeddedMeta embeddedMeta = (EmbeddedMeta)f;
                ClassName className = this.createEmbeddableTypeClassName(embeddedMeta.embeddableMeta().getTypeElement());
                this.iprint("public final %1$s.Metamodel %2$s;%n", className, embeddedMeta.getName());
            } else if (f instanceof EmbeddablePropertyMeta) {
                EmbeddablePropertyMeta p = (EmbeddablePropertyMeta)f;
                Pair<CtType, TypeMirror> pair = p.getCtType().accept(visitor, null);
                this.iprint("public final %1$s<%2$s> %3$s;%n", PropertyMetamodel.class, pair.snd, p.getName());
            } else {
                throw new AptIllegalStateException(f.toString());
            }
            this.print("%n", new Object[0]);
        }
    }

    private void printConstructor() {
        EmbeddablePropertyMeta propertyMeta;
        EmbeddedMeta embeddedMeta;
        this.iprint("public Metamodel(%1$s<?> entityType, String name) {%n", EntityType.class);
        this.indent();
        UnwrapOptionalVisitor visitor = new UnwrapOptionalVisitor();
        for (EmbeddableFieldMeta f : this.embeddableMeta.getEmbeddableFieldMetas()) {
            if (f instanceof EmbeddedMeta) {
                embeddedMeta = (EmbeddedMeta)f;
                ClassName className = this.createEmbeddableTypeClassName(embeddedMeta.embeddableMeta().getTypeElement());
                this.iprint("this.%2$s = new %1$s.Metamodel(entityType, name + \".%2$s\");%n", className, embeddedMeta.getName());
                continue;
            }
            if (!(f instanceof EmbeddablePropertyMeta)) continue;
            propertyMeta = (EmbeddablePropertyMeta)f;
            Pair<CtType, TypeMirror> pair = propertyMeta.getCtType().accept(visitor, null);
            this.iprint("this.%1$s = new %2$s<%3$s>(%4$s.class, entityType, name + \".%1$s\");%n", propertyMeta.getName(), DefaultPropertyMetamodel.class, pair.snd, ((CtType)pair.fst).getQualifiedName());
        }
        this.iprint("java.util.List<%1$s<?>> __list = new java.util.ArrayList<>(%2$s);%n", PropertyMetamodel.class, this.embeddableMeta.getEmbeddablePropertyMetas().size());
        for (EmbeddableFieldMeta f : this.embeddableMeta.getEmbeddableFieldMetas()) {
            if (f instanceof EmbeddedMeta) {
                embeddedMeta = (EmbeddedMeta)f;
                this.iprint("__list.addAll(this.%1$s.allPropertyMetamodels());%n", embeddedMeta.getName());
                continue;
            }
            if (!(f instanceof EmbeddablePropertyMeta)) continue;
            propertyMeta = (EmbeddablePropertyMeta)f;
            this.iprint("__list.add(this.%1$s);%n", propertyMeta.getName());
        }
        this.iprint("__allPropertyMetamodels = java.util.Collections.unmodifiableList(__list);%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printMethods() {
        this.printAllPropertyMetamodelsMethod();
    }

    private void printAllPropertyMetamodelsMethod() {
        this.iprint("public java.util.List<%1$s<?>> allPropertyMetamodels() {%n", PropertyMetamodel.class);
        this.indent();
        this.iprint("return __allPropertyMetamodels;%n", new Object[0]);
        this.unindent();
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private ClassName createEmbeddableTypeClassName(TypeElement embeddableTypeElement) {
        if (embeddableTypeElement == null) {
            throw new AptIllegalStateException("embeddableTypeElement");
        }
        Name binaryName = this.ctx.getMoreElements().getBinaryName(embeddableTypeElement);
        return ClassNames.newEmbeddableTypeClassName((CharSequence)binaryName);
    }
}

