/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.doma.EmbeddableTypeImplementation;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.ColumnOverrideAnnot;
import org.seasar.doma.internal.apt.annot.EmbeddedAnnot;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.Code;
import org.seasar.doma.internal.apt.generator.EmbeddableMetamodelGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.generator.ScalarMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableFieldMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddedMeta;
import org.seasar.doma.internal.jdbc.entity.PropertyPath;
import org.seasar.doma.internal.jdbc.entity.PropertyPathSegment;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.ColumnType;
import org.seasar.doma.jdbc.entity.DefaultPropertyType;
import org.seasar.doma.jdbc.entity.EmbeddableType;
import org.seasar.doma.jdbc.entity.EmbeddedType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.Property;

public class EmbeddableTypeGenerator
extends AbstractGenerator {
    private final EmbeddableMeta embeddableMeta;

    public EmbeddableTypeGenerator(RoundContext ctx, ClassName className, Printer printer, EmbeddableMeta embeddableMeta) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)embeddableMeta);
        this.embeddableMeta = embeddableMeta;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    private void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    private void printClass() {
        this.iprint("/** */%n", new Object[0]);
        this.printGenerated();
        this.printEmbeddableTypeImplementation();
        this.iprint("public final class %1$s implements %2$s<%3$s> {%n", this.simpleName, EmbeddableType.class, this.embeddableMeta.getType());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printMethods();
        this.printNestedClass();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    private void printEmbeddableTypeImplementation() {
        this.iprint("@%1$s%n", EmbeddableTypeImplementation.class);
    }

    private void printFields() {
        this.printSingletonField();
    }

    private void printSingletonField() {
        this.iprint("private static final %1$s __singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
    }

    private void printMethods() {
        this.printGetEmbeddablePropertyTypesMethod();
        this.printNewEmbeddableMethod();
        this.printGetSingletonInternalMethod();
    }

    private void printGetEmbeddablePropertyTypesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public <ENTITY> %1$s<%2$s<ENTITY, ?>> getEmbeddablePropertyTypes(%5$s embeddedPropertyPath, Class<ENTITY> entityClass, %3$s namingType, %4$s embeddedType) {%n", List.class, EntityPropertyType.class, NamingType.class, EmbeddedType.class, PropertyPath.class);
        this.iprint("    return %1$s.of(%n", List.class);
        Iterator<EmbeddableFieldMeta> it = this.embeddableMeta.getEmbeddableFieldMetas().iterator();
        while (it.hasNext()) {
            EmbeddableFieldMeta fieldMeta = it.next();
            if (fieldMeta instanceof EmbeddedMeta) {
                EmbeddedMeta embeddedMeta = (EmbeddedMeta)fieldMeta;
                Code path = embeddedMeta.optional() ? new Code(p -> p.print("%1$s.combine(embeddedPropertyPath, new %2$s(\"%3$s\", %4$s.class))", PropertyPath.class, PropertyPathSegment.Optional.class, embeddedMeta.getName(), embeddedMeta.embeddableCtType().getType())) : new Code(p -> p.print("%1$s.combine(embeddedPropertyPath, new %2$s(\"%3$s\"))", PropertyPath.class, PropertyPathSegment.Default.class, embeddedMeta.getName()));
                this.iprint("        %1$s.getEmbeddablePropertyTypes(%2$s, entityClass, namingType, %3$s)", embeddedMeta.embeddableCtType().getTypeCode(), path, this.toEmbeddedTypeCode(embeddedMeta.name(), embeddedMeta.embeddedAnnot()));
            } else if (fieldMeta instanceof EmbeddablePropertyMeta) {
                EmbeddablePropertyMeta propertyMeta = (EmbeddablePropertyMeta)fieldMeta;
                ScalarMetaFactory.ScalarMeta scalarMeta = propertyMeta.getCtType().accept(new ScalarMetaFactory(), false);
                Code segment = new Code(p -> p.print("new %1$s(\"%2$s\")", PropertyPathSegment.Default.class, propertyMeta.getName()));
                this.iprint("        java.util.List.<org.seasar.doma.jdbc.entity.EntityPropertyType<ENTITY,?>>of(new %1$s<ENTITY, %2$s, %3$s>(entityClass, %4$s, %10$s.combine(embeddedPropertyPath, %5$s), \"%6$s\", namingType, %7$s, %8$s, %9$s, embeddedType))", DefaultPropertyType.class, scalarMeta.getBasicType(), scalarMeta.getContainerType(), scalarMeta.getSupplier(), segment, propertyMeta.getColumnName(), propertyMeta.isColumnInsertable(), propertyMeta.isColumnUpdatable(), propertyMeta.isColumnQuoteRequired(), PropertyPath.class);
            } else {
                throw new AptIllegalStateException(fieldMeta.toString());
            }
            this.print(it.hasNext() ? ",%n" : "", new Object[0]);
        }
        this.print("%n", new Object[0]);
        this.iprint("    ).stream().flatMap(it -> it.stream()).toList();%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printNewEmbeddableMethod() {
        if (this.embeddableMeta.getEmbeddableFieldMetas().stream().anyMatch(p -> p.getCtType().hasTypeParameter())) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public <ENTITY> %1$s newEmbeddable(String embeddedPropertyName, %2$s<String, %3$s<ENTITY, ?>> __args, boolean optional) {%n", this.embeddableMeta.getType(), Map.class, Property.class);
        if (this.embeddableMeta.isAbstract()) {
            this.iprint("    return null;%n", new Object[0]);
        } else {
            int j;
            int i = 0;
            for (EmbeddableFieldMeta fieldMeta : this.embeddableMeta.getEmbeddableFieldMetas()) {
                this.iprint("    var __p%s = ", i++);
                if (fieldMeta instanceof EmbeddedMeta) {
                    EmbeddedMeta embeddedMeta = (EmbeddedMeta)fieldMeta;
                    if (embeddedMeta.optional()) {
                        this.print("java.util.Optional.ofNullable((%1$s)%2$s.newEmbeddable(embeddedPropertyName + \".%3$s\", __args, true))", embeddedMeta.embeddableMeta().getType(), embeddedMeta.embeddableCtType().getTypeCode(), embeddedMeta.name());
                    } else {
                        this.print("(%1$s)%2$s.newEmbeddable(embeddedPropertyName + \".%3$s\", __args, false)", embeddedMeta.embeddableMeta().getType(), embeddedMeta.embeddableCtType().getTypeCode(), embeddedMeta.name());
                    }
                } else if (fieldMeta instanceof EmbeddablePropertyMeta) {
                    EmbeddablePropertyMeta propertyMeta = (EmbeddablePropertyMeta)fieldMeta;
                    this.print("(%1$s)(__args.get(embeddedPropertyName + \".%2$s\") != null ? __args.get(embeddedPropertyName + \".%2$s\").get() : null)", propertyMeta.getBoxedType(), propertyMeta.getName());
                } else {
                    throw new AptIllegalStateException(fieldMeta.toString());
                }
                this.print(";%n", new Object[0]);
            }
            this.iprint("    if (optional) {%n", new Object[0]);
            this.iprint("        var __stream = java.util.stream.Stream.<Object>of(", new Object[0]);
            for (j = 0; j < i; ++j) {
                this.print("__p%s%s", j, j == i - 1 ? "" : ", ");
            }
            this.print(").map(it -> (it instanceof java.util.Optional<?> o) ?  o.orElse(null) : it).filter(java.util.Objects::nonNull);;%n", i);
            this.iprint("        if (__stream.findAny().isEmpty()) {%n", new Object[0]);
            this.iprint("            return null;%n", new Object[0]);
            this.iprint("        }%n", new Object[0]);
            this.iprint("    }%n", new Object[0]);
            this.iprint("    return new %1$s(", this.embeddableMeta.getType());
            for (j = 0; j < i; ++j) {
                this.print("__p%s%s", j, j == i - 1 ? "" : ", ");
            }
            this.print(");%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleName);
        this.iprint("    return __singleton;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    private void printNestedClass() {
        EmbeddableMetamodelGenerator generator = new EmbeddableMetamodelGenerator(this.ctx, this.className, this.printer, this.embeddableMeta);
        generator.generate();
    }

    private Code toEmbeddedTypeCode(String embeddedName, EmbeddedAnnot embeddedAnnot) {
        return new Code(p -> {
            if (embeddedAnnot == null) {
                p.print("embeddedType", new Object[0]);
            } else {
                p.print("new %1$s(\"%2$s\", java.util.Map.ofEntries(%3$s)).merge(embeddedType)", EmbeddedType.class, embeddedAnnot.getPrefixValue(), this.toMapEntryCode(embeddedName, embeddedAnnot.getColumnOverridesValue()));
            }
        });
    }

    private Code toMapEntryCode(String embeddedName, List<ColumnOverrideAnnot> columnOverrideAnnotList) {
        return new Code(p -> {
            Iterator it = columnOverrideAnnotList.iterator();
            while (it.hasNext()) {
                ColumnOverrideAnnot columnOverrideAnnot = (ColumnOverrideAnnot)it.next();
                String name = columnOverrideAnnot.getNameValue();
                ColumnOverrideAnnot.ColumnAnnot column = columnOverrideAnnot.getColumnValue();
                p.print("java.util.Map.entry(embeddedPropertyPath + \".%7$s\" + \".%1$s\", new %2$s(%3$s, %4$s, %5$s, %6$s))", name, ColumnType.class, column.getNameValue() != null ? "\"" + column.getNameValue() + "\"" : null, column.getInsertableValue(), column.getUpdatableValue(), column.getQuoteValue(), embeddedName);
                if (!it.hasNext()) continue;
                p.print(", ", new Object[0]);
            }
        });
    }
}

