/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.util.Iterator;
import java.util.List;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.ColumnOverrideAnnot;
import org.seasar.doma.internal.apt.annot.EmbeddedAnnot;
import org.seasar.doma.internal.apt.generator.AbstractGenerator;
import org.seasar.doma.internal.apt.generator.Code;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.generator.ScalarMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EmbeddedMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityFieldMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityPropertyMeta;
import org.seasar.doma.internal.jdbc.entity.PropertyPath;
import org.seasar.doma.internal.jdbc.entity.PropertyPathSegment;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.AssignedIdPropertyType;
import org.seasar.doma.jdbc.entity.ColumnType;
import org.seasar.doma.jdbc.entity.DefaultPropertyType;
import org.seasar.doma.jdbc.entity.EmbeddedPropertyType;
import org.seasar.doma.jdbc.entity.EmbeddedType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.entity.TenantIdPropertyType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class EntityTypePropertyGenerator
extends AbstractGenerator {
    private final EntityMeta entityMeta;
    private final EntityFieldMeta fieldMeta;

    EntityTypePropertyGenerator(RoundContext ctx, ClassName className, Printer printer, EntityMeta entityMeta, EntityFieldMeta entityFieldMeta) {
        super(ctx, className, printer);
        AssertionUtil.assertNotNull((Object)entityMeta);
        this.entityMeta = entityMeta;
        this.fieldMeta = entityFieldMeta;
    }

    @Override
    public void generate() {
        this.printPropertyTypeField();
    }

    private void printPropertyTypeField() {
        EntityFieldMeta entityFieldMeta = this.fieldMeta;
        if (entityFieldMeta instanceof EmbeddedMeta) {
            EmbeddedMeta embeddedMeta = (EmbeddedMeta)entityFieldMeta;
            this.printEmbeddedPropertyTypeField(embeddedMeta);
        } else {
            entityFieldMeta = this.fieldMeta;
            if (entityFieldMeta instanceof EntityPropertyMeta) {
                EntityPropertyMeta propertyMeta = (EntityPropertyMeta)entityFieldMeta;
                ScalarMetaFactory.ScalarMeta scalarMeta = propertyMeta.getCtType().accept(new ScalarMetaFactory(), false);
                if (propertyMeta.isId()) {
                    if (propertyMeta.getIdGeneratorMeta() != null) {
                        this.printGeneratedIdPropertyTypeField(propertyMeta, scalarMeta);
                    } else {
                        this.printAssignedIdPropertyTypeField(propertyMeta, scalarMeta);
                    }
                } else if (propertyMeta.isVersion()) {
                    this.printVersionPropertyTypeField(propertyMeta, scalarMeta);
                } else if (propertyMeta.isTenantId()) {
                    this.printTenantIdPropertyTypeField(propertyMeta, scalarMeta);
                } else {
                    this.printDefaultPropertyTypeField(propertyMeta, scalarMeta);
                }
            }
        }
    }

    private void printEmbeddedPropertyTypeField(EmbeddedMeta embeddedMeta) {
        Code path = embeddedMeta.optional() ? new Code(p -> p.print("new %1$s(java.util.List.of(new %2$s(\"%3$s\", %4$s.class)))", PropertyPath.class, PropertyPathSegment.Optional.class, this.fieldMeta.getName(), embeddedMeta.embeddableCtType().getType())) : new Code(p -> p.print("new %1$s(java.util.List.of(new %2$s(\"%3$s\")))", PropertyPath.class, PropertyPathSegment.Default.class, this.fieldMeta.getName()));
        this.print("new %1$s<%2$s, %3$s>(%5$s, %2$s.class, %6$s.getEmbeddablePropertyTypes(%5$s, %2$s.class, __namingType, %7$s), %8$s)", EmbeddedPropertyType.class, this.entityMeta.getType(), this.fieldMeta.getCtType().getType(), null, path, embeddedMeta.embeddableCtType().getTypeCode(), this.toEmbeddedTypeCode(embeddedMeta.embeddedAnnot()), embeddedMeta.optional());
    }

    private void printGeneratedIdPropertyTypeField(EntityPropertyMeta propertyMeta, ScalarMetaFactory.ScalarMeta scalarMeta) {
        this.print("new %1$s<%2$s, %3$s, %4$s>(%6$s.class, %7$s, \"%8$s\", \"%9$s\", __namingType, %10$s, __idGenerator)", GeneratedIdPropertyType.class, this.entityMeta.getType(), scalarMeta.getBasicType(), scalarMeta.getContainerType(), null, this.entityMeta.getType(), scalarMeta.getSupplier(), propertyMeta.getName(), propertyMeta.getColumnName(), propertyMeta.isColumnQuoteRequired());
    }

    private void printAssignedIdPropertyTypeField(EntityPropertyMeta propertyMeta, ScalarMetaFactory.ScalarMeta scalarMeta) {
        this.print("new %1$s<%2$s, %3$s, %4$s>(%6$s.class, %7$s, \"%8$s\", \"%9$s\", __namingType, %10$s)", AssignedIdPropertyType.class, this.entityMeta.getType(), scalarMeta.getBasicType(), scalarMeta.getContainerType(), null, this.entityMeta.getType(), scalarMeta.getSupplier(), propertyMeta.getName(), propertyMeta.getColumnName(), propertyMeta.isColumnQuoteRequired());
    }

    private void printVersionPropertyTypeField(EntityPropertyMeta propertyMeta, ScalarMetaFactory.ScalarMeta scalarMeta) {
        this.print("new %1$s<%2$s, %3$s, %4$s>(%6$s.class, %7$s, \"%8$s\", \"%9$s\", __namingType, %10$s)", VersionPropertyType.class, this.entityMeta.getType(), scalarMeta.getBasicType(), scalarMeta.getContainerType(), null, this.entityMeta.getType(), scalarMeta.getSupplier(), propertyMeta.getName(), propertyMeta.getColumnName(), propertyMeta.isColumnQuoteRequired());
    }

    private void printTenantIdPropertyTypeField(EntityPropertyMeta propertyMeta, ScalarMetaFactory.ScalarMeta scalarMeta) {
        this.print("new %1$s<%2$s, %3$s, %4$s>(%6$s.class, %7$s, \"%8$s\", \"%9$s\", __namingType, %10$s)", TenantIdPropertyType.class, this.entityMeta.getType(), scalarMeta.getBasicType(), scalarMeta.getContainerType(), null, this.entityMeta.getType(), scalarMeta.getSupplier(), propertyMeta.getName(), propertyMeta.getColumnName(), propertyMeta.isColumnQuoteRequired());
    }

    private void printDefaultPropertyTypeField(EntityPropertyMeta propertyMeta, ScalarMetaFactory.ScalarMeta scalarMeta) {
        this.print("new %1$s<%2$s, %3$s, %4$s>(%6$s.class, %7$s, \"%8$s\", \"%9$s\", __namingType, %10$s, %11$s, %12$s)", DefaultPropertyType.class, this.entityMeta.getType(), scalarMeta.getBasicType(), scalarMeta.getContainerType(), null, this.entityMeta.getType(), scalarMeta.getSupplier(), this.fieldMeta.getName(), propertyMeta.getColumnName(), propertyMeta.isColumnInsertable(), propertyMeta.isColumnUpdatable(), propertyMeta.isColumnQuoteRequired());
    }

    private Code toEmbeddedTypeCode(EmbeddedAnnot embeddedAnnot) {
        return new Code(p -> {
            if (embeddedAnnot == null) {
                p.print("null", new Object[0]);
            } else {
                p.print("new %1$s(\"%2$s\", java.util.Map.ofEntries(%3$s))", EmbeddedType.class, embeddedAnnot.getPrefixValue(), this.toMapEntryCode(embeddedAnnot.getColumnOverridesValue()));
            }
        });
    }

    private Code toMapEntryCode(List<ColumnOverrideAnnot> columnOverrideAnnotList) {
        return new Code(p -> {
            Iterator it = columnOverrideAnnotList.iterator();
            while (it.hasNext()) {
                ColumnOverrideAnnot columnOverrideAnnot = (ColumnOverrideAnnot)it.next();
                String name = columnOverrideAnnot.getNameValue();
                ColumnOverrideAnnot.ColumnAnnot column = columnOverrideAnnot.getColumnValue();
                p.print("java.util.Map.entry(\"%7$s.%1$s\", new %2$s(%3$s, %4$s, %5$s, %6$s))", name, ColumnType.class, column.getNameValue() != null ? "\"" + column.getNameValue() + "\"" : null, column.getInsertableValue(), column.getUpdatableValue(), column.getQuoteValue(), this.fieldMeta.getName());
                if (!it.hasNext()) continue;
                p.print(", ", new Object[0]);
            }
        });
    }
}

