/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Formatter;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.util.IOUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class JavaFileGenerator<M extends TypeElementMeta> {
    private final RoundContext ctx;
    private final ClassNameFactory<M> classNameFactory;
    private final GeneratorFactory<M> generatorFactory;

    public JavaFileGenerator(RoundContext ctx, ClassNameFactory<M> classNameFactory, GeneratorFactory<M> generatorFactory) {
        this.ctx = Objects.requireNonNull(ctx);
        this.classNameFactory = Objects.requireNonNull(classNameFactory);
        this.generatorFactory = Objects.requireNonNull(generatorFactory);
    }

    public void generate(TypeElement typeElement, M meta) {
        ClassName className = this.classNameFactory.create(typeElement, meta);
        Formatter formatter = null;
        try {
            JavaFileObject file = this.ctx.getResources().createSourceFile((CharSequence)className, typeElement);
            formatter = new Formatter(new BufferedWriter(file.openWriter()));
            Printer printer = new Printer(this.ctx, formatter);
            Generator generator = this.generatorFactory.create(className, printer, meta);
            generator.generate();
        }
        catch (IOException | UncheckedIOException e) {
            try {
                throw new AptException((MessageResource)Message.DOMA4011, (Element)typeElement, e, new Object[]{typeElement.getQualifiedName(), e});
            }
            catch (Throwable throwable) {
                IOUtil.close(formatter);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)formatter);
    }

    public static interface ClassNameFactory<M extends TypeElementMeta> {
        public ClassName create(TypeElement var1, M var2);
    }

    public static interface GeneratorFactory<M extends TypeElementMeta> {
        public Generator create(ClassName var1, Printer var2, M var3);
    }
}

