/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableFieldMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EmbeddedMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddedMetaFactory;
import org.seasar.doma.internal.util.AssertionUtil;

class EmbeddableFieldMetaFactory {
    private final RoundContext ctx;
    private final VariableElement fieldElement;

    public EmbeddableFieldMetaFactory(RoundContext ctx, VariableElement fieldElement) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)fieldElement);
        this.ctx = ctx;
        this.fieldElement = fieldElement;
    }

    public EmbeddableFieldMeta createEmbeddableFieldMeta() {
        CtType ctType = this.ctx.getCtTypes().newCtType(this.fieldElement.asType());
        if (ctType instanceof OptionalCtType) {
            OptionalCtType optionalCtType = (OptionalCtType)ctType;
            CtType ctType2 = optionalCtType.getElementCtType();
            if (ctType2 instanceof EmbeddableCtType) {
                EmbeddableCtType embeddableCtType = (EmbeddableCtType)ctType2;
                return this.createEmbeddedMeta(optionalCtType, embeddableCtType);
            }
        } else if (ctType instanceof EmbeddableCtType) {
            EmbeddableCtType embeddableCtType = (EmbeddableCtType)ctType;
            return this.createEmbeddedMeta(embeddableCtType, embeddableCtType);
        }
        return this.createEmbeddablePropertyMeta();
    }

    private EmbeddedMeta createEmbeddedMeta(CtType ctType, EmbeddableCtType embeddableCtType) {
        EmbeddedMetaFactory factory = new EmbeddedMetaFactory(this.ctx, this.fieldElement, ctType, embeddableCtType);
        return factory.createEmbeddedMeta();
    }

    private EmbeddablePropertyMeta createEmbeddablePropertyMeta() {
        EmbeddablePropertyMetaFactory factory = new EmbeddablePropertyMetaFactory(this.ctx, this.fieldElement);
        return factory.createEmbeddablePropertyMeta();
    }
}

