/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.EmbeddableAnnot;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableConstructorMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableFieldMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddedMeta;
import org.seasar.doma.internal.util.AssertionUtil;

public final class EmbeddableMeta
implements TypeElementMeta {
    private final EmbeddableAnnot embeddableAnnot;
    private final TypeElement typeElement;
    private final TypeMirror type;
    private final List<EmbeddableFieldMeta> fieldMetas = new ArrayList<EmbeddableFieldMeta>();
    private EmbeddableConstructorMeta constructorMeta;
    private boolean error;

    public EmbeddableMeta(EmbeddableAnnot embeddableAnnot, TypeElement typeElement) {
        AssertionUtil.assertNotNull((Object)embeddableAnnot, (Object)typeElement);
        this.embeddableAnnot = embeddableAnnot;
        this.typeElement = typeElement;
        this.type = typeElement.asType();
    }

    public EmbeddableAnnot getEmbeddableAnnot() {
        return this.embeddableAnnot;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public List<EmbeddablePropertyMeta> getEmbeddablePropertyMetas() {
        ArrayList<EmbeddablePropertyMeta> results = new ArrayList<EmbeddablePropertyMeta>();
        for (EmbeddableFieldMeta fieldMeta : this.getEmbeddableFieldMetas()) {
            if (fieldMeta instanceof EmbeddedMeta) {
                EmbeddedMeta embeddedMeta = (EmbeddedMeta)fieldMeta;
                results.addAll(embeddedMeta.embeddableMeta().getEmbeddablePropertyMetas());
                continue;
            }
            if (fieldMeta instanceof EmbeddablePropertyMeta) {
                EmbeddablePropertyMeta propertyMeta = (EmbeddablePropertyMeta)fieldMeta;
                results.add(propertyMeta);
                continue;
            }
            throw new AptIllegalStateException(fieldMeta.toString());
        }
        return results;
    }

    public void addEmbeddableFieldMeta(EmbeddableFieldMeta fieldMeta) {
        this.fieldMetas.add(fieldMeta);
    }

    public List<EmbeddableFieldMeta> getEmbeddableFieldMetas() {
        if (this.constructorMeta != null) {
            return this.constructorMeta.getEmbeddableFieldMetas();
        }
        return this.fieldMetas;
    }

    public void setConstructorMeta(EmbeddableConstructorMeta constructorMeta) {
        this.constructorMeta = constructorMeta;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isAbstract() {
        return this.typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }
}

