/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.ColumnAnnot;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

class EmbeddablePropertyMetaFactory {
    private final RoundContext ctx;
    private final VariableElement fieldElement;

    public EmbeddablePropertyMetaFactory(RoundContext ctx, VariableElement fieldElement) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)fieldElement);
        this.ctx = ctx;
        this.fieldElement = fieldElement;
    }

    public EmbeddablePropertyMeta createEmbeddablePropertyMeta() {
        CtType ctType = this.ctx.getCtTypes().newCtType(this.fieldElement.asType(), new CtTypeValidator());
        EmbeddablePropertyMeta embeddablePropertyMeta = new EmbeddablePropertyMeta(ctType);
        embeddablePropertyMeta.setName(this.fieldElement.getSimpleName().toString());
        ColumnAnnot columnAnnot = this.ctx.getAnnotations().newColumnAnnot(this.fieldElement);
        if (columnAnnot != null) {
            embeddablePropertyMeta.setColumnAnnot(columnAnnot);
        }
        return embeddablePropertyMeta;
    }

    private class CtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, AptException> {
        private CtTypeValidator() {
        }

        @Override
        protected Void defaultAction(CtType ctType, Void aVoid) throws AptException {
            throw new AptException((MessageResource)Message.DOMA4298, EmbeddablePropertyMetaFactory.this.fieldElement, new Object[]{ctType.getType()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType optionalCtType, Void aVoid) throws AptException {
            if (optionalCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4299, EmbeddablePropertyMetaFactory.this.fieldElement, new Object[]{optionalCtType.getQualifiedName()});
            }
            if (optionalCtType.hasWildcard()) {
                throw new AptException((MessageResource)Message.DOMA4301, EmbeddablePropertyMetaFactory.this.fieldElement, new Object[]{optionalCtType.getQualifiedName()});
            }
            return optionalCtType.getElementCtType().accept(this, aVoid);
        }

        @Override
        public Void visitDomainCtType(DomainCtType domainCtType, Void aVoid) throws AptException {
            if (domainCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4295, EmbeddablePropertyMetaFactory.this.fieldElement, new Object[]{domainCtType.getQualifiedName()});
            }
            if (domainCtType.hasWildcard() || domainCtType.hasTypevar()) {
                throw new AptException((MessageResource)Message.DOMA4296, EmbeddablePropertyMetaFactory.this.fieldElement, new Object[]{domainCtType.getQualifiedName()});
            }
            return null;
        }

        @Override
        public Void visitEmbeddableCtType(EmbeddableCtType embeddableCtType, Void aVoid) throws AptException {
            throw new AptException((MessageResource)Message.DOMA4297, EmbeddablePropertyMetaFactory.this.fieldElement, new Object[]{embeddableCtType.getType()});
        }
    }
}

