/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.GeneratedValue;
import org.seasar.doma.Id;
import org.seasar.doma.TenantId;
import org.seasar.doma.Version;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.ColumnAnnot;
import org.seasar.doma.internal.apt.annot.ColumnOverrideAnnot;
import org.seasar.doma.internal.apt.annot.EmbeddedAnnot;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EmbeddedMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

class EmbeddedMetaFactory {
    private final RoundContext ctx;
    private final VariableElement fieldElement;
    private final CtType ctType;
    private final EmbeddableCtType embeddableCtType;

    public EmbeddedMetaFactory(RoundContext ctx, VariableElement fieldElement, CtType ctType, EmbeddableCtType embeddableCtType) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)fieldElement, (Object)ctType, (Object)embeddableCtType);
        this.ctx = ctx;
        this.fieldElement = fieldElement;
        this.ctType = ctType;
        this.embeddableCtType = embeddableCtType;
    }

    public EmbeddedMeta createEmbeddedMeta() {
        TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(this.embeddableCtType.getType());
        if (typeElement == null) {
            throw new AptIllegalStateException("failed to convert to TypeElement: " + String.valueOf(this.fieldElement.getSimpleName()));
        }
        this.validateName();
        this.validateId();
        this.validateVersion();
        this.validateTenantId();
        this.validateColumn();
        this.validateClassReference(typeElement, new HashSet<String>());
        EmbeddedAnnot embeddedAnnot = this.ctx.getAnnotations().newEmbeddedAnnot(this.fieldElement);
        this.validateEmbeddedAnnotation(typeElement, embeddedAnnot);
        EmbeddableMetaFactory embeddableMetaFactory = new EmbeddableMetaFactory(this.ctx);
        EmbeddableMeta embeddableMeta = embeddableMetaFactory.createTypeElementMeta(typeElement);
        return new EmbeddedMeta(this.fieldElement.getSimpleName().toString(), embeddableMeta, this.ctType, this.embeddableCtType, embeddedAnnot);
    }

    private void validateClassReference(TypeElement typeElement, Set<String> visitedClassNames) {
        if (!visitedClassNames.add(typeElement.getQualifiedName().toString())) {
            throw new AptException((MessageResource)Message.DOMA4500, this.fieldElement, new Object[]{this.fieldElement.getSimpleName(), typeElement.getQualifiedName()});
        }
        for (VariableElement enclosedElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            CtType enclosedCtType = this.ctx.getCtTypes().newCtType(enclosedElement.asType());
            CtType unwrappedCtType = this.unwrapOptionalCtType(enclosedCtType);
            if (!(unwrappedCtType instanceof EmbeddableCtType)) continue;
            EmbeddableCtType enclosedEmbeddableCtType = (EmbeddableCtType)unwrappedCtType;
            TypeElement enclosedTypeElement = this.ctx.getMoreTypes().toTypeElement(enclosedEmbeddableCtType.getType());
            AssertionUtil.assertNotNull((Object)enclosedTypeElement);
            this.validateClassReference(enclosedTypeElement, new HashSet<String>(visitedClassNames));
        }
    }

    private void validateEmbeddedAnnotation(TypeElement typeElement, EmbeddedAnnot embeddedAnnot) {
        if (embeddedAnnot == null) {
            return;
        }
        HashSet<String> pathNames = new HashSet<String>();
        this.collectPropertyPathNames(typeElement, null, pathNames);
        for (ColumnOverrideAnnot columnOverride : embeddedAnnot.getColumnOverridesValue()) {
            String name = columnOverride.getNameValue();
            if (pathNames.contains(name)) continue;
            throw new AptException((MessageResource)Message.DOMA4499, this.fieldElement, embeddedAnnot.getAnnotationMirror(), columnOverride.getName(), new Object[]{name, typeElement.getQualifiedName()});
        }
    }

    private void collectPropertyPathNames(TypeElement typeElement, String prefix, Set<String> propertyPathNames) {
        for (VariableElement enclosedElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            CtType enclosedCtType = this.ctx.getCtTypes().newCtType(enclosedElement.asType());
            CtType unwrappedCtType = this.unwrapOptionalCtType(enclosedCtType);
            if (unwrappedCtType instanceof EmbeddableCtType) {
                EmbeddableCtType enclosedEmbeddableCtType = (EmbeddableCtType)unwrappedCtType;
                TypeElement enclosedTypeElement = this.ctx.getMoreTypes().toTypeElement(enclosedEmbeddableCtType.getType());
                AssertionUtil.assertNotNull((Object)enclosedTypeElement);
                String simpleName = enclosedElement.getSimpleName().toString();
                String newPrefix = prefix != null ? prefix + "." + simpleName : simpleName;
                this.collectPropertyPathNames(enclosedTypeElement, newPrefix, propertyPathNames);
                continue;
            }
            String simpleName = enclosedElement.getSimpleName().toString();
            String name = prefix != null ? prefix + "." + simpleName : simpleName;
            propertyPathNames.add(name);
        }
    }

    private CtType unwrapOptionalCtType(CtType ctType) {
        if (ctType instanceof OptionalCtType) {
            OptionalCtType optionalCtType = (OptionalCtType)ctType;
            return optionalCtType.getElementCtType();
        }
        return ctType;
    }

    private void validateName() {
        String name = this.fieldElement.getSimpleName().toString();
        if (name.startsWith("__")) {
            throw new AptException((MessageResource)Message.DOMA4025, this.fieldElement, new Object[]{"__"});
        }
    }

    private void validateId() {
        Id id = this.fieldElement.getAnnotation(Id.class);
        if (id != null) {
            throw new AptException((MessageResource)Message.DOMA4302, this.fieldElement, new Object[0]);
        }
        GeneratedValue generatedValue = this.fieldElement.getAnnotation(GeneratedValue.class);
        if (generatedValue != null) {
            throw new AptException((MessageResource)Message.DOMA4303, this.fieldElement, new Object[0]);
        }
    }

    private void validateVersion() {
        Version version = this.fieldElement.getAnnotation(Version.class);
        if (version != null) {
            throw new AptException((MessageResource)Message.DOMA4304, this.fieldElement, new Object[0]);
        }
    }

    private void validateTenantId() {
        TenantId tenantId = this.fieldElement.getAnnotation(TenantId.class);
        if (tenantId != null) {
            throw new AptException((MessageResource)Message.DOMA4441, this.fieldElement, new Object[0]);
        }
    }

    private void validateColumn() {
        ColumnAnnot columnAnnot = this.ctx.getAnnotations().newColumnAnnot(this.fieldElement);
        if (columnAnnot != null) {
            throw new AptException((MessageResource)Message.DOMA4306, (Element)this.fieldElement, columnAnnot.getAnnotationMirror(), new Object[0]);
        }
    }
}

