/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.meta.entity.EmbeddedMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddedMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EntityFieldMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityPropertyMetaFactory;
import org.seasar.doma.internal.util.AssertionUtil;

class EntityFieldMetaFactory {
    private final RoundContext ctx;
    private final EntityMeta entityMeta;
    private final VariableElement fieldElement;

    public EntityFieldMetaFactory(RoundContext ctx, EntityMeta entityMeta, VariableElement fieldElement) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)entityMeta, (Object)fieldElement);
        this.ctx = ctx;
        this.entityMeta = entityMeta;
        this.fieldElement = fieldElement;
    }

    public EntityFieldMeta createEntityFieldMeta() {
        CtType ctType = this.ctx.getCtTypes().newCtType(this.fieldElement.asType());
        if (ctType instanceof OptionalCtType) {
            OptionalCtType optionalCtType = (OptionalCtType)ctType;
            CtType ctType2 = optionalCtType.getElementCtType();
            if (ctType2 instanceof EmbeddableCtType) {
                EmbeddableCtType embeddableCtType = (EmbeddableCtType)ctType2;
                return this.createEmbeddedMeta(optionalCtType, embeddableCtType);
            }
        } else if (ctType instanceof EmbeddableCtType) {
            EmbeddableCtType embeddableCtType = (EmbeddableCtType)ctType;
            return this.createEmbeddedMeta(embeddableCtType, embeddableCtType);
        }
        return this.createEntityPropertyMeta();
    }

    private EmbeddedMeta createEmbeddedMeta(CtType ctType, EmbeddableCtType embeddableCtType) {
        EmbeddedMetaFactory factory = new EmbeddedMetaFactory(this.ctx, this.fieldElement, ctType, embeddableCtType);
        return factory.createEmbeddedMeta();
    }

    private EntityPropertyMeta createEntityPropertyMeta() {
        EntityPropertyMetaFactory factory = new EntityPropertyMetaFactory(this.ctx, this.entityMeta, this.fieldElement);
        return factory.createEntityPropertyMeta();
    }
}

