/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Association;
import org.seasar.doma.Entity;
import org.seasar.doma.EntityField;
import org.seasar.doma.OriginalStates;
import org.seasar.doma.ParameterName;
import org.seasar.doma.Transient;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.AllArgsConstructorAnnot;
import org.seasar.doma.internal.apt.annot.EntityAnnot;
import org.seasar.doma.internal.apt.annot.MetamodelAnnot;
import org.seasar.doma.internal.apt.annot.TableAnnot;
import org.seasar.doma.internal.apt.annot.ValueAnnot;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.AssociationPropertyMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityConstructorMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityFieldMeta;
import org.seasar.doma.internal.apt.meta.entity.EntityFieldMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EntityMeta;
import org.seasar.doma.internal.apt.meta.entity.OriginalStatesMeta;
import org.seasar.doma.internal.apt.meta.entity.ScopeClassMeta;
import org.seasar.doma.internal.apt.meta.entity.ScopeClassMetaFactory;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.EntityListener;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.NullEntityListener;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EntityMetaFactory
implements TypeElementMetaFactory<EntityMeta> {
    private final RoundContext ctx;

    public EntityMetaFactory(RoundContext ctx) {
        AssertionUtil.assertNotNull((Object)ctx);
        this.ctx = ctx;
    }

    @Override
    public EntityMeta createTypeElementMeta(TypeElement classElement) {
        AssertionUtil.assertNotNull((Object)classElement);
        EntityAnnot entityAnnot = this.ctx.getAnnotations().newEntityAnnot(classElement);
        if (entityAnnot == null) {
            throw new AptIllegalStateException("entityAnnot.");
        }
        EntityMeta entityMeta = new EntityMeta(entityAnnot, classElement);
        TypeMirror entityListener = this.resolveEntityListener(classElement);
        TypeElement entityListenerElement = this.ctx.getMoreTypes().toTypeElement(entityListener);
        if (entityListenerElement == null) {
            throw new AptIllegalStateException("entityListener.");
        }
        entityMeta.setEntityListenerElement(entityListenerElement);
        entityMeta.setGenericEntityListener(!entityListenerElement.getTypeParameters().isEmpty());
        NamingType namingType = this.resolveNamingType(classElement);
        entityMeta.setNamingType(namingType);
        boolean immutable = this.resolveImmutable(classElement, entityAnnot);
        entityMeta.setImmutable(immutable);
        entityMeta.setEntityName(classElement.getSimpleName().toString());
        Strategy strategy = this.createStrategy(classElement, entityMeta);
        strategy.doClassElement(classElement, entityMeta);
        strategy.doFieldElements(classElement, entityMeta);
        strategy.validateGeneratedId(classElement, entityMeta);
        strategy.validateOriginalStates(classElement, entityMeta);
        strategy.doConstructor(classElement, entityMeta);
        return entityMeta;
    }

    private Strategy createStrategy(TypeElement classElement, EntityMeta entityMeta) {
        ValueAnnot valueAnnot = this.ctx.getAnnotations().newValueAnnot(classElement);
        if (valueAnnot != null) {
            return new ValueStrategy(this.ctx, valueAnnot);
        }
        AllArgsConstructorAnnot allArgsConstructorAnnot = this.ctx.getAnnotations().newAllArgsConstructorAnnot(classElement);
        if (allArgsConstructorAnnot != null) {
            return new AllArgsConstructorStrategy(this.ctx, allArgsConstructorAnnot);
        }
        return new DefaultStrategy(this.ctx);
    }

    private TypeMirror resolveEntityListener(TypeElement classElement) {
        TypeMirror result = this.ctx.getMoreTypes().getTypeMirror(NullEntityListener.class);
        for (AnnotationValue value : this.getEntityElementValueList(classElement, "listener")) {
            if (value == null) continue;
            TypeMirror listenerType = AnnotationValueUtil.toType(value);
            if (listenerType == null) {
                throw new AptIllegalStateException("listener");
            }
            result = listenerType;
        }
        return result;
    }

    private NamingType resolveNamingType(TypeElement classElement) {
        NamingType result = null;
        for (AnnotationValue value : this.getEntityElementValueList(classElement, "naming")) {
            if (value == null) continue;
            VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(value);
            if (enumConstant == null) {
                throw new AptIllegalStateException("naming");
            }
            result = NamingType.valueOf((String)enumConstant.getSimpleName().toString());
        }
        return result;
    }

    private boolean resolveImmutable(TypeElement classElement, EntityAnnot entityAnnot) {
        if (classElement.getKind() == ElementKind.RECORD) {
            return true;
        }
        boolean result = false;
        ArrayList<Boolean> resolvedList = new ArrayList<Boolean>();
        for (AnnotationValue value : this.getEntityElementValueList(classElement, "immutable")) {
            if (value == null) continue;
            Boolean immutable = AnnotationValueUtil.toBoolean(value);
            if (immutable == null) {
                throw new AptIllegalStateException("immutable");
            }
            result = immutable;
            resolvedList.add(immutable);
        }
        if (resolvedList.contains(Boolean.TRUE) && resolvedList.contains(Boolean.FALSE)) {
            throw new AptException((MessageResource)Message.DOMA4226, classElement, entityAnnot.getAnnotationMirror(), entityAnnot.getImmutable(), new Object[0]);
        }
        return result;
    }

    private List<AnnotationValue> getEntityElementValueList(TypeElement classElement, String entityElementName) {
        LinkedList<AnnotationValue> list = new LinkedList<AnnotationValue>();
        TypeElement t = classElement;
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            AnnotationMirror annMirror = this.ctx.getMoreElements().getAnnotationMirror((Element)t, Entity.class);
            if (annMirror != null) {
                AnnotationValue value = null;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annMirror.getElementValues().entrySet()) {
                    ExecutableElement element = entry.getKey();
                    if (!entityElementName.equals(element.getSimpleName().toString())) continue;
                    value = entry.getValue();
                    break;
                }
                list.add(value);
            }
            t = this.ctx.getMoreTypes().toTypeElement(t.getSuperclass());
        }
        Collections.reverse(list);
        return list;
    }

    static interface Strategy {
        public void doClassElement(TypeElement var1, EntityMeta var2);

        public void doFieldElements(TypeElement var1, EntityMeta var2);

        public void validateGeneratedId(TypeElement var1, EntityMeta var2);

        public void validateOriginalStates(TypeElement var1, EntityMeta var2);

        public void doConstructor(TypeElement var1, EntityMeta var2);
    }

    protected static class ValueStrategy
    extends DefaultStrategy {
        final ValueAnnot valueAnnot;

        ValueStrategy(RoundContext ctx, ValueAnnot valueAnnot) {
            super(ctx);
            AssertionUtil.assertNotNull((Object)valueAnnot);
            this.valueAnnot = valueAnnot;
        }

        @Override
        protected void validateClass(TypeElement classElement, EntityMeta entityMeta) {
            if (!entityMeta.isImmutable()) {
                EntityAnnot entityAnnot = entityMeta.getEntityAnnot();
                throw new AptException((MessageResource)Message.DOMA4418, classElement, entityAnnot.getAnnotationMirror(), entityAnnot.getImmutable(), new Object[0]);
            }
            super.validateClass(classElement, entityMeta);
        }

        @Override
        public void doConstructor(TypeElement classElement, EntityMeta entityMeta) {
            if (!this.valueAnnot.getStaticConstructorValue().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4419, classElement, this.valueAnnot.getAnnotationMirror(), this.valueAnnot.getStaticConstructor(), new Object[0]);
            }
        }

        @Override
        protected void validateField(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
        }
    }

    protected static class AllArgsConstructorStrategy
    extends DefaultStrategy {
        final AllArgsConstructorAnnot allArgsConstructorAnnot;

        AllArgsConstructorStrategy(RoundContext ctx, AllArgsConstructorAnnot allArgsConstructorAnnot) {
            super(ctx);
            AssertionUtil.assertNotNull((Object)allArgsConstructorAnnot);
            this.allArgsConstructorAnnot = allArgsConstructorAnnot;
        }

        @Override
        protected void validateClass(TypeElement classElement, EntityMeta entityMeta) {
            if (!entityMeta.isImmutable()) {
                throw new AptException((MessageResource)Message.DOMA4420, (Element)classElement, this.allArgsConstructorAnnot.getAnnotationMirror(), new Object[0]);
            }
            super.validateClass(classElement, entityMeta);
        }

        @Override
        public void doConstructor(TypeElement classElement, EntityMeta entityMeta) {
            if (!this.allArgsConstructorAnnot.getStaticNameValue().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4421, classElement, this.allArgsConstructorAnnot.getAnnotationMirror(), this.allArgsConstructorAnnot.getStaticName(), new Object[0]);
            }
            if (this.allArgsConstructorAnnot.isAccessPrivate()) {
                throw new AptException((MessageResource)Message.DOMA4422, classElement, this.allArgsConstructorAnnot.getAnnotationMirror(), this.allArgsConstructorAnnot.getAccess(), new Object[0]);
            }
            if (this.allArgsConstructorAnnot.isAccessNone()) {
                throw new AptException((MessageResource)Message.DOMA4426, classElement, this.allArgsConstructorAnnot.getAnnotationMirror(), this.allArgsConstructorAnnot.getAccess(), new Object[0]);
            }
        }

        @Override
        protected void validateField(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
        }
    }

    protected static class DefaultStrategy
    implements Strategy {
        final RoundContext ctx;

        DefaultStrategy(RoundContext ctx) {
            AssertionUtil.assertNotNull((Object)ctx);
            this.ctx = ctx;
        }

        @Override
        public void doClassElement(TypeElement classElement, EntityMeta entityMeta) {
            this.validateClass(classElement, entityMeta);
            this.validateEntityListener(classElement, entityMeta);
            this.validateMetamodel(classElement, entityMeta);
            this.doScopes(classElement, entityMeta);
            this.doTable(classElement, entityMeta);
        }

        void validateClass(TypeElement classElement, EntityMeta entityMeta) {
            EntityAnnot entityAnnot = entityMeta.getEntityAnnot();
            ElementKind kind = classElement.getKind();
            if (kind != ElementKind.CLASS && kind != ElementKind.RECORD) {
                throw new AptException((MessageResource)Message.DOMA4015, (Element)classElement, entityAnnot.getAnnotationMirror(), new Object[0]);
            }
            if (!classElement.getTypeParameters().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4051, classElement, new Object[0]);
            }
            this.validateEnclosingElement(classElement);
        }

        void validateEnclosingElement(Element element) {
            TypeElement typeElement = this.ctx.getMoreElements().toTypeElement(element);
            if (typeElement == null) {
                return;
            }
            String simpleName = typeElement.getSimpleName().toString();
            if (simpleName.contains("$") || simpleName.contains("__")) {
                throw new AptException((MessageResource)Message.DOMA4317, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            NestingKind nestingKind = typeElement.getNestingKind();
            if (nestingKind == NestingKind.TOP_LEVEL) {
                return;
            }
            if (nestingKind == NestingKind.MEMBER) {
                Set<Modifier> modifiers = typeElement.getModifiers();
                if (!modifiers.containsAll(Arrays.asList(Modifier.STATIC, Modifier.PUBLIC))) {
                    throw new AptException((MessageResource)Message.DOMA4315, typeElement, new Object[]{typeElement.getQualifiedName()});
                }
            } else {
                throw new AptException((MessageResource)Message.DOMA4316, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            this.validateEnclosingElement(typeElement.getEnclosingElement());
        }

        void validateEntityListener(TypeElement classElement, EntityMeta entityMeta) {
            EntityAnnot entityAnnot = entityMeta.getEntityAnnot();
            TypeMirror listenerType = entityAnnot.getListenerValue();
            TypeElement listenerElement = this.ctx.getMoreTypes().toTypeElement(listenerType);
            if (listenerElement == null) {
                throw new AptIllegalStateException("failed to convert to TypeElement");
            }
            if (listenerElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new AptException((MessageResource)Message.DOMA4166, classElement, entityAnnot.getAnnotationMirror(), entityAnnot.getListener(), new Object[]{listenerElement.getQualifiedName()});
            }
            ExecutableElement constructor = this.ctx.getMoreElements().getNoArgConstructor(listenerElement);
            if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new AptException((MessageResource)Message.DOMA4167, classElement, entityAnnot.getAnnotationMirror(), entityAnnot.getListener(), new Object[]{listenerElement.getQualifiedName()});
            }
            if (listenerElement.getTypeParameters().size() > 0) {
                this.validateGenericEntityListener(classElement, entityMeta, listenerElement);
            } else {
                this.validateNonGenericEntityListener(classElement, entityMeta, listenerType);
            }
            TypeElement inheritedListenerElement = entityMeta.getEntityListenerElement();
            if (!this.ctx.getMoreTypes().isSameTypeWithErasure(listenerType, inheritedListenerElement.asType())) {
                this.validateInheritedEntityListener(classElement, entityMeta, inheritedListenerElement);
            }
        }

        void validateGenericEntityListener(TypeElement classElement, EntityMeta entityMeta, TypeElement listenerElement) {
            EntityAnnot entityAnnot = entityMeta.getEntityAnnot();
            List<? extends TypeParameterElement> typeParams = listenerElement.getTypeParameters();
            if (typeParams.size() == 0) {
                throw new AptIllegalStateException("typeParams size should be more than 0");
            }
            if (typeParams.size() > 1) {
                throw new AptException((MessageResource)Message.DOMA4227, classElement, entityAnnot.getAnnotationMirror(), entityAnnot.getListener(), new Object[0]);
            }
            TypeParameterElement typeParam = typeParams.get(0);
            for (TypeMirror typeMirror : typeParam.getBounds()) {
                if (this.ctx.getMoreTypes().isAssignableWithErasure(classElement.asType(), typeMirror)) continue;
                throw new AptException((MessageResource)Message.DOMA4229, classElement, entityAnnot.getAnnotationMirror(), entityAnnot.getListener(), new Object[]{typeParam.getSimpleName(), typeMirror, classElement.getQualifiedName()});
            }
            if (this.findListenerTypeParam(listenerElement, 0) == null) {
                throw new AptException((MessageResource)Message.DOMA4228, classElement, entityAnnot.getAnnotationMirror(), entityAnnot.getListener(), new Object[]{typeParam.getSimpleName()});
            }
        }

        TypeParameterElement findListenerTypeParam(TypeElement listenerElement, int typeParamIndex) {
            TypeParameterElement typeParam = listenerElement.getTypeParameters().get(typeParamIndex);
            for (TypeMirror typeMirror : listenerElement.getInterfaces()) {
                DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(typeMirror);
                if (declaredType == null) continue;
                int i = -1;
                for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                    ++i;
                    TypeVariable typeVariable = this.ctx.getMoreTypes().toTypeVariable(typeMirror2);
                    if (typeVariable == null || !typeParam.getSimpleName().equals(typeVariable.asElement().getSimpleName())) continue;
                    if (this.ctx.getMoreTypes().isSameTypeWithErasure((TypeMirror)declaredType, EntityListener.class)) {
                        return typeParam;
                    }
                    TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(declaredType);
                    if (typeElement == null) {
                        throw new AptIllegalStateException(declaredType.toString());
                    }
                    TypeParameterElement candidate = this.findListenerTypeParam(typeElement, i);
                    if (candidate == null) continue;
                    return candidate;
                }
            }
            TypeMirror superclass = listenerElement.getSuperclass();
            DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(superclass);
            if (declaredType == null) {
                return null;
            }
            int i = -1;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                ++i;
                TypeVariable typeVariable = this.ctx.getMoreTypes().toTypeVariable(typeMirror);
                if (typeVariable == null || !typeParam.getSimpleName().equals(typeVariable.asElement().getSimpleName())) continue;
                if (this.ctx.getMoreTypes().isSameTypeWithErasure((TypeMirror)declaredType, EntityListener.class)) {
                    return typeParam;
                }
                TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(declaredType);
                if (typeElement == null) {
                    throw new AptIllegalStateException(declaredType.toString());
                }
                TypeParameterElement candidate = this.findListenerTypeParam(typeElement, i);
                if (candidate == null) continue;
                return candidate;
            }
            return null;
        }

        void validateNonGenericEntityListener(TypeElement classElement, EntityMeta entityMeta, TypeMirror listenerType) {
            EntityAnnot entityAnnot = entityMeta.getEntityAnnot();
            TypeMirror argumentType = this.getListenerArgumentType(listenerType);
            if (argumentType == null) {
                throw new AptException((MessageResource)Message.DOMA4202, classElement, entityAnnot.getAnnotationMirror(), entityAnnot.getListener(), new Object[0]);
            }
            if (!this.ctx.getMoreTypes().isAssignableWithErasure(classElement.asType(), argumentType)) {
                throw new AptException((MessageResource)Message.DOMA4038, classElement, entityAnnot.getAnnotationMirror(), entityAnnot.getListener(), new Object[]{listenerType, argumentType, classElement.getQualifiedName()});
            }
        }

        void validateInheritedEntityListener(TypeElement classElement, EntityMeta entityMeta, TypeElement inheritedListenerElement) {
            EntityAnnot entityAnnot = entityMeta.getEntityAnnot();
            List<? extends TypeParameterElement> typeParams = inheritedListenerElement.getTypeParameters();
            if (typeParams.size() == 0) {
                throw new AptException((MessageResource)Message.DOMA4230, (Element)classElement, entityAnnot.getAnnotationMirror(), new Object[]{inheritedListenerElement.getQualifiedName(), classElement.getQualifiedName()});
            }
            TypeParameterElement typeParam = typeParams.get(0);
            for (TypeMirror typeMirror : typeParam.getBounds()) {
                if (this.ctx.getMoreTypes().isAssignableWithErasure(classElement.asType(), typeMirror)) continue;
                throw new AptException((MessageResource)Message.DOMA4231, (Element)classElement, entityAnnot.getAnnotationMirror(), new Object[]{inheritedListenerElement.getQualifiedName(), typeParam.getSimpleName(), typeMirror, classElement.getQualifiedName()});
            }
        }

        TypeMirror getListenerArgumentType(TypeMirror typeMirror) {
            for (TypeMirror typeMirror2 : this.ctx.getMoreTypes().directSupertypes(typeMirror)) {
                if (!this.ctx.getMoreTypes().isAssignableWithErasure(typeMirror2, EntityListener.class)) continue;
                if (this.ctx.getMoreTypes().isSameTypeWithErasure(typeMirror2, EntityListener.class)) {
                    DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(typeMirror2);
                    if (declaredType == null) {
                        throw new AptIllegalStateException("declaredType");
                    }
                    List<? extends TypeMirror> args = declaredType.getTypeArguments();
                    if (args.size() != 1) {
                        return null;
                    }
                    return args.get(0);
                }
                TypeMirror argumentType = this.getListenerArgumentType(typeMirror2);
                if (argumentType == null) continue;
                return argumentType;
            }
            return null;
        }

        void validateMetamodel(TypeElement classElement, EntityMeta entityMeta) {
            EntityAnnot entityAnnot = entityMeta.getEntityAnnot();
            MetamodelAnnot metamodelAnnot = entityAnnot.getMetamodelValue();
            if (metamodelAnnot != null) {
                String prefix = metamodelAnnot.getPrefixValue();
                String suffix = metamodelAnnot.getSuffixValue();
                if ("_".equals(prefix) && suffix.isEmpty()) {
                    throw new AptException((MessageResource)Message.DOMA4455, (Element)classElement, metamodelAnnot.getAnnotationMirror(), new Object[]{"_"});
                }
            }
        }

        void doScopes(TypeElement classElement, EntityMeta entityMeta) {
            EntityAnnot entityAnnot = entityMeta.getEntityAnnot();
            MetamodelAnnot metamodelAnnot = entityAnnot.getMetamodelValue();
            if (metamodelAnnot == null) {
                return;
            }
            for (TypeMirror typeMirror : metamodelAnnot.getScopesValue()) {
                TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(typeMirror);
                if (typeElement == null) continue;
                ScopeClassMetaFactory scopeClassMetaFactory = new ScopeClassMetaFactory(this.ctx, typeElement);
                ScopeClassMeta scopeClassMeta = scopeClassMetaFactory.createScopeClassMeta();
                entityMeta.addScopeClassMeta(scopeClassMeta);
            }
        }

        void doTable(TypeElement classElement, EntityMeta entityMeta) {
            TableAnnot tableAnnot = this.ctx.getAnnotations().newTableAnnot(classElement);
            if (tableAnnot == null) {
                return;
            }
            entityMeta.setTableAnnot(tableAnnot);
        }

        @Override
        public void doFieldElements(TypeElement classElement, EntityMeta entityMeta) {
            for (VariableElement fieldElement : this.getFieldElements(classElement)) {
                try {
                    if (fieldElement.getAnnotation(Transient.class) != null || fieldElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    if (fieldElement.getAnnotation(OriginalStates.class) != null) {
                        this.doOriginalStatesField(classElement, fieldElement, entityMeta);
                        continue;
                    }
                    if (fieldElement.getAnnotation(Association.class) != null) {
                        this.doAssociationPropertyMeta(classElement, fieldElement, entityMeta);
                        continue;
                    }
                    this.doEntityFieldMeta(classElement, fieldElement, entityMeta);
                }
                catch (AptException e) {
                    this.ctx.getReporter().report(e);
                    entityMeta.setError(true);
                }
            }
        }

        List<VariableElement> getFieldElements(TypeElement classElement) {
            LinkedList<VariableElement> results = new LinkedList<VariableElement>();
            TypeElement t = classElement;
            while (t != null && t.asType().getKind() != TypeKind.NONE) {
                if (t.getAnnotation(Entity.class) != null) {
                    LinkedList<VariableElement> fields = new LinkedList<VariableElement>(ElementFilter.fieldsIn(t.getEnclosedElements()));
                    Collections.reverse(fields);
                    results.addAll(fields);
                }
                t = this.ctx.getMoreTypes().toTypeElement(t.getSuperclass());
            }
            Collections.reverse(results);
            LinkedList hiderFields = new LinkedList(results);
            Iterator it = results.iterator();
            while (it.hasNext()) {
                VariableElement hidden = (VariableElement)it.next();
                for (VariableElement hider : hiderFields) {
                    if (!this.ctx.getMoreElements().hides(hider, hidden)) continue;
                    it.remove();
                }
            }
            return results;
        }

        void doOriginalStatesField(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
            if (entityMeta.hasOriginalStatesMeta()) {
                throw new AptException((MessageResource)Message.DOMA4125, fieldElement, new Object[0]);
            }
            if (classElement.equals(fieldElement.getEnclosingElement()) && !this.ctx.getMoreTypes().isSameTypeWithErasure(fieldElement.asType(), classElement.asType())) {
                throw new AptException((MessageResource)Message.DOMA4135, fieldElement, new Object[0]);
            }
            TypeElement enclosingElement = this.ctx.getMoreElements().toTypeElement(fieldElement.getEnclosingElement());
            if (enclosingElement == null) {
                throw new AptIllegalStateException(fieldElement.toString());
            }
            if (entityMeta.isImmutable() && classElement.equals(enclosingElement)) {
                throw new AptException((MessageResource)Message.DOMA4224, fieldElement, new Object[0]);
            }
            OriginalStatesMeta originalStatesMeta = new OriginalStatesMeta(classElement, fieldElement, enclosingElement);
            entityMeta.setOriginalStatesMeta(originalStatesMeta);
        }

        void doAssociationPropertyMeta(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
            this.validateFieldAnnotation(fieldElement, entityMeta);
            CtType ctType = this.ctx.getCtTypes().newCtType(fieldElement.asType());
            EntityCtType entityCtType = EntityCtType.resolveEntityCtType(ctType);
            if (entityCtType == null) {
                throw new AptException((MessageResource)Message.DOMA4485, fieldElement, new Object[]{fieldElement.getSimpleName(), classElement, fieldElement.asType()});
            }
            AssociationPropertyMeta associationPropertyMeta = new AssociationPropertyMeta(fieldElement.getSimpleName().toString());
            entityMeta.addAssociationPropertyMeta(associationPropertyMeta);
        }

        void doEntityFieldMeta(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
            this.validateFieldAnnotation(fieldElement, entityMeta);
            EntityFieldMetaFactory fieldMetaFactory = new EntityFieldMetaFactory(this.ctx, entityMeta, fieldElement);
            EntityFieldMeta fieldMeta = fieldMetaFactory.createEntityFieldMeta();
            entityMeta.addFieldMeta(fieldMeta);
            this.validateField(classElement, fieldElement, entityMeta);
        }

        void validateFieldAnnotation(VariableElement fieldElement, EntityMeta entityMeta) {
            TypeElement foundAnnotationTypeElement = null;
            for (AnnotationMirror annotationMirror : fieldElement.getAnnotationMirrors()) {
                DeclaredType declaredType = annotationMirror.getAnnotationType();
                TypeElement typeElement = this.ctx.getMoreTypes().toTypeElement(declaredType);
                if (typeElement.getAnnotation(EntityField.class) == null) continue;
                if (foundAnnotationTypeElement != null) {
                    throw new AptException((MessageResource)Message.DOMA4086, fieldElement, new Object[]{foundAnnotationTypeElement.getQualifiedName(), typeElement.getQualifiedName()});
                }
                foundAnnotationTypeElement = typeElement;
            }
        }

        void validateField(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
            if (entityMeta.isImmutable() && !fieldElement.getModifiers().contains((Object)Modifier.FINAL)) {
                throw new AptException((MessageResource)Message.DOMA4225, fieldElement, new Object[0]);
            }
        }

        @Override
        public void validateGeneratedId(TypeElement classElement, EntityMeta entityMeta) {
            if (entityMeta.hasGeneratedIdPropertyMeta() && entityMeta.getIdPropertyMetas().size() > 1) {
                throw new AptException((MessageResource)Message.DOMA4036, classElement, new Object[0]);
            }
        }

        @Override
        public void validateOriginalStates(TypeElement classElement, EntityMeta entityMeta) {
            if (entityMeta.hasOriginalStatesMeta() && entityMeta.hasEmbeddedFields()) {
                throw new AptException((MessageResource)Message.DOMA4305, classElement, new Object[0]);
            }
        }

        @Override
        public void doConstructor(TypeElement classElement, EntityMeta entityMeta) {
            if (classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return;
            }
            if (entityMeta.isImmutable()) {
                EntityConstructorMeta constructorMeta = this.getConstructorMeta(classElement, entityMeta);
                if (constructorMeta == null) {
                    throw new AptException((MessageResource)Message.DOMA4281, classElement, new Object[0]);
                }
                if (constructorMeta.getConstructorElement().getModifiers().contains((Object)Modifier.PRIVATE)) {
                    throw new AptException((MessageResource)Message.DOMA4221, classElement, new Object[0]);
                }
                entityMeta.setConstructorMeta(constructorMeta);
            } else {
                ExecutableElement constructor = this.ctx.getMoreElements().getNoArgConstructor(classElement);
                if (constructor == null || constructor.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    throw new AptException((MessageResource)Message.DOMA4124, classElement, new Object[0]);
                }
            }
        }

        EntityConstructorMeta getConstructorMeta(TypeElement classElement, EntityMeta entityMeta) {
            HashMap<String, EntityFieldMeta> entityPropertyMetaMap = new HashMap<String, EntityFieldMeta>();
            for (EntityFieldMeta propertyMeta : entityMeta.getAllFieldMetas()) {
                entityPropertyMetaMap.put(propertyMeta.getName(), propertyMeta);
            }
            block1: for (ExecutableElement constructor : ElementFilter.constructorsIn(classElement.getEnclosedElements())) {
                ArrayList<EntityFieldMeta> entityPropertyMetaList = new ArrayList<EntityFieldMeta>();
                for (VariableElement variableElement : constructor.getParameters()) {
                    String name = variableElement.getSimpleName().toString();
                    ParameterName parameterName = variableElement.getAnnotation(ParameterName.class);
                    if (parameterName != null) {
                        name = parameterName.value();
                    }
                    TypeMirror paramType = variableElement.asType();
                    EntityFieldMeta propertyMeta = (EntityFieldMeta)entityPropertyMetaMap.get(name);
                    if (propertyMeta == null) continue block1;
                    TypeMirror propertyType = propertyMeta.getCtType().getType();
                    if (!this.ctx.getMoreTypes().isSameTypeWithErasure(paramType, propertyType)) continue block1;
                    entityPropertyMetaList.add(propertyMeta);
                }
                if (entityPropertyMetaMap.size() != entityPropertyMetaList.size()) continue;
                return new EntityConstructorMeta(constructor, entityPropertyMetaList);
            }
            return null;
        }
    }
}

