/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.annot.ColumnAnnot;
import org.seasar.doma.internal.apt.annot.EmbeddedAnnot;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.entity.EntityFieldMeta;
import org.seasar.doma.internal.apt.meta.id.IdGeneratorMeta;
import org.seasar.doma.internal.util.AssertionUtil;

public final class EntityPropertyMeta
implements EntityFieldMeta {
    private final CtType ctType;
    private final String fieldPrefix;
    private String name;
    private boolean id;
    private boolean version;
    private boolean tenantId;
    private ColumnAnnot columnAnnot;
    private IdGeneratorMeta idGeneratorMeta;
    private String columnNamePrefix;
    private EmbeddedAnnot embeddedAnnot;

    public EntityPropertyMeta(CtType ctType, String fieldPrefix) {
        AssertionUtil.assertNotNull((Object)ctType, (Object)fieldPrefix);
        this.ctType = ctType;
        this.fieldPrefix = fieldPrefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFieldName() {
        return this.fieldPrefix + this.name;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public boolean isTenantId() {
        return this.tenantId;
    }

    public void setTenantId(boolean tenantId) {
        this.tenantId = tenantId;
    }

    public IdGeneratorMeta getIdGeneratorMeta() {
        return this.idGeneratorMeta;
    }

    public void setIdGeneratorMeta(IdGeneratorMeta idGeneratorMeta) {
        this.idGeneratorMeta = idGeneratorMeta;
    }

    public TypeMirror getType() {
        return this.ctType.getType();
    }

    public TypeMirror getBoxedType() {
        return this.ctType.accept(new SimpleCtTypeVisitor<TypeMirror, Void, RuntimeException>(){

            @Override
            public TypeMirror visitBasicCtType(BasicCtType ctType, Void o) {
                return ctType.getBoxedType();
            }

            @Override
            protected TypeMirror defaultAction(CtType ctType, Void o) {
                return ctType.getType();
            }
        }, null);
    }

    public String getQualifiedName() {
        return this.ctType.getQualifiedName();
    }

    @Override
    public CtType getCtType() {
        return this.ctType;
    }

    public void setColumnAnnot(ColumnAnnot columnAnnot) {
        this.columnAnnot = columnAnnot;
    }

    public String getColumnName() {
        return this.columnAnnot != null ? this.columnAnnot.getNameValue() : "";
    }

    public boolean isColumnInsertable() {
        return this.columnAnnot == null || this.columnAnnot.getInsertableValue();
    }

    public boolean isColumnUpdatable() {
        return this.columnAnnot == null || this.columnAnnot.getUpdatableValue();
    }

    public boolean isColumnQuoteRequired() {
        return this.columnAnnot != null && this.columnAnnot.getQuoteValue();
    }
}

