/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.entity;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Transient;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.EmbeddableAnnot;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMetaFactory;
import org.seasar.doma.internal.apt.meta.entity.EmbeddablePropertyMeta;
import org.seasar.doma.internal.util.AssertionUtil;

public class EntityPropertyNameCollector {
    private final RoundContext ctx;

    public EntityPropertyNameCollector(RoundContext ctx) {
        AssertionUtil.assertNotNull((Object)ctx);
        this.ctx = ctx;
    }

    public Set<String> collect(TypeMirror entityType) {
        HashSet<String> names = new HashSet<String>();
        this.collectNames(entityType, names);
        return names;
    }

    private void collectNames(TypeMirror type, Set<String> names) {
        TypeElement t = this.ctx.getMoreTypes().toTypeElement(type);
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            for (VariableElement field : ElementFilter.fieldsIn(t.getEnclosedElements())) {
                if (!this.isPersistent(field)) continue;
                String name = field.getSimpleName().toString();
                TypeElement filedTypeElement = this.ctx.getMoreTypes().toTypeElement(field.asType());
                if (filedTypeElement == null) {
                    names.add(name);
                    continue;
                }
                EmbeddableAnnot embeddableAnnot = this.ctx.getAnnotations().newEmbeddableAnnot(filedTypeElement);
                if (embeddableAnnot == null) {
                    names.add(name);
                    continue;
                }
                EmbeddableMetaFactory embeddableMetaFactory = new EmbeddableMetaFactory(this.ctx);
                EmbeddableMeta embeddableMeta = embeddableMetaFactory.createTypeElementMeta(filedTypeElement);
                for (EmbeddablePropertyMeta propertyMeta : embeddableMeta.getEmbeddablePropertyMetas()) {
                    names.add(name + "." + propertyMeta.getName());
                }
            }
            t = this.ctx.getMoreTypes().toTypeElement(t.getSuperclass());
        }
    }

    private boolean isPersistent(VariableElement field) {
        return field.getAnnotation(Transient.class) == null && !field.getModifiers().contains((Object)Modifier.STATIC);
    }
}

