/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.util.List;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.BatchModifyAnnot;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AutoBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoBatchModifyQueryMetaFactory
extends AbstractQueryMetaFactory<AutoBatchModifyQueryMeta> {
    private final BatchModifyAnnot batchModifyAnnot;
    private final QueryKind queryKind;

    public AutoBatchModifyQueryMetaFactory(RoundContext ctx, TypeElement daoElement, ExecutableElement methodElement, BatchModifyAnnot batchModifyAnnot, QueryKind queryKind) {
        super(ctx, daoElement, methodElement);
        this.batchModifyAnnot = Objects.requireNonNull(batchModifyAnnot);
        this.queryKind = Objects.requireNonNull(queryKind);
    }

    @Override
    public QueryMeta createQueryMeta(AnnotationMirror annotation) {
        AutoBatchModifyQueryMeta queryMeta = this.createAutoBatchModifyQueryMeta(annotation);
        this.doTypeParameters(queryMeta);
        this.doParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doThrowTypes(queryMeta);
        return queryMeta;
    }

    private AutoBatchModifyQueryMeta createAutoBatchModifyQueryMeta(AnnotationMirror annotation) {
        AutoBatchModifyQueryMeta queryMeta = new AutoBatchModifyQueryMeta(this.daoElement, this.methodElement);
        queryMeta.setBatchModifyAnnot(this.batchModifyAnnot);
        queryMeta.setQueryKind(this.queryKind);
        return queryMeta;
    }

    @Override
    protected void doReturnType(AutoBatchModifyQueryMeta queryMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        EntityCtType entityCtType = queryMeta.getEntityCtType();
        if (entityCtType != null && entityCtType.isImmutable()) {
            if (!returnMeta.isBatchResult(entityCtType)) {
                throw new AptException((MessageResource)Message.DOMA4223, this.methodElement, new Object[0]);
            }
        } else if (!returnMeta.isPrimitiveIntArray()) {
            throw new AptException((MessageResource)Message.DOMA4040, this.methodElement, new Object[0]);
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(AutoBatchModifyQueryMeta queryMeta) {
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        int size = parameters.size();
        if (size != 1) {
            throw new AptException((MessageResource)Message.DOMA4002, this.methodElement, new Object[0]);
        }
        QueryParameterMeta parameterMeta = this.createParameterMeta(parameters.get(0));
        IterableCtType iterableCtType = parameterMeta.getCtType().accept(new SimpleCtTypeVisitor<IterableCtType, Void, RuntimeException>(){

            @Override
            protected IterableCtType defaultAction(CtType ctType, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4042, AutoBatchModifyQueryMetaFactory.this.methodElement, new Object[0]);
            }

            @Override
            public IterableCtType visitIterableCtType(IterableCtType ctType, Void p) throws RuntimeException {
                return ctType;
            }
        }, null);
        EntityCtType entityCtType = iterableCtType.getElementCtType().accept(new SimpleCtTypeVisitor<EntityCtType, Void, RuntimeException>(){

            @Override
            protected EntityCtType defaultAction(CtType ctType, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4043, AutoBatchModifyQueryMetaFactory.this.methodElement, new Object[0]);
            }

            @Override
            public EntityCtType visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
                return ctType;
            }
        }, null);
        queryMeta.setEntityCtType(entityCtType);
        queryMeta.setEntitiesParameterName(parameterMeta.getName());
        queryMeta.addParameterMeta(parameterMeta);
        if (parameterMeta.isBindable()) {
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
        BatchModifyAnnot batchModifyAnnot = queryMeta.getBatchModifyAnnot();
        this.validateEntityPropertyNames(entityCtType.getType(), batchModifyAnnot.getAnnotationMirror(), batchModifyAnnot.getInclude(), batchModifyAnnot.getExclude(), batchModifyAnnot.getDuplicateKeys());
    }
}

