/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.annot.ModifyAnnot;
import org.seasar.doma.internal.apt.annot.ReturningAnnot;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.meta.query.AbstractQueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMetaVisitor;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.command.DeleteReturningCommand;
import org.seasar.doma.jdbc.command.InsertReturningCommand;
import org.seasar.doma.jdbc.command.UpdateReturningCommand;
import org.seasar.doma.jdbc.query.DuplicateKeyType;

public class AutoModifyQueryMeta
extends AbstractQueryMeta {
    private EntityCtType entityCtType;
    private String entityParameterName;
    private ModifyAnnot modifyAnnot;

    public AutoModifyQueryMeta(TypeElement daoElement, ExecutableElement methodElement) {
        super(daoElement, methodElement);
    }

    public EntityCtType getEntityCtType() {
        return this.entityCtType;
    }

    public void setEntityCtType(EntityCtType entityCtType) {
        this.entityCtType = entityCtType;
    }

    public String getEntityParameterName() {
        return this.entityParameterName;
    }

    public void setEntityParameterName(String entityParameterName) {
        this.entityParameterName = entityParameterName;
    }

    public ModifyAnnot getModifyAnnot() {
        return this.modifyAnnot;
    }

    void setModifyAnnot(ModifyAnnot modifyAnnot) {
        this.modifyAnnot = modifyAnnot;
    }

    public ReturningAnnot getReturningAnnot() {
        return this.modifyAnnot.getReturningAnnot();
    }

    public boolean getSqlFile() {
        return this.modifyAnnot.getSqlFileValue();
    }

    public int getQueryTimeout() {
        return this.modifyAnnot.getQueryTimeoutValue();
    }

    public Boolean getIgnoreVersion() {
        return this.modifyAnnot.getIgnoreVersionValue();
    }

    public Boolean getExcludeNull() {
        return this.modifyAnnot.getExcludeNullValue();
    }

    public Boolean getSuppressOptimisticLockException() {
        return this.modifyAnnot.getSuppressOptimisticLockExceptionValue();
    }

    public Boolean getIncludeUnchanged() {
        return this.modifyAnnot.getIncludeUnchangedValue();
    }

    public List<String> getInclude() {
        return this.modifyAnnot.getIncludeValue();
    }

    public List<String> getExclude() {
        return this.modifyAnnot.getExcludeValue();
    }

    public List<String> getDuplicateKeys() {
        return this.modifyAnnot.getDuplicateKeysValue();
    }

    public SqlLogType getSqlLogType() {
        return this.modifyAnnot.getSqlLogValue();
    }

    public DuplicateKeyType getDuplicateKeyType() {
        return this.modifyAnnot.getDuplicateKeyTypeValue();
    }

    @Override
    public Class<?> getCommandClass() {
        ReturningAnnot returningAnnot = this.modifyAnnot.getReturningAnnot();
        if (returningAnnot == null) {
            return super.getCommandClass();
        }
        return switch (this.queryKind) {
            case QueryKind.AUTO_DELETE -> DeleteReturningCommand.class;
            case QueryKind.AUTO_INSERT -> InsertReturningCommand.class;
            case QueryKind.AUTO_UPDATE -> UpdateReturningCommand.class;
            default -> throw new IllegalStateException(this.queryKind.name());
        };
    }

    @Override
    public <R> R accept(QueryMetaVisitor<R> visitor) {
        return visitor.visitAutoModifyQueryMeta(this);
    }
}

