/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.ProcedureAnnot;
import org.seasar.doma.internal.apt.meta.query.AutoModuleQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.AutoProcedureQueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoProcedureQueryMetaFactory
extends AutoModuleQueryMetaFactory<AutoProcedureQueryMeta> {
    public AutoProcedureQueryMetaFactory(RoundContext ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    @Override
    public QueryMeta createQueryMeta(AnnotationMirror annotation) {
        ProcedureAnnot procedureAnnot = this.ctx.getAnnotations().newProcedureAnnot(annotation, this.methodElement.getSimpleName().toString());
        AutoProcedureQueryMeta queryMeta = new AutoProcedureQueryMeta(this.daoElement, this.methodElement);
        queryMeta.setQueryKind(QueryKind.AUTO_PROCEDURE);
        queryMeta.setProcedureAnnot(procedureAnnot);
        this.doTypeParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doParameters(queryMeta);
        this.doThrowTypes(queryMeta);
        return queryMeta;
    }

    @Override
    protected void doReturnType(AutoProcedureQueryMeta queryMeta) {
        QueryReturnMeta resultMeta = this.createReturnMeta(queryMeta);
        if (!resultMeta.isPrimitiveVoid()) {
            throw new AptException((MessageResource)Message.DOMA4064, this.methodElement, new Object[0]);
        }
        queryMeta.setReturnMeta(resultMeta);
    }
}

