/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.BiFunctionCtType;
import org.seasar.doma.internal.apt.cttype.CollectorCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.FunctionCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.ReferenceCtType;
import org.seasar.doma.internal.apt.cttype.SelectOptionsCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

class QueryParameterMetaFactory {
    private final RoundContext ctx;
    private final VariableElement parameterElement;

    public QueryParameterMetaFactory(RoundContext ctx, VariableElement parameterElement) {
        AssertionUtil.assertNotNull((Object)ctx, (Object)parameterElement);
        this.ctx = ctx;
        this.parameterElement = parameterElement;
    }

    public QueryParameterMeta createQueryParameterMeta() {
        String name = this.ctx.getMoreElements().getParameterName(this.parameterElement);
        if (name.startsWith("__")) {
            throw new AptException((MessageResource)Message.DOMA4025, this.parameterElement, new Object[]{"__"});
        }
        TypeMirror type = this.parameterElement.asType();
        CtType ctType = this.ctx.getCtTypes().newCtType(type, new CtTypeValidator());
        return new QueryParameterMeta(name, ctType, this.parameterElement);
    }

    private class CtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, AptException> {
        private CtTypeValidator() {
        }

        @Override
        protected Void defaultAction(CtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitSelectOptionsCtType(SelectOptionsCtType ctType, Void aVoid) throws AptException {
            return null;
        }

        @Override
        public Void visitIterableCtType(IterableCtType iterableCtType, Void aVoid) throws AptException {
            if (iterableCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4159, QueryParameterMetaFactory.this.parameterElement, new Object[0]);
            }
            if (iterableCtType.hasWildcard()) {
                throw new AptException((MessageResource)Message.DOMA4160, QueryParameterMetaFactory.this.parameterElement, new Object[0]);
            }
            iterableCtType.getElementCtType().accept(new IterableElementCtTypeValidator(), null);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType optionalCtType, Void aVoid) throws AptException {
            if (optionalCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4236, QueryParameterMetaFactory.this.parameterElement, new Object[]{optionalCtType.getQualifiedName()});
            }
            if (optionalCtType.hasWildcard()) {
                throw new AptException((MessageResource)Message.DOMA4237, QueryParameterMetaFactory.this.parameterElement, new Object[]{optionalCtType.getQualifiedName()});
            }
            optionalCtType.getElementCtType().accept(new OptionalElementCtTypeValidator(), null);
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType domainCtType, Void aVoid) throws AptException {
            if (domainCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4208, QueryParameterMetaFactory.this.parameterElement, new Object[]{domainCtType.getQualifiedName()});
            }
            if (domainCtType.hasWildcard() || domainCtType.hasTypevar()) {
                throw new AptException((MessageResource)Message.DOMA4209, QueryParameterMetaFactory.this.parameterElement, new Object[]{domainCtType.getQualifiedName()});
            }
            return null;
        }

        @Override
        public Void visitFunctionCtType(FunctionCtType functionCtType, Void aVoid) throws AptException {
            if (functionCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4240, QueryParameterMetaFactory.this.parameterElement, new Object[]{functionCtType.getQualifiedName()});
            }
            if (functionCtType.hasWildcard()) {
                throw new AptException((MessageResource)Message.DOMA4241, QueryParameterMetaFactory.this.parameterElement, new Object[]{functionCtType.getQualifiedName()});
            }
            functionCtType.getTargetCtType().accept(new FunctionTargetCtTypeValidator(), null);
            return null;
        }

        @Override
        public Void visitCollectorCtType(CollectorCtType collectorCtType, Void aVoid) throws AptException {
            if (collectorCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4258, QueryParameterMetaFactory.this.parameterElement, new Object[]{collectorCtType.getQualifiedName()});
            }
            if (collectorCtType.hasWildcard()) {
                throw new AptException((MessageResource)Message.DOMA4259, QueryParameterMetaFactory.this.parameterElement, new Object[]{collectorCtType.getQualifiedName()});
            }
            collectorCtType.getTargetCtType().accept(new CollectorTargetCtTypeValidator(), null);
            return null;
        }

        @Override
        public Void visitReferenceCtType(ReferenceCtType referenceCtType, Void aVoid) throws AptException {
            if (referenceCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4108, QueryParameterMetaFactory.this.parameterElement, new Object[0]);
            }
            if (referenceCtType.hasWildcard()) {
                throw new AptException((MessageResource)Message.DOMA4112, QueryParameterMetaFactory.this.parameterElement, new Object[]{referenceCtType.getQualifiedName()});
            }
            referenceCtType.getReferentCtType().accept(new ReferenceReferentCtTypeValidator(), null);
            return null;
        }

        @Override
        public Void visitBiFunctionCtType(BiFunctionCtType biFunctionCtType, Void aVoid) throws AptException {
            if (biFunctionCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4438, QueryParameterMetaFactory.this.parameterElement, new Object[]{biFunctionCtType.getQualifiedName()});
            }
            if (biFunctionCtType.hasWildcard()) {
                throw new AptException((MessageResource)Message.DOMA4439, QueryParameterMetaFactory.this.parameterElement, new Object[]{biFunctionCtType.getQualifiedName()});
            }
            return null;
        }
    }

    class ReferenceReferentCtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        ReferenceReferentCtTypeValidator() {
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            if (ctType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4218, QueryParameterMetaFactory.this.parameterElement, new Object[]{ctType.getQualifiedName()});
            }
            if (ctType.hasWildcard() || ctType.hasTypevar()) {
                throw new AptException((MessageResource)Message.DOMA4219, QueryParameterMetaFactory.this.parameterElement, new Object[]{ctType.getQualifiedName()});
            }
            return null;
        }
    }

    class CollectorTargetCtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        CollectorTargetCtTypeValidator() {
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            if (ctType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4260, QueryParameterMetaFactory.this.parameterElement, new Object[]{ctType.getQualifiedName()});
            }
            if (ctType.hasWildcard() || ctType.hasTypevar()) {
                throw new AptException((MessageResource)Message.DOMA4261, QueryParameterMetaFactory.this.parameterElement, new Object[]{ctType.getQualifiedName()});
            }
            return null;
        }
    }

    class FunctionTargetCtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        FunctionTargetCtTypeValidator() {
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Void p) throws RuntimeException {
            ctType.getElementCtType().accept(new StreamElementCtTypeVisitor(), p);
            return null;
        }

        class StreamElementCtTypeVisitor
        extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
            StreamElementCtTypeVisitor() {
            }

            @Override
            public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                if (ctType.isRaw()) {
                    throw new AptException((MessageResource)Message.DOMA4242, QueryParameterMetaFactory.this.parameterElement, new Object[]{ctType.getQualifiedName()});
                }
                if (ctType.hasWildcard() || ctType.hasTypevar()) {
                    throw new AptException((MessageResource)Message.DOMA4243, QueryParameterMetaFactory.this.parameterElement, new Object[]{ctType.getQualifiedName()});
                }
                return null;
            }
        }
    }

    class OptionalElementCtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        OptionalElementCtTypeValidator() {
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            if (ctType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4238, QueryParameterMetaFactory.this.parameterElement, new Object[]{ctType.getQualifiedName()});
            }
            if (ctType.hasWildcard() || ctType.hasTypevar()) {
                throw new AptException((MessageResource)Message.DOMA4239, QueryParameterMetaFactory.this.parameterElement, new Object[]{ctType.getQualifiedName()});
            }
            return null;
        }
    }

    private class IterableElementCtTypeValidator
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        private IterableElementCtTypeValidator() {
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            if (ctType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4212, QueryParameterMetaFactory.this.parameterElement, new Object[]{ctType.getQualifiedName()});
            }
            if (ctType.hasWildcard() || ctType.hasTypevar()) {
                throw new AptException((MessageResource)Message.DOMA4213, QueryParameterMetaFactory.this.parameterElement, new Object[]{ctType.getQualifiedName()});
            }
            return null;
        }
    }
}

