/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.ModifyAnnot;
import org.seasar.doma.internal.apt.annot.ReturningAnnot;
import org.seasar.doma.internal.apt.annot.SqlAnnot;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.query.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileModifyQueryMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlFileModifyQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlFileModifyQueryMeta> {
    private final ModifyAnnot modifyAnnot;
    private final QueryKind queryKind;
    private final SqlAnnot sqlAnnot;

    public SqlFileModifyQueryMetaFactory(RoundContext ctx, TypeElement daoElement, ExecutableElement methodElement, ModifyAnnot modifyAnnot, QueryKind queryKind, SqlAnnot sqlAnnot) {
        super(ctx, daoElement, methodElement);
        this.modifyAnnot = Objects.requireNonNull(modifyAnnot);
        this.queryKind = Objects.requireNonNull(queryKind);
        this.sqlAnnot = sqlAnnot;
    }

    @Override
    public QueryMeta createQueryMeta(AnnotationMirror annotation) {
        SqlFileModifyQueryMeta queryMeta = this.createSqlFileModifyQueryMeta(annotation);
        this.doAnnotation(queryMeta);
        this.doTypeParameters(queryMeta);
        this.doParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doThrowTypes(queryMeta);
        this.doSqlTemplate(queryMeta, false, queryMeta.isPopulatable());
        return queryMeta;
    }

    private SqlFileModifyQueryMeta createSqlFileModifyQueryMeta(AnnotationMirror annotation) {
        SqlFileModifyQueryMeta queryMeta = new SqlFileModifyQueryMeta(this.daoElement, this.methodElement);
        queryMeta.setModifyAnnot(this.modifyAnnot);
        queryMeta.setQueryKind(this.queryKind);
        queryMeta.setSqlAnnot(this.sqlAnnot);
        return queryMeta;
    }

    private void doAnnotation(SqlFileModifyQueryMeta queryMeta) {
        ModifyAnnot modifyAnnot = queryMeta.getModifyAnnot();
        ReturningAnnot returningAnnot = modifyAnnot.getReturningAnnot();
        if (returningAnnot != null) {
            if (modifyAnnot.getSqlFileValue()) {
                throw new AptException((MessageResource)Message.DOMA4491, (Element)this.methodElement, returningAnnot.getAnnotationMirror(), new Object[0]);
            }
            if (queryMeta.getSqlAnnot() != null) {
                throw new AptException((MessageResource)Message.DOMA4492, (Element)this.methodElement, returningAnnot.getAnnotationMirror(), new Object[0]);
            }
        }
    }

    @Override
    protected void doReturnType(SqlFileModifyQueryMeta queryMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        EntityCtType entityCtType = queryMeta.getEntityCtType();
        if (entityCtType != null && entityCtType.isImmutable()) {
            if (!returnMeta.isResult(entityCtType)) {
                throw new AptException((MessageResource)Message.DOMA4222, this.methodElement, new Object[0]);
            }
        } else if (!returnMeta.isPrimitiveInt()) {
            throw new AptException((MessageResource)Message.DOMA4001, this.methodElement, new Object[0]);
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(final SqlFileModifyQueryMeta queryMeta) {
        for (VariableElement variableElement : this.methodElement.getParameters()) {
            final QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement);
            queryMeta.addParameterMeta(parameterMeta);
            if (parameterMeta.isBindable()) {
                queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
            }
            if (queryMeta.getEntityCtType() != null) continue;
            parameterMeta.getCtType().accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
                    queryMeta.setEntityCtType(ctType);
                    queryMeta.setEntityParameterName(parameterMeta.getName());
                    return null;
                }
            }, null);
        }
    }
}

