/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import java.io.File;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.ScriptAnnot;
import org.seasar.doma.internal.apt.annot.SqlAnnot;
import org.seasar.doma.internal.apt.meta.query.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileScriptQueryMeta;
import org.seasar.doma.internal.jdbc.util.ScriptFileUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlFileScriptQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlFileScriptQueryMeta> {
    public SqlFileScriptQueryMetaFactory(RoundContext ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    @Override
    public QueryMeta createQueryMeta(AnnotationMirror annotation) {
        SqlFileScriptQueryMeta queryMeta = this.createSqlFileScriptQueryMeta(annotation);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doParameters(queryMeta);
        this.doThrowTypes(queryMeta);
        this.doSqlTemplate(queryMeta, false, false);
        return queryMeta;
    }

    private SqlFileScriptQueryMeta createSqlFileScriptQueryMeta(AnnotationMirror annotation) {
        SqlFileScriptQueryMeta queryMeta = new SqlFileScriptQueryMeta(this.daoElement, this.methodElement);
        ScriptAnnot scriptAnnot = this.ctx.getAnnotations().newScriptAnnot(annotation);
        if (scriptAnnot == null) {
            return null;
        }
        queryMeta.setScriptAnnot(scriptAnnot);
        queryMeta.setQueryKind(QueryKind.SQLFILE_SCRIPT);
        SqlAnnot sqlAnnot = this.ctx.getAnnotations().newSqlAnnot(this.methodElement);
        queryMeta.setSqlAnnot(sqlAnnot);
        return queryMeta;
    }

    @Override
    protected void doReturnType(SqlFileScriptQueryMeta queryMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        if (!returnMeta.isPrimitiveVoid()) {
            throw new AptException((MessageResource)Message.DOMA4172, this.methodElement, new Object[0]);
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(SqlFileScriptQueryMeta queryMeta) {
        if (!this.methodElement.getParameters().isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4173, this.methodElement, new Object[0]);
        }
    }

    @Override
    void doSqlTemplate(SqlFileScriptQueryMeta queryMeta, boolean expandable, boolean populatable) {
        SqlAnnot sqlAnnot = queryMeta.getSqlAnnot();
        if (sqlAnnot != null) {
            return;
        }
        String filePath = queryMeta.getPath();
        File file = this.getFile(filePath);
        File[] siblingFiles = this.getSiblingFiles(file);
        String methodName = queryMeta.getName();
        for (File siblingFile : siblingFiles) {
            if (!ScriptFileUtil.isScriptFile((File)siblingFile, (String)methodName)) continue;
            String fileName = siblingFile.getName();
            queryMeta.addFileName(fileName);
        }
    }
}

