/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.query;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.seasar.doma.SelectType;
import org.seasar.doma.Suppress;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.annot.SelectAnnot;
import org.seasar.doma.internal.apt.annot.SqlAnnot;
import org.seasar.doma.internal.apt.cttype.AggregateStrategyCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CollectorCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.FunctionCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SelectOptionsCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.internal.apt.meta.query.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.query.QueryKind;
import org.seasar.doma.internal.apt.meta.query.QueryMeta;
import org.seasar.doma.internal.apt.meta.query.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.query.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.query.SqlFileSelectQueryMeta;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlFileSelectQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlFileSelectQueryMeta> {
    public SqlFileSelectQueryMetaFactory(RoundContext ctx, TypeElement daoElement, ExecutableElement methodElement) {
        super(ctx, daoElement, methodElement);
    }

    @Override
    public QueryMeta createQueryMeta(AnnotationMirror annotation) {
        SqlFileSelectQueryMeta queryMeta = this.createSqlFileSelectQueryMeta(annotation);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta);
        this.doParameters(queryMeta);
        this.doReturnType(queryMeta);
        this.doThrowTypes(queryMeta);
        this.doSqlTemplate(queryMeta, queryMeta.isExpandable(), false);
        this.doAggregateStrategy(queryMeta);
        return queryMeta;
    }

    private SqlFileSelectQueryMeta createSqlFileSelectQueryMeta(AnnotationMirror annotation) {
        SelectAnnot selectAnnot = this.ctx.getAnnotations().newSelectAnnot(annotation);
        if (selectAnnot == null) {
            return null;
        }
        SqlFileSelectQueryMeta queryMeta = new SqlFileSelectQueryMeta(this.daoElement, this.methodElement);
        queryMeta.setSelectAnnot(selectAnnot);
        queryMeta.setQueryKind(QueryKind.SQLFILE_SELECT);
        SqlAnnot sqlAnnot = this.ctx.getAnnotations().newSqlAnnot(this.methodElement);
        queryMeta.setSqlAnnot(sqlAnnot);
        return queryMeta;
    }

    @Override
    protected void doParameters(SqlFileSelectQueryMeta queryMeta) {
        for (VariableElement variableElement : this.methodElement.getParameters()) {
            QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement);
            parameterMeta.getCtType().accept(new ParamCtTypeVisitor(queryMeta, parameterMeta), null);
            queryMeta.addParameterMeta(parameterMeta);
            if (!parameterMeta.isBindable()) continue;
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
        if (queryMeta.getSelectStrategyType() == SelectType.STREAM) {
            if (queryMeta.getFunctionCtType() == null) {
                throw new AptException((MessageResource)Message.DOMA4247, this.methodElement, new Object[0]);
            }
        } else if (queryMeta.getSelectStrategyType() == SelectType.COLLECT) {
            if (queryMeta.getCollectorCtType() == null) {
                throw new AptException((MessageResource)Message.DOMA4266, this.methodElement, new Object[0]);
            }
        } else if (queryMeta.getFunctionCtType() != null) {
            SelectAnnot selectAnnot = queryMeta.getSelectAnnot();
            throw new AptException((MessageResource)Message.DOMA4248, this.methodElement, selectAnnot.getAnnotationMirror(), selectAnnot.getStrategy(), new Object[0]);
        }
    }

    @Override
    protected void doReturnType(SqlFileSelectQueryMeta queryMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        queryMeta.setReturnMeta(returnMeta);
        if (queryMeta.getSelectStrategyType() == SelectType.STREAM) {
            FunctionCtType functionCtType = queryMeta.getFunctionCtType();
            CtType returnCtType = functionCtType.getReturnCtType();
            if (!this.ctx.getMoreTypes().isSameTypeWithErasure(returnMeta.getType(), returnCtType.getType())) {
                throw new AptException((MessageResource)Message.DOMA4246, this.methodElement, new Object[]{returnMeta.getType(), returnCtType.getType()});
            }
        } else if (queryMeta.getSelectStrategyType() == SelectType.COLLECT) {
            CollectorCtType collectorCtType = queryMeta.getCollectorCtType();
            CtType returnCtType = collectorCtType.getReturnCtType();
            if (!this.ctx.getMoreTypes().isSameTypeWithErasure(returnMeta.getType(), returnCtType.getType())) {
                throw new AptException((MessageResource)Message.DOMA4265, this.methodElement, new Object[]{returnMeta.getType(), returnCtType.getType()});
            }
        } else {
            returnMeta.getCtType().accept(new ReturnCtTypeVisitor(queryMeta), null);
        }
    }

    private void doAggregateStrategy(SqlFileSelectQueryMeta queryMeta) {
        TypeMirror aggregateStrategyType = queryMeta.getSelectAnnot().getAggregateStrategyValue();
        AggregateStrategyCtType aggregateStrategyCtType = this.ctx.getCtTypes().newAggregateStrategyCtType(aggregateStrategyType);
        if (aggregateStrategyCtType != null) {
            CtType returnCtType = queryMeta.getReturnMeta().getCtType();
            EntityCtType entityCtType = EntityCtType.resolveEntityCtType(returnCtType);
            if (entityCtType == null) {
                throw new AptException((MessageResource)Message.DOMA4473, this.methodElement, new Object[0]);
            }
            if (queryMeta.getSelectStrategyType() != SelectType.RETURN) {
                throw new AptException((MessageResource)Message.DOMA4484, this.methodElement, new Object[0]);
            }
            TypeMirror rootType = aggregateStrategyCtType.getAggregateStrategyAnnot().getRootValue();
            EntityCtType rootCtType = this.ctx.getCtTypes().newEntityCtType(rootType);
            if (rootCtType == null) {
                throw new AptException((MessageResource)Message.DOMA4479, this.methodElement, new Object[0]);
            }
            if (!entityCtType.isSameType(rootCtType)) {
                throw new AptException((MessageResource)Message.DOMA4480, this.methodElement, new Object[]{entityCtType.getQualifiedName(), rootCtType.getQualifiedName()});
            }
            queryMeta.setAggregateStrategyCtType(aggregateStrategyCtType);
        }
    }

    static class ParamCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final SqlFileSelectQueryMeta queryMeta;
        final QueryParameterMeta parameterMeta;

        ParamCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        public Void visitFunctionCtType(FunctionCtType ctType, Void p) throws RuntimeException {
            if (this.queryMeta.getFunctionCtType() != null) {
                throw new AptException((MessageResource)Message.DOMA4249, this.parameterMeta.getElement(), new Object[0]);
            }
            ctType.getTargetCtType().accept(new ParamFunctionTargetCtTypeVisitor(this.queryMeta, this.parameterMeta), null);
            this.queryMeta.setFunctionCtType(ctType);
            this.queryMeta.setFunctionParameterName(this.parameterMeta.getName());
            return null;
        }

        @Override
        public Void visitCollectorCtType(CollectorCtType ctType, Void p) throws RuntimeException {
            if (this.queryMeta.getCollectorCtType() != null) {
                throw new AptException((MessageResource)Message.DOMA4264, this.parameterMeta.getElement(), new Object[0]);
            }
            ctType.getTargetCtType().accept(new ParamCollectorTargetCtTypeVisitor(this.queryMeta, this.parameterMeta), null);
            this.queryMeta.setCollectorCtType(ctType);
            this.queryMeta.setCollectorParameterName(this.parameterMeta.getName());
            return null;
        }

        @Override
        public Void visitSelectOptionsCtType(SelectOptionsCtType ctType, Void p) throws RuntimeException {
            if (this.queryMeta.getSelectOptionsCtType() != null) {
                throw new AptException((MessageResource)Message.DOMA4053, this.parameterMeta.getElement(), new Object[0]);
            }
            this.queryMeta.setSelectOptionsCtType(ctType);
            this.queryMeta.setSelectOptionsParameterName(this.parameterMeta.getName());
            return null;
        }
    }

    class ReturnCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final SqlFileSelectQueryMeta queryMeta;
        final Suppress suppress;

        ReturnCtTypeVisitor(SqlFileSelectQueryMeta queryMeta) {
            this.queryMeta = queryMeta;
            this.suppress = queryMeta.getMethodElement().getAnnotation(Suppress.class);
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4008, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4154, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[]{ctType.getQualifiedName()});
            }
            this.queryMeta.setEntityCtType(ctType);
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitIterableCtType(IterableCtType ctType, Void p) throws RuntimeException {
            if (!ctType.isList()) {
                this.defaultAction((CtType)ctType, p);
            }
            ctType.getElementCtType().accept(new ReturnListElementCtTypeVisitor(this.queryMeta), p);
            return null;
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Void p) throws RuntimeException {
            if (!this.isSuppressed()) {
                SqlFileSelectQueryMetaFactory.this.ctx.getReporter().report(Diagnostic.Kind.WARNING, (MessageResource)Message.DOMA4274, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[0]);
            }
            this.queryMeta.setResultStream(true);
            ctType.getElementCtType().accept(new ReturnStreamElementCtTypeVisitor(this.queryMeta), p);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            ctType.getElementCtType().accept(new ReturnOptionalElementCtTypeVisitor(this.queryMeta), p);
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        boolean isSuppressed() {
            if (this.suppress != null) {
                for (Message suppressMessage : this.suppress.messages()) {
                    if (suppressMessage != Message.DOMA4274) continue;
                    return true;
                }
            }
            return false;
        }
    }

    class ReturnStreamOptionalElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        ReturnStreamOptionalElementCtTypeVisitor() {
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4267, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[]{type.getType()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    class ReturnListOptionalElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        ReturnListOptionalElementCtTypeVisitor() {
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4267, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    class ReturnOptionalElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final SqlFileSelectQueryMeta queryMeta;

        ReturnOptionalElementCtTypeVisitor(SqlFileSelectQueryMeta queryMeta) {
            this.queryMeta = queryMeta;
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4235, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4234, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
            }
            this.queryMeta.setEntityCtType(ctType);
            return null;
        }
    }

    class ReturnStreamElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final SqlFileSelectQueryMeta queryMeta;

        ReturnStreamElementCtTypeVisitor(SqlFileSelectQueryMeta queryMeta) {
            this.queryMeta = queryMeta;
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4271, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4272, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
            }
            this.queryMeta.setEntityCtType(ctType);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            ctType.getElementCtType().accept(new ReturnStreamOptionalElementCtTypeVisitor(), p);
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    class ReturnListElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final SqlFileSelectQueryMeta queryMeta;

        ReturnListElementCtTypeVisitor(SqlFileSelectQueryMeta queryMeta) {
            this.queryMeta = queryMeta;
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4007, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4155, SqlFileSelectQueryMetaFactory.this.methodElement, new Object[]{ctType.getType()});
            }
            this.queryMeta.setEntityCtType(ctType);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            ctType.getElementCtType().accept(new ReturnListOptionalElementCtTypeVisitor(), p);
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    static class ParamCollectorTargetCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final SqlFileSelectQueryMeta queryMeta;
        final QueryParameterMeta parameterMeta;

        ParamCollectorTargetCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4262, this.queryMeta.getMethodElement(), new Object[0]);
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4263, this.parameterMeta.getElement(), new Object[]{ctType.getType()});
            }
            this.queryMeta.setEntityCtType(ctType);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            Boolean valid = ctType.getElementCtType().accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(){

                @Override
                protected Boolean defaultAction(CtType ctType, Void p) throws RuntimeException {
                    return false;
                }

                @Override
                public Boolean visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
                    return true;
                }

                @Override
                public Boolean visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                    return true;
                }
            }, null);
            if (Boolean.FALSE == valid) {
                this.defaultAction((CtType)ctType, null);
            }
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    static class ParamFunctionTargetCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        final SqlFileSelectQueryMeta queryMeta;
        final QueryParameterMeta parameterMeta;

        ParamFunctionTargetCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4244, this.queryMeta.getMethodElement(), new Object[0]);
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(new StreamElementCtTypeVisitor(), null);
        }

        class StreamElementCtTypeVisitor
        extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
            StreamElementCtTypeVisitor() {
            }

            @Override
            protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4245, ParamFunctionTargetCtTypeVisitor.this.queryMeta.getMethodElement(), new Object[0]);
            }

            @Override
            public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
                return null;
            }

            @Override
            public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                return null;
            }

            @Override
            public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
                return null;
            }

            @Override
            public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
                if (ctType.isAbstract()) {
                    throw new AptException((MessageResource)Message.DOMA4250, ParamFunctionTargetCtTypeVisitor.this.parameterMeta.getElement(), new Object[]{ctType.getType()});
                }
                ParamFunctionTargetCtTypeVisitor.this.queryMeta.setEntityCtType(ctType);
                return null;
            }

            @Override
            public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
                Boolean valid = ctType.getElementCtType().accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(){

                    @Override
                    protected Boolean defaultAction(CtType ctType, Void p) throws RuntimeException {
                        return false;
                    }

                    @Override
                    public Boolean visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
                        return true;
                    }

                    @Override
                    public Boolean visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                        return true;
                    }
                }, null);
                if (Boolean.FALSE == valid) {
                    this.defaultAction((CtType)ctType, null);
                }
                return null;
            }

            @Override
            public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
                return null;
            }

            @Override
            public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
                return null;
            }

            @Override
            public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
                return null;
            }
        }
    }
}

