/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.generator.DomainTypeGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.JavaFileGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.domain.DomainMeta;
import org.seasar.doma.internal.apt.processor.ElementProcessorSupport;
import org.seasar.doma.internal.util.AssertionUtil;

class DomainProcessorSupport<M extends DomainMeta> {
    private final RoundContext ctx;
    private final ElementProcessorSupport<M> support;
    private final TypeElementMetaFactory<M> factory;

    DomainProcessorSupport(RoundContext ctx, Class<? extends Annotation> supportedAnnotationType, TypeElementMetaFactory<M> factory) {
        this.ctx = Objects.requireNonNull(ctx);
        this.support = new ElementProcessorSupport(ctx, supportedAnnotationType);
        this.factory = Objects.requireNonNull(factory);
    }

    List<M> process(Set<? extends Element> elements) {
        return this.support.processTypeElements(elements, this::processEach);
    }

    private M processEach(TypeElement typeElement) {
        DomainMeta meta = (DomainMeta)this.factory.createTypeElementMeta(typeElement);
        if (!meta.isError()) {
            this.generate(typeElement, meta);
        }
        return (M)meta;
    }

    private void generate(TypeElement typeElement, M meta) {
        JavaFileGenerator<DomainMeta> javaFileGenerator = new JavaFileGenerator<DomainMeta>(this.ctx, this::createClassName, this::createGenerator);
        javaFileGenerator.generate(typeElement, (DomainMeta)meta);
    }

    private ClassName createClassName(TypeElement typeElement, DomainMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        return ClassNames.newDomainTypeClassName((CharSequence)binaryName);
    }

    private Generator createGenerator(ClassName className, Printer printer, DomainMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new DomainTypeGenerator(this.ctx, className, printer, meta);
    }
}

