/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.Embeddable;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.generator.EmbeddableTypeGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.JavaFileGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.entity.EmbeddableMetaFactory;
import org.seasar.doma.internal.apt.processor.ElementProcessor;
import org.seasar.doma.internal.apt.processor.ElementProcessorSupport;
import org.seasar.doma.internal.util.AssertionUtil;

public class EmbeddableProcessor
implements ElementProcessor {
    private final RoundContext ctx;
    private final ElementProcessorSupport<EmbeddableMeta> support;
    private final EmbeddableMetaFactory factory;

    public EmbeddableProcessor(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
        this.support = new ElementProcessorSupport(ctx, Embeddable.class);
        this.factory = new EmbeddableMetaFactory(ctx);
    }

    @Override
    public void process(Set<? extends Element> elements) {
        this.support.processTypeElements(elements, this::processEach);
    }

    private EmbeddableMeta processEach(TypeElement typeElement) {
        EmbeddableMeta meta = this.factory.createTypeElementMeta(typeElement);
        if (!meta.isError()) {
            this.generate(typeElement, meta);
        }
        return meta;
    }

    private void generate(TypeElement typeElement, EmbeddableMeta meta) {
        JavaFileGenerator<EmbeddableMeta> javaFileGenerator = new JavaFileGenerator<EmbeddableMeta>(this.ctx, this::createClassName, this::createGenerator);
        javaFileGenerator.generate(typeElement, meta);
    }

    private ClassName createClassName(TypeElement typeElement, EmbeddableMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        Name binaryName = this.ctx.getMoreElements().getBinaryName(typeElement);
        return ClassNames.newEmbeddableTypeClassName((CharSequence)binaryName);
    }

    private Generator createGenerator(ClassName className, Printer printer, EmbeddableMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new EmbeddableTypeGenerator(this.ctx, className, printer, meta);
    }
}

