/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.processor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.ExternalDomain;
import org.seasar.doma.internal.ClassName;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.generator.ExternalDomainTypeGenerator;
import org.seasar.doma.internal.apt.generator.Generator;
import org.seasar.doma.internal.apt.generator.JavaFileGenerator;
import org.seasar.doma.internal.apt.generator.Printer;
import org.seasar.doma.internal.apt.meta.domain.ExternalDomainMeta;
import org.seasar.doma.internal.apt.meta.domain.ExternalDomainMetaFactory;
import org.seasar.doma.internal.apt.processor.ElementProcessor;
import org.seasar.doma.internal.apt.processor.ElementProcessorSupport;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class ExternalDomainProcessor
implements ElementProcessor {
    private final RoundContext ctx;
    private final ElementProcessorSupport<ExternalDomainMeta> support;
    private final ExternalDomainMetaFactory factory;
    private final Map<String, TypeElement> processed = new HashMap<String, TypeElement>();

    public ExternalDomainProcessor(RoundContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
        this.support = new ElementProcessorSupport(ctx, ExternalDomain.class);
        this.factory = new ExternalDomainMetaFactory(ctx);
    }

    @Override
    public void process(Set<? extends Element> elements) {
        List<ExternalDomainMeta> metaList = this.support.processTypeElements(elements, this::processEach);
        this.ctx.getExternalDomainMetaList().addAll(metaList);
    }

    private ExternalDomainMeta processEach(TypeElement typeElement) {
        ExternalDomainMeta meta = this.factory.createTypeElementMeta(typeElement);
        String key = meta.asType().toString();
        TypeElement anotherTypeElement = this.processed.get(key);
        if (anotherTypeElement != null) {
            throw new AptException((MessageResource)Message.DOMA4490, typeElement, new Object[]{key, typeElement, anotherTypeElement});
        }
        if (!meta.isError()) {
            this.generate(typeElement, meta);
        }
        this.processed.put(key, typeElement);
        return meta;
    }

    private void generate(TypeElement typeElement, ExternalDomainMeta meta) {
        JavaFileGenerator<ExternalDomainMeta> javaFileGenerator = new JavaFileGenerator<ExternalDomainMeta>(this.ctx, this::createClassName, this::createGenerator);
        javaFileGenerator.generate(typeElement, meta);
    }

    private ClassName createClassName(TypeElement typeElement, ExternalDomainMeta meta) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)meta);
        Name name = this.ctx.getNames().createExternalDomainName(meta.asType());
        return ClassNames.newExternalDomainTypeClassName((CharSequence)name);
    }

    private Generator createGenerator(ClassName className, Printer printer, ExternalDomainMeta meta) {
        AssertionUtil.assertNotNull((Object)className, (Object)meta, (Object)printer);
        return new ExternalDomainTypeGenerator(this.ctx, className, printer, meta);
    }
}

