/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.ProcessingContext;
import org.seasar.doma.internal.apt.RoundContext;
import org.seasar.doma.internal.apt.processor.AggregateStrategyProcessor;
import org.seasar.doma.internal.apt.processor.DaoProcessor;
import org.seasar.doma.internal.apt.processor.DataTypeProcessor;
import org.seasar.doma.internal.apt.processor.DomainConvertersProcessor;
import org.seasar.doma.internal.apt.processor.DomainProcessor;
import org.seasar.doma.internal.apt.processor.EmbeddableProcessor;
import org.seasar.doma.internal.apt.processor.EntityProcessor;
import org.seasar.doma.internal.apt.processor.ExternalDomainProcessor;
import org.seasar.doma.internal.apt.processor.ScopeProcessor;

@SupportedAnnotationTypes(value={"org.seasar.doma.AggregateStrategy", "org.seasar.doma.Dao", "org.seasar.doma.DataType", "org.seasar.doma.DomainConverters", "org.seasar.doma.Domain", "org.seasar.doma.Embeddable", "org.seasar.doma.Entity", "org.seasar.doma.ExternalDomain", "org.seasar.doma.Scope"})
@SupportedOptions(value={"doma.config.path", "doma.dao.package", "doma.dao.subpackage", "doma.dao.suffix", "doma.debug", "doma.domain.converters", "doma.entity.field.prefix", "doma.expr.functions", "doma.lombok.AllArgsConstructor", "doma.lombok.Value", "doma.metamodel.enabled", "doma.metamodel.prefix", "doma.metamodel.suffix", "doma.resources.dir", "doma.sql.validation", "doma.test", "doma.trace", "doma.version.validation"})
public class DomaProcessor
extends AbstractProcessor {
    private final List<Operator> operators = List.of(new Operator("org.seasar.doma.ExternalDomain", DomaProcessor::processExternalDomain), new Operator("org.seasar.doma.DataType", DomaProcessor::processDataType), new Operator("org.seasar.doma.Domain", DomaProcessor::processDomain), new Operator("org.seasar.doma.DomainConverters", DomaProcessor::processDomainConverters), new Operator("org.seasar.doma.Embeddable", DomaProcessor::processEmbeddable), new Operator("org.seasar.doma.Entity", DomaProcessor::processEntity), new Operator("org.seasar.doma.AggregateStrategy", DomaProcessor::processAggregateStrategy), new Operator("org.seasar.doma.Dao", DomaProcessor::processDao), new Operator("org.seasar.doma.Scope", DomaProcessor::processScope));
    private ProcessingContext processingContext;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingContext = new ProcessingContext(processingEnv);
        this.processingContext.init();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        RoundContext roundContext = new RoundContext(this.processingContext, roundEnv, annotations);
        roundContext.init();
        for (Operator operator : this.operators) {
            Set<? extends Element> elements = roundContext.getElementsAnnotatedWith(operator.name);
            if (elements.isEmpty()) continue;
            operator.consumer.accept(roundContext, elements);
        }
        return true;
    }

    private static void processAggregateStrategy(RoundContext roundContext, Set<? extends Element> elements) {
        AggregateStrategyProcessor processor = new AggregateStrategyProcessor(roundContext);
        processor.process(elements);
    }

    private static void processDao(RoundContext roundContext, Set<? extends Element> elements) {
        DaoProcessor processor = new DaoProcessor(roundContext);
        processor.process(elements);
    }

    private static void processDataType(RoundContext roundContext, Set<? extends Element> elements) {
        DataTypeProcessor processor = new DataTypeProcessor(roundContext);
        processor.process(elements);
    }

    private static void processDomainConverters(RoundContext roundContext, Set<? extends Element> elements) {
        DomainConvertersProcessor processor = new DomainConvertersProcessor(roundContext);
        processor.process(elements);
    }

    private static void processDomain(RoundContext roundContext, Set<? extends Element> elements) {
        DomainProcessor processor = new DomainProcessor(roundContext);
        processor.process(elements);
    }

    private static void processEmbeddable(RoundContext roundContext, Set<? extends Element> elements) {
        EmbeddableProcessor processor = new EmbeddableProcessor(roundContext);
        processor.process(elements);
    }

    private static void processEntity(RoundContext roundContext, Set<? extends Element> elements) {
        EntityProcessor processor = new EntityProcessor(roundContext);
        processor.process(elements);
    }

    private static void processExternalDomain(RoundContext roundContext, Set<? extends Element> elements) {
        ExternalDomainProcessor processor = new ExternalDomainProcessor(roundContext);
        processor.process(elements);
    }

    private static void processScope(RoundContext roundContext, Set<? extends Element> elements) {
        ScopeProcessor processor = new ScopeProcessor(roundContext);
        processor.process(elements);
    }

    private record Operator(String name, BiConsumer<RoundContext, Set<? extends Element>> consumer) {
        Operator {
            Objects.requireNonNull(name);
            Objects.requireNonNull(consumer);
        }
    }
}

