/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.tools.FileObject;
import org.seasar.doma.internal.Artifact;
import org.seasar.doma.internal.apt.Resources;
import org.seasar.doma.internal.util.AssertionUtil;

public final class Options {
    public static final String TEST = "doma.test";
    public static final String METAMODEL_ENABLED = "doma.metamodel.enabled";
    public static final String METAMODEL_PREFIX = "doma.metamodel.prefix";
    public static final String METAMODEL_SUFFIX = "doma.metamodel.suffix";
    public static final String DEBUG = "doma.debug";
    public static final String TRACE = "doma.trace";
    public static final String DAO_PACKAGE = "doma.dao.package";
    public static final String DAO_SUBPACKAGE = "doma.dao.subpackage";
    public static final String DAO_SUFFIX = "doma.dao.suffix";
    public static final String ENTITY_FIELD_PREFIX = "doma.entity.field.prefix";
    public static final String EXPR_FUNCTIONS = "doma.expr.functions";
    public static final String DOMAIN_CONVERTERS = "doma.domain.converters";
    public static final String SQL_VALIDATION = "doma.sql.validation";
    public static final String VERSION_VALIDATION = "doma.version.validation";
    public static final String CONFIG_PATH = "doma.config.path";
    public static final String RESOURCES_DIR = "doma.resources.dir";
    public static final String LOMBOK_ALL_ARGS_CONSTRUCTOR = "doma.lombok.AllArgsConstructor";
    public static final String LOMBOK_VALUE = "doma.lombok.Value";
    private final Map<String, String> options;

    Options(Map<String, String> options, Resources resources) {
        AssertionUtil.assertNotNull(options, (Object)resources);
        String path = Options.getConfigPath(options);
        Map<String, String> config = Options.loadConfig(resources, path);
        HashMap<String, String> map = new HashMap<String, String>(config);
        map.putAll(options);
        this.options = Collections.unmodifiableMap(map);
    }

    private static String getConfigPath(Map<String, String> options) {
        String configPath = options.get(CONFIG_PATH);
        return configPath != null ? configPath : "doma.compile.config";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> loadConfig(Resources resources, String path) {
        try {
            FileObject file = resources.getResource(path);
            if (file == null) {
                return Collections.emptyMap();
            }
            try (InputStream is = file.openInputStream();){
                HashMap<String, String> hashMap;
                try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    Properties props = new Properties();
                    props.load(isr);
                    HashMap<String, String> map = new HashMap<String, String>(props.size());
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        map.put(entry.getKey().toString(), entry.getValue().toString());
                    }
                    hashMap = map;
                }
                return hashMap;
            }
        }
        catch (IOException ignored) {
            return Collections.emptyMap();
        }
    }

    public boolean isTestEnabled() {
        String test = this.getOption(TEST);
        return Boolean.parseBoolean(test);
    }

    public String getVersion() {
        if (this.isTestEnabled()) {
            return "@VERSION@";
        }
        return Artifact.getVersion();
    }

    public boolean isMetamodelEnabled() {
        String enabled = this.getOption(METAMODEL_ENABLED);
        return Boolean.parseBoolean(enabled);
    }

    public String getMetamodelPrefix() {
        String prefix = this.getOption(METAMODEL_PREFIX);
        return prefix != null ? prefix : "";
    }

    public String getMetamodelSuffix() {
        String suffix = this.getOption(METAMODEL_SUFFIX);
        return suffix != null ? suffix : "_";
    }

    public Date getDate() {
        if (this.isTestEnabled()) {
            return new Date(0L);
        }
        return new Date();
    }

    public boolean isTraceEnabled() {
        String trace = this.getOption(TRACE);
        return Boolean.parseBoolean(trace);
    }

    public boolean isDebugEnabled() {
        String debug = this.getOption(DEBUG);
        return Boolean.parseBoolean(debug);
    }

    public String getDaoPackage() {
        return this.getOption(DAO_PACKAGE);
    }

    public String getDaoSubpackage() {
        return this.getOption(DAO_SUBPACKAGE);
    }

    public String getDaoSuffix() {
        String suffix = this.getOption(DAO_SUFFIX);
        return suffix != null ? suffix : "Impl";
    }

    public String getEntityFieldPrefix() {
        String prefix = this.getOption(ENTITY_FIELD_PREFIX);
        if ("none".equalsIgnoreCase(prefix)) {
            return "";
        }
        return prefix != null ? prefix : "$";
    }

    public String getExprFunctions() {
        return this.getOption(EXPR_FUNCTIONS);
    }

    public String getDomainConverters() {
        return this.getOption(DOMAIN_CONVERTERS);
    }

    public boolean getSqlValidation() {
        String v = this.getOption(SQL_VALIDATION);
        return v == null || Boolean.parseBoolean(v);
    }

    public boolean getVersionValidation() {
        String v = this.getOption(VERSION_VALIDATION);
        return v == null || Boolean.parseBoolean(v);
    }

    public String getLombokAllArgsConstructor() {
        String name = this.getOption(LOMBOK_ALL_ARGS_CONSTRUCTOR);
        return name != null ? name : "lombok.AllArgsConstructor";
    }

    public String getLombokValue() {
        String name = this.getOption(LOMBOK_VALUE);
        return name != null ? name : "lombok.Value";
    }

    private String getOption(String key) {
        return this.options.get(key);
    }

    public static class Constants {
        public static final String DEFAULT_METAMODEL_PREFIX = "";
        public static final String DEFAULT_METAMODEL_SUFFIX = "_";
        public static final String DEFAULT_DAO_SUFFIX = "Impl";
        public static final String DEFAULT_ENTITY_FIELD_PREFIX = "$";
        public static final String DEFAULT_CONFIG_PATH = "doma.compile.config";
        public static final String DEFAULT_LOMBOK_ALL_ARGS_CONSTRUCTOR = "lombok.AllArgsConstructor";
        public static final String DEFAULT_LOMBOK_VALUE = "lombok.Value";
    }
}

