/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.MoreElements;
import org.seasar.doma.internal.apt.MoreTypes;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.Reporter;
import org.seasar.doma.internal.apt.Resources;

public class ProcessingContext {
    private final ProcessingEnvironment env;
    private boolean initialized;
    private MoreElements moreElements;
    private MoreTypes moreTypes;
    private Options options;
    private Reporter reporter;
    private Resources resources;

    public ProcessingContext(ProcessingEnvironment env) {
        this.env = Objects.requireNonNull(env);
    }

    public void init() {
        if (this.initialized) {
            throw new AptIllegalStateException("already initialized");
        }
        this.moreElements = new MoreElements(this, this.env.getElementUtils());
        this.moreTypes = new MoreTypes(this, this.env.getTypeUtils());
        this.reporter = new Reporter(this.env.getMessager());
        this.resources = new Resources(this.env.getFiler(), this.env.getOptions().get("doma.resources.dir"));
        this.options = new Options(this.env.getOptions(), this.resources);
        this.initialized = true;
    }

    public MoreElements getMoreElements() {
        this.assertInitialized();
        return this.moreElements;
    }

    public MoreTypes getMoreTypes() {
        this.assertInitialized();
        return this.moreTypes;
    }

    public Options getOptions() {
        this.assertInitialized();
        return this.options;
    }

    public Reporter getReporter() {
        this.assertInitialized();
        return this.reporter;
    }

    public Resources getResources() {
        this.assertInitialized();
        return this.resources;
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new AptIllegalStateException("not yet initialized");
        }
    }
}

